#!/usr/bin/perl

###############################################################################
# PATHS HAVE TO BE SET TO MATCH LOCAL DIRECTORY STRUCTURE FOR THE TWO "require"
# STATEMENTS BELOW
###############################################################################

# The path has been hardcoded for the two files below. This is because
# pre-processing with the -P option messes things up in the 
# resAtomRecsNoSidechain function. Please provide full absolute paths (not
# realtive paths)

require "/home/aroop/simcode/antibody/scripts/readpdbline.pl" || die ( " File readpdbline.pl not found" ) ;
require "/home/aroop/simcode/antibody/scripts/ram_assignnumbering.pl" || die ( "File ram_assignnumbering.pl not found\n" ) ;

###############################################################################

if ( @ARGV < 2 ) {

print STDERR "Not enough arguments for script $0. Exiting...
Usage: perl -P $0 <pdbxxxx\_chothia.pdb> <chainID>\n " ;

die () ;

}

$pdbfile = shift @ARGV;
$chn = shift @ARGV;


@chainbreak = (24,50,89,1000) if($chn eq "L");
@chainbreak = (26,50,95,1000) if($chn eq "H");


open(pdbfile,$pdbfile) || die ( "PDB file $pdbfile not found\n" ) ;

&assignnumbering ; # Subroutine in ram_assignnumbering.pl


$line=<pdbfile>;
chop($line);
$counter=$lastatomno=$lastresidueno=0;
while($line ne ''){


if ($line =~ /ATOM/){

&readpdbline ( $line ) ;

if($chain eq $chn){

$breakpoint = $chainbreak[$counter];

if ($residueno < $breakpoint){

print "$line\n";

}else{

$lineold = $line;

&printblankcdrs($counter,$lastatomno,$chn);

print "$lineold\n"; # if u dont have this, then the CA atom just after the inserted CDR will not get printed.
$counter++;
}

}else{

print "$line\n";
}

}else{

print "$line\n";
}

$lastatomno = $atomno;
$lastresidueno = $residueno;


$line = <pdbfile>;
chop($line);

}

sub printblankcdrs {

my $counter = $_[0];
my $atomno = $_[1];
my $chn = $_[2];

if ($chn eq "L") {

$type = "l1" if ($counter == 0);
$type = "l2" if ($counter == 1);
$type = "l3" if ($counter == 2);

&readqueryfasta($type);

$string = $newnumberl1[$cdrlen] if ($counter == 0);
$string = $newnumberl2[$cdrlen] if ($counter == 1);
$string = $newnumberl3[$cdrlen] if ($counter == 2);
@array=split(/,/,$string);
}

if ($chn eq "H") {

$type = "h1" if ($counter == 0);
$type = "h2" if ($counter == 1);
$type = "h3" if ($counter == 2);

&readqueryfasta($type);

$string = $newnumberh1[$cdrlen] if ($counter == 0);
$string = $newnumberh2[$cdrlen] if ($counter == 1);
$string = $newnumberh3[$cdrlen] if ($counter == 2);
@array=split(/,/,$string);

}

$j = 0 ;

foreach $aminoacid(@sequence){

$residueno_new = @array[$j++];
$insert_code='';
$var = $residueno_new =~ /[A-Z]/;

if($var){
$insert_code=$&;
$residueno_new=substr($residueno_new,0,length($residueno_new)-1);
}



@atom_recs = &resAtomRecsNoSidechain ($aminoacid);

for ($i=0; $i <= $#atom_recs; ++$i) {

$val = $atom_recs[$i];

$atomno = $atomno+1;

substr ($atom_recs[$i], 6, 5) = sprintf ("%5s", $atomno);
substr ($atom_recs[$i], 22, 4) = sprintf ("%4d", $residueno_new);
substr ($atom_recs[$i], 21, 1) = sprintf ("%1s", $chn);
substr ($atom_recs[$i], 26, 1) = sprintf ("%1s", $insert_code);
$val = $atom_recs[$i];
print "$val\n";
}


}

}


sub readqueryfasta {

$type = $_[0];

$fasta = "query.".$type;
open(fasta,$fasta);

$line = <fasta>;
chop($line);

$line=<fasta>;
chop($line);

$string{$type}=$line;
$cdrlen = length($line);

@sequence = split(//,$string{$type});

return;

}


sub resAtomRecsNoSidechain {
my $code1 = $_[0];
my %code3 = (
'A' => 'ALA',
'C' => 'CYS',
'D' => 'ASP',
'E' => 'GLU',
'F' => 'PHE',
'G' => 'GLY',
'H' => 'HIS',
'I' => 'ILE',
'K' => 'LYS',
'L' => 'LEU',
'M' => 'MET',
'N' => 'ASN',
'P' => 'PRO',
'Q' => 'GLN',
'R' => 'ARG',
'S' => 'SER',
'T' => 'THR',
'V' => 'VAL',
'W' => 'TRP',
'Y' => 'TYR'
);

my $lines = qq{
ATOM   atmi  N   cod  resi       1.000   1.000   1.000  1.00  1.00
ATOM   atmi  CA  cod  resi       1.000   1.000   1.000  1.00  1.00
ATOM   atmi  C   cod  resi       1.000   1.000   1.000  1.00  1.00
ATOM   atmi  O   cod  resi       1.000   1.000   1.000  1.00  1.00
};
$lines =~ s/cod/$code3{$code1}/g;
$lines =~ s/^\s+|\s+$//g;
return split (/\n/, $lines);
}




