#!/usr/local/bin/perl
use Cwd ;

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"


if ( @ARGV < 25 ) {

print STDERR "Not enough arguments for script $0. Exiting...\n Usage: perl -P $0 <pdbxxxx\_chothia.pdb> <bit/pid> <frameworktemplate:xtal|ram> <cdrtemplate:xtal|ram> <run_blast_prep:0|1> <run_blast_matches:0|1> <run_get_error:0|1> <template_creation:0|1> <rosetta_graft_loop:0|1> <just_idealize_native> <native_h3_reconstruct:1|0> <rosetta_make_fragments:0|1> <rosetta_build_loops:0|1> <rosetta_post_process_build> <rosetta_cluster_loops> <rosetta_refine_loops:0|1>  <eliminate_natives|1:0=yes:no> <which_framework:FR01|FR02> <vlvhalignment:1|2> <deep_graft:0|1> <h3_fragment_type:1|2|3> <nstruct_build> <nstruct_refine> <additional_flags:1|2|3 = regular|w_snugfit_wo_snugfit> <pdb_input:1|0 = pdb|fasta> <fastafile_lightchain> <fastafile_heavychain> \n " ;

die () ;

}

require "$scripts/ram_kink_query.pl" ;

$chainL = "L" ;
$chainH = "H" ;

$currentdir = getcwd ( ) ;

$pdb = shift @ARGV;
$criterion = shift @ARGV ;
$frameworktemplate = shift @ARGV ;
$cdrtemplate = shift @ARGV ;
$run_blast_prep = shift @ARGV ;
$run_blast_matches = shift @ARGV ;
$run_get_error = shift @ARGV ;
$template_creation = shift @ARGV ;
$rosetta_graft_loop = shift @ARGV ;
$just_idealize_native = shift @ARGV ;
$native_h3_reconstruct = shift @ARGV ;
$rosetta_make_fragments = shift @ARGV ;
$rosetta_build_loops = shift @ARGV ;
$rosetta_post_process_build = shift @ARGV ;
$rosetta_cluster_loops = shift @ARGV ;
$rosetta_refine_loops = shift @ARGV ;
$eliminate_natives = shift @ARGV ;
$which_framework = shift @ARGV ;
$vlvhalignment = shift @ARGV ;
$deep_graft = shift @ARGV ;
$h3_fragment_type = shift @ARGV ;
$nstruct_build = shift @ARGV ;
$nstruct_refine = shift @ARGV ;
$additional_flags = shift @ARGV ;
$pdb_input = shift @ARGV ;
$fastafile_light = shift @ARGV ;
$fastafile_heavy = shift @ARGV ;

$fasta_input = 1 unless ( $pdb_input ) ;

if ($fasta_input) {

		if ( $fastafile_light eq '' || $fastafile_heavy eq '' ) {

				die ( "Exiting. Fasta_input chosen, but fastafile_light or fastafile_heavy not provided\n" ) ;

		}

}

#Hardcoded variable values

$nstruct_grafting = 1 ;
$rosetta_3mer_fragments = "rosetta_3mer_fragments" ;
$ab_3mer_fragments = "ab_3mer_fragments" ;
$fragments_h3_94_103 = "fragments_h3_94_103" ;
$ab_fragment_resol_threshold = 2.5 ;

#End hardcoded variable values

$pdbcode = substr ( $pdb , 3 , 4 ) ;
$wam_name = "wam$pdbcode\_chothia.pdb" ;
$pdbdir = "$currentdir/$pdbcode" ;
#$build_loop_dir = "$pdbdir/build" ;
$build_loop_dir = "$currentdir/build" ;
$refine_loop_dir = "$currentdir/refine" ;

#system2("mkdir -p $pdbdir") unless -e $pdbdir ;
system2("mkdir -p $build_loop_dir" );


# system2("mkdir -p $refine_loop_dir" );

#system2("cp $fastafile_light $pdbdir/query_l.fasta" ) ;
#system2("cp $fastafile_heavy $pdbdir/query_h.fasta" ) ;

#chdir ( "$pdbdir" ) || die ( "Exiting. Unable to change to directory $pdbdir\n" ) ;

system2("cp $WAMmodels/$wam_name .") if ( -e "$WAMmodels/$wam_name" && $pdb_input ) ;

system2( "pwd");
#system2 ("cp $scripts/rampaths.txt .");
system2( "cp $scripts/paths.txt paths.txt" ) ;
#system2 ( "cp $scripts/utilities.txt ." );
unlink ( "errorlog" ) ;


open ( parameter , ">parameter" ) || die ( "File parameter not found" ) ;
printf parameter "Input PDB: $pdbcode \n Criterion: $criterion\n rosetta_graft_loop: $rosetta_graft_loop\n" ;

&do_blast_prep if ( $run_blast_prep ) ;

&get_blast_matches if ( $run_blast_matches ) ;

&get_error if ( $run_get_error ) ;
&create_template if ( $template_creation ) ;

&graft_canonical_loops if ( $rosetta_graft_loop ) ;

&just_idealize_native if ( $just_idealize_native ) ;

&make_fragments if ( $rosetta_make_fragments ) ;

&build_rosetta_loops if ( $rosetta_build_loops ) ;

&post_process_build if ( $rosetta_post_process_build ) ;

&cluster_built_loops if ( $rosetta_cluster_loops ) ;

&refine_rosetta_loops if ( $rosetta_refine_loops ) ;






sub do_blast_prep {


		system2("perl -P $scripts/ram_create_query_fasta.pl $pdb $chainL $chainH" ) if ( $pdb_input ) ;

system2("perl -P $scripts/ram_mapping1.pl" );
system2("perl -P $scripts/ram_create_query_database.pl" );
system2("perl -P $scripts/ram_create_query_database_lightheavy.pl" );
}

sub get_blast_matches {

system2("perl -P $scripts/ram_blastscript.pl" );
system2("perl -P $scripts/ram_id_perfect_matches.pl" );
system2("perl -P $scripts/ram_analyze_blast8.pl $pdb $criterion $eliminate_natives" );

}

sub get_error {
if ( -e "errorlog" ) {
printf STDERR "No sequence matches for one or more regions \n  Exiting homology modeling protocol\n" ;
system2("cat errorlog" );
die ( ) ;

}

}

sub create_template {

system2( "echo TER > terfile" ) ;
print "arvind $criterion $frameworktemplate $cdrtemplate $pdb\n" ;

system2("perl -P $scripts/ram_copytemplates1.pl $pdb_input $criterion $frameworktemplate $cdrtemplate $pdb" );


system2("perl -P $scripts/ram_mutate_pdb2.pl $criterion" );
if ( $vlvhalignment == 1 ) {

# Superimpose lfr match onto the light chain of the hfr match pdb to create queryLfitted.pdb

if ( $which_framework eq "FR01" ) {

system2("perl -P $scripts/ram_profit_script.pl templateL.pdb queryH.pdb heavy > profit.in" );
system2("profit < profit.in >> profit.out" );
system2("grep Error profit.out" );

system2("cat queryL.pdb queryHfitted.pdb > FR01_nocdr.pdb" );
system2("$scripts/ram_blankcdrs.pl FR01_nocdr.pdb L > FR01_Lcdr.pdb" );
system2("$scripts/ram_blankcdrs.pl FR01_Lcdr.pdb H > FR01.pdb" );

} elsif ( $which_framework eq "FR02" ) {

system2("perl -P $scripts/ram_profit_script.pl templateH.pdb queryL.pdb light > profit.in" );
system2("profit < profit.in > profit.out" );
system2("grep Error profit.out" );

system2("cat queryLfitted.pdb queryH.pdb > FR02_nocdr.pdb" );
system2("$scripts/ram_blankcdrs.pl FR02_nocdr.pdb L > FR02_Lcdr.pdb" );
system2("$scripts/ram_blankcdrs.pl FR02_Lcdr.pdb H > FR02.pdb" );

}

} elsif ( $vlvhalignment == 2 ) {

if ( $which_framework eq "FR01" ) {

system2("perl -P $scripts/ram_profit_script.pl templatelfrhfr.pdb queryL.pdb light > profit.in" );
system2("profit < profit.in > profit.out" );
system2("grep Error profit.out" );

system2("perl -P $scripts/ram_profit_script.pl templatelfrhfr.pdb queryH.pdb heavy > profit.in" );
system2("profit < profit.in >> profit.out" );
system2("grep Error profit.out" );

system2("cat queryLfitted.pdb queryHfitted.pdb > FR01_nocdr.pdb" );
system2("$scripts/ram_blankcdrs.pl FR01_nocdr.pdb L > FR01_Lcdr.pdb" );
system2("$scripts/ram_blankcdrs.pl FR01_Lcdr.pdb H > FR01.pdb" );

} elsif ( $which_framework eq "FR02" ) {
system2("perl -P $scripts/ram_profit_script.pl templatelightheavy.pdb queryL.pdb light > profit.in" );

system2("profit < profit.in > profit.out" );
#system2("grep Error profit.out" );
system2("perl -P $scripts/ram_profit_script.pl templatelightheavy.pdb queryH.pdb heavy > profit.in" );
system2("profit < profit.in >> profit.out" );
#system2("grep Error profit.out" );
system2("cat queryLfitted.pdb queryHfitted.pdb > FR02_nocdr.pdb" );
system2("$scripts/ram_blankcdrs.pl FR02_nocdr.pdb L > FR02_Lcdr.pdb" );
system2("$scripts/ram_blankcdrs.pl FR02_Lcdr.pdb H > FR02.pdb" );
}

}
system2("perl -P $scripts/ram_setup_rrun2.pl $pdb_input $pdb $criterion $deep_graft" );

if ( $pdb_input ) {
system2("perl -P $scripts_alt/extractres.pl L 4 105 $pdb > nativeL.pdb " ) ;
system2("perl -P $scripts_alt/extractres.pl H 4 110 $pdb > nativeH.pdb " ) ;
system2("cat nativeL.pdb terfile nativeH.pdb terfile > $pdbcode.pdb" );
}

$try_something_else = 0 ;
if ( $try_something_else ) {
system2("perl -P $scripts_alt/extractres.pl L 4 105 $pdb > nativeL.pdb " );
system2("perl -P $scripts_alt/extractres.pl H 4 110 $pdb > nativeH.pdb " );
system2("$bin/rosetta.gcc aa $pdbcode L -idealize -s nativeL.pdb " );
system2("$bin/rosetta.gcc aa $pdbcode H -idealize -s nativeH.pdb -nstruct 5" );
system2("ln -s aanativeL_0001.pdb nativeL_idealized.pdb" );
system2("ln -s aanativeH_0001.pdb nativeH_idealized.pdb" );
system2("cat nativeL_idealized.pdb nativeH_idealized.pdb > native_idealized.pdb" );
system2("ln -s native_idealized.pdb $pdbcode.pdb" );
}






}

sub graft_canonical_loops {

printf STDERR "START LOOP GRAFTING: $pdb\n" ;
#system2("python $docking_scripts/pdb_scripts/makefixdisulf.py $which_framework.pdb" );

system2("$scripts/pdb_cleaner.pl $which_framework | tee temp.pdb" );
system2("mv temp.pdb $which_framework.pdb" );

unless ( $native_h3_reconstruct ) {
system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -l1 -l2 -l3 -h1 -h2 -superimpose -deep 2 -use_pdb_numbering -ccd_closure -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile") ;

} else {

$native_wo_h3 = "$pdbcode\_L_noh3.pdb" ;
system2("$scripts_alt/extractChains.pl L $pdbcode.pdb > $native_wo_h3" );
system2("$scripts_alt/extractres.pl H 4 94 $pdbcode.pdb >> $native_wo_h3" );
system2("$scripts_alt/extractres.pl H 103 110 $pdbcode.pdb >> $native_wo_h3" );
system2("$scripts/ram_blankcdrs_h3.pl $native_wo_h3 H > FR02.pdb" );
system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -use_pdb_numbering -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile");

}
printf STDERR "END LOOP GRAFTING: $pdb\n" ;

system2("python $docking_scripts/pdb_scripts/makefixdisulf.py aa$which_framework\_0001.pdb" );
if( -e "aa$which_framework\_0001.fixdisulf" ) {
	system2("mv aa$which_framework\_0001.fixdisulf $which_framework.fixdisulf" );
}

# Housekeeping
system2( "cp $which_framework.pdb $which_framework.pdb.template" ) ;
system2( "cp aa$which_framework\_0001.pdb $which_framework.pdb" ) ;
system2( "cp aa$which_framework\_0001.pdb pdb$which_framework\_chothia.pdb" ) ;
# End Housekeeping

}

sub just_idealize_native {

$mode = "just_idealize" ;
chdir ( "$build_loop_dir" ) ;
system2("ln -s $scripts/rampaths.txt .") unless -e "rampaths.txt" ;
system2("ln -s $pdbdir/$which_framework.pdb .") unless -e "$which_framework.pdb" ;
system2("ln -s $scripts/paths.txt paths.txt") unless -e "paths.txt" ;
system2("ln -s $pdbdir/hfr.pdb ." );
system2("ln -s $pdbdir/lfr.pdb ." );

system2("ln -s $pdbdir/$pdbcode.pdb .") unless -e "$pdbcode.pdb" ;

system2("perl -P $scripts/ram_create_condor_script.pl $pdbcode $which_framework $mode $nstruct_build $additional_flags" );
#		system2("$bin/rosetta.gcc aa $which_framework  _ -nstruct 1 -antibody_modeler -quiet -h3 -ex1aro -ex2aro_only -find_disulf -norepack_disulf -unboundrot -use_pdb_numbering -ccd_closure -s $which_framework -native $pdbcode -norepack_antibody -loop_frags -build_loop -max_frags 230 -compute_hbond -idealize_native" );
}


sub make_fragments {

$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3" ;
$fragment_file_9 = "aa$which_framework\_09\_05.200\_v1\_3" ;

#system2( "rm -fr $build_loop_dir/$fragment_file $build_loop_dir/$fragment_file_9" ) ;

if ( $h3_fragment_type == 1 ) {

&make_rosetta_fragments ;
system2( "ln -s $rosetta_3mer_fragments $fragment_file" ) ;

} elsif ( $h3_fragment_type == 2 ) {

&make_antibody_fragments ;
system2( "ln -s $ab_3mer_fragments $fragment_file" ) ;
system2( "ln -s $rosettafrags/$pdbcode$fragment_file_9 $fragment_file_9" ) ;

} elsif ( $h3_fragment_type == 3 ) {

&make_rosetta_fragments ;
&make_antibody_fragments ;
system2("perl -P $scripts/ram_append_abfrags_to_rosettafrags2.pl $which_framework\_.fasta $rosetta_3mer_fragments $ab_3mer_fragments > $fragment_file");

}

}



sub make_rosetta_fragments {

chdir ( "$build_loop_dir" ) || die ( "Exiting. Unable to change to directory \'$build_loop_dir\'" ) ;

$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3" ;

system2("cp $scripts/rampaths.txt .") unless -e "rampaths.txt" ;
#system2("cp $pdbdir/$which_framework.pdb .") unless -e "$which_framework.pdb" ;
system2("cp ../$which_framework.pdb .") unless -e "$which_framework.pdb" ;
system2("cp $scripts/paths.txt  paths.txt")  unless -e "paths.txt" ;
system2("cp $scripts/utilities.txt .") ;
unless ( -e $rosetta_3mer_fragments ) {

print "Making fragments for heavy chain residues 94-103...\n" ;
system2("perl -P $scripts/ram_make_rosetta_fragments.pl $which_framework|tee rosetta$which_framework\_frags.logfile");
system2("mv $fragment_file $rosetta_3mer_fragments" );
print "Done\n" ;
}

unless ( -e $fragment_file ) {



#	print "Appending antibody fragments to rosetta fragments...\n" ;
#	system2("perl -P $scripts/ram_append_abfrags_to_rosettafrags.pl $which_framework)\_.fasta $rosetta_3mer_fragments $fragments_h3_94_103 $ab_fragment_resol_threshold > $fragment_file" ;
#	print "Appending fragments Done\n" ;

}
}


sub make_antibody_fragments {

chdir ( "$build_loop_dir" ) || die ( "Exiting. Unable to change to directory \'$build_loop_dir\'" ) ;

$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3" ;
system2("ln -s $scripts/rampaths.txt .") unless -e "rampaths.txt"  ;
system2("ln -s $pdbdir/$which_framework.pdb .") unless -e "$which_framework.pdb" ;
system2("ln -s $scripts/paths.txt  paths.txt")  unless -e "paths.txt" ;


system2("$scripts_alt/extractres.pl H 94 103 $which_framework.pdb > h3plus1.pdb" );
system2("$docking_scripts/pdb_scripts/pdb_fasta.pl h3plus1.pdb simple > $which_framework\_.fasta");

system2("perl -P $scripts/ram_blastscript_h3frag.pl 3 0" );
system2("perl -P $scripts/ram_analyze_blast_h3frag.pl $pdb 3 0.2" );
}




sub build_rosetta_loops {

$mode = "build" ;
chdir ( "$build_loop_dir" ) ;
#system2( "ln -s $pdbdir/$pdbcode.pdb ." ) unless ( -e "$pdbcode.pdb" && $pdb_input) ;
system2( "cp $currentdir/hfr.pdb . " ) unless ( -e "hfr.pdb" ) ;

system2( "cp $currentdir/lfr.pdb . " ) unless ( -e "lfr.pdb" ) ;

system2( "perl -P $scripts/ram_create_H3CterNter2.pl $pdb" ) ;
system2( "perl -P $scripts/ram_create_condor_script.pl $pdbcode $which_framework $mode $nstruct_build $additional_flags" ) ;

}

sub post_process_build {

&kink_query ( "L" , "H" ) ;
chdir ( "$build_loop_dir" ) ;
system2("pwd" );
system2("perl -P $scripts/ram_copy_scorefiles2.pl $pdb $kinked $extended" );

}

sub cluster_built_loops {
$h3_build_cluster_radius = 1.0 ;
$gap_broken_threshold = 1.9 ;
$run = "01" ; #Allows for different loops, 01 , 02 etc...
$loop_library = "$which_framework\_loop_library\_$run" ;
chdir ( "$build_loop_dir" ) ;

$scorefile = "aa$which_framework\_unique.fasc" ;
$scorefile_unbroken = "aa$which_framework\_unbroken.fasc" ;
$profit_inputfile = "profit\_h3.in" ;
$profit_outputfile = "profit\_h3.out" ;
$h3rmstable = "rms.table" ;
$decoylist = "decoylist" ;
$top200pdb = "top200" ;
$top200pdbh3 = "top200h3" ;
$top200score = "top200score" ;
$min_decoys_in_ten_largest = 50 ; #EK originally 50
$centersbysize = "centers.bysize" ;

print "Clustering for PDB $pdbcode\n" ;

system2 ( "perl -P $scripts/ram_rm_scorefile_repeat_decoys.pl $pdb $which_framework" ) ;


system2( "cut -c 1-15 $scorefile|grep aaFR  > $decoylist" ) ;
system2( "awk '{if(\$8 <= $gap_broken_threshold ) print \$0}' $scorefile > $scorefile_unbroken" ) ;
system2( "sort -n +1 $scorefile_unbroken|grep aaFR|head -200|cut -c 1-15 > $top200pdb" ) ;
system2( "sort -n +1 $scorefile_unbroken|grep aaFR|head -200|cut -c 1-31 > $top200score" ) ;

print "Extracting H3 loop residues...\n" ;
system2( "perl -P $scripts/ram_extract_h3_ca.pl $top200pdb" ) ;
print "Calculating H3 rmsd...\n" ;
system2( "perl -P $scripts/ram_calc_h3_rmsd_wrapper.pl $top200pdb H 95 103" ) ;
#system2( "rm -fr *h3.pdb" ) ;

$clusters_large_enough = 0 ;

#until ( $clusters_large_enough ) {
for($i=0; $i<10 and !$clusters_large_enough; $i++) {
print "got here large enough\n" ;
system2( "perl -P $scripts/ram_clustersbyscore.pl $pdbcode $h3rmstable $h3_build_cluster_radius $top200score" ) ;
$decoys_in_ten_largest = `head -10 $centersbysize |awk '{sum = sum + \$3} END {print sum}'` ;
chop ( $decoys_in_ten_largest ) ;
print "$decoys_in_ten_largest members in the ten largest clusters for a clustering radius of $h3_build_cluster_radius ...\n" ;

if ( $decoys_in_ten_largest >= $min_decoys_in_ten_largest ) {
$clusters_large_enough = 1 ;
} else {
$h3_build_cluster_radius = $h3_build_cluster_radius * 1.1 ;
}
}

#system2("cp cluster.ps Cluster.ps" );
system2("$scripts_alt/clusterscoresbysize.pl" );
#system2( "perl -P $scripts/ram_cat_loop_library2.pl $pdb $nstruct_build $which_framework $loop_library" ) ;
print "...Done\n" ;
}

sub refine_rosetta_loops {

$mode = "refine" ;
$run= "01" ;
$loop_library = "$which_framework\_loop_library\_$run" ;
chdir ( "$refine_loop_dir" ) ;

link ( "$scripts/rampaths.txt" , "rampaths.txt" )  unless ( -e "rampaths.txt" ) ;
link ( "$pdbdir/$which_framework.pdb" , "$which_framework.pdb" ) unless ( -e "$which_framework.pdb" ) ;
link ( "$scripts/paths.txt" , "paths.txt" ) unless ( -e "paths.txt" ) ;

system2( "ln -s $build_loop_dir/$loop_library ." ) unless ( -e $loop_library ) ;
system2( "ln -s $build_loop_dir/centers* ." ) ;
system2( "ln -s $pdbdir/$pdbcode.pdb ." ) ;
system2( "ln -s $pdbdir/hfr.pdb ." ) ;
system2( "perl -P $scripts/ram_create_condor_script.pl $pdbcode $which_framework $mode $nstruct_refine $additional_flags" ) ;

}
