#!/usr/bin/perl

if ( @ARGV < 4 ) {

die ( "Exiting. Not enough arguments. Usage: perl -P $0 <position in fragment file> <which_framework> <count> <outfile>\n" ) ;

}

#include "rampaths.txt"

$position = shift @ARGV ;
$which_framework = shift @ARGV ;
my $count = shift @ARGV ;
my $outfile = shift @ARGV ;
$ab_fragment_file = "fragments_h3_94_103_3" ;
$fragment_path = "$fragments/$ab_fragment_file" ;

&get_cluster_parents ( $count , $outfile ) ;

$fragment_count = @parentlist ;

print "Number of fragments is $fragment_count\n" ;

foreach $parent ( @parentlist ) {

$prefix = substr ( $parent , 0 , length ( $parent ) - 4 ) ;

( $fragment , $pdbcode , $fragment_size , $which_cdr , $length_h3 , $resnum_range ) = split ( /\_/ , $prefix ) ;

#    $fragment_file_output = "aa$which_framework\_0$fragment_size\_05.200_v1_3" ;
$fragment_file_output = "ab_3mer_fragments" ;
open ( fragment_file_output , ">>$fragment_file_output" ) ;

@residuelist = split ( /\-/ , $resnum_range ) ;

$fragment_match = `grep $pdbcode $fragment_path |grep $fragment` ;

$first = substr ( $fragment_match , 0 , 44 ) ;
$second = substr ( $fragment_match , 45 , 44 ) ;
$third = substr ( $fragment_match , 90 , 44 ) ;


$ss_orig1 = substr ( $first , 16 , 1 ) ;
$ss_orig2 = substr ( $second , 16 , 1 ) ;
$ss_orig3 = substr ( $third, 16 , 1) ;

substr ( $first , 16 , 1 ) = "L" if ( $ss_orig1 ne "H" && $ss_orig1 ne "E" ) ;
substr ( $second , 16 , 1 ) = "L" if ( $ss_orig2 ne "H" && $ss_orig2 ne "E" ) ;
substr ( $third , 16 , 1 ) = "L" if ( $ss_orig3 ne "H" && $ss_orig3 ne "E" ) ;


if ( $fragment_count != 0 ) {
printf fragment_file_output " %9s%13d %10s%13d\n\n","position:",$position,"neighbors:",$fragment_count unless ( $printedheader ++ ) ;
} else {

die ( "Exiting...No fragments found for position $position\n") ;
}
printf  fragment_file_output "$first\n$second\n$third\n\n" ;

}

sub get_cluster_parents {

my $count = $_[0] ;
my $outfile = $_[1] ;

system2("rm -fr cluster*")  ;

if ( $count == 1 ) {

open ( file, $outfile ) || die ("File $outfile not found\n" ) ;
$line = <file> ;
chop ( $line ) ;
while ( $line ne '' ) {
push @parentlist , $line ;
$line = <file> ;
chop ( $line ) ;
}

close(file) ;
return ;
}


open(file,"tmp.clusters") ;
$line=<file> ;
chop($line) ;

while ( $line ne '' ) {

($pdbfile,$clusternumber)=split(/ +/,$line)  ;

$handle="clusterhandle.$clusternumber" ;
$file="cluster$clusternumber"  ;
open($handle,">$file") unless(-e $file)  ;

if(! $number[$clusternumber])  {

$totalclusters++ ;
$index[$totalclusters]=$clusternumber  ;

}

$number[$clusternumber]++  ;
push @parentlist,$pdbfile.".pdb" unless($assigned[$clusternumber]++) ;

$line=<file> ;
chop($line) ;

}
close ( file ) ;
}
