#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

if ( @ARGV < 1 ) {

print STDERR "Not enough arguments for script $0. Exiting...Usage: perl -P $0 <pdb> \n " ;

die () ;

}

@excluded_broken = ( "1fn4" , "2gfb" , "1rzi" , "2fgw" ) ;
@excluded_poor_kink = ( "1dsf" , "1ikf" , "1lo0" , "1lo4" , "1hil" , "1l7t" , "1seq" , "1fig" , "1qnz" , "1mfe" , "1dlf", "1fe8" ) ;
@excluded_individual = ( "1eap" , "1i7z" , "1um5" , "2pcp" ) ;

@excluded = ( @excluded_broken , @excluded_poor_kink , @excluded_individual ) ;
@extended = ( "25c8" , "1a3r" , "1c12" , "1dqd" , "1kn2" , "1mj8" , "1yed" , "1yee" , "43c9" , "1f8t" , "1il1" , "1mnu" , "1wej" , "1aif" , "1d5i" , "1ken" , "32c2" , "1mh5" , "1t4k" , "1uz8" , "1eo8" , "1ncw" , "1uwe" ,"1cf8" , "1mju" , "1yqv" , "1h3p" , "1axt" , "4fab" , "1t66" ) ;


open ( H3_CTERM , ">H3_CTERM" ) || die ( "Exiting. Unable to open file H3\_CTERM\n" ) ;#output file placed in info directory
open ( H3_NTERM , ">H3_NTERM" ) || die ( "Exiting. Unable to open file H3\_NTERM\n" ) ;



$heavychain = "H" ;

require "$scripts/readinfo.pl";
require "$scripts/readdsspline.pl" ;
require "$scripts/get_cterm_residues.pl" ;
require "$scripts/read_h3pseudodihedral.pl" ;
require "$scripts/ram_members_of_list.pl" ;
&readinfo ; # Subroutine in readinfo.pl ;
&read_h3pseudodihedral ; # Subroutine in read_h3pseudodihedral.pl ;


$list = "$idealized/list_fv_w_eliminations_nonrdnt_h3_0" ;
$pdb = shift @ARGV ;

$Sequence_h3 = $Seq { $pdb."h3" } ;

open ( list , $list ) || die ( "Exiting. File $list not found\n" ) ;


$filename = <list> ;

chop ( $filename ) ;

while ( $filename ne '' ) {

#get some details

$lenh3 = $Length { $filename."h3" } ;
$resol = $resol { $filename } ;
$sequence_h3_match = $Seq { $filename."h3" } ;

$filter_h3_length = $lenh3 >= 7 ;
$filter_h3_sequence = $Sequence_h3 ne $sequence_h3_match ;
$filter_resol = $resol <= 2.8 ;
$filter_excluded = ! &members_of_list ( $filename , @excluded ) ;
$filter_extended = &members_of_list ( $filename , @extended ) ;

$filter = $filter_h3_sequence && $filter_excluded && $filter_h3_length && $filter_resol ;

if ( $filter ) {


if ( &members_of_list ( $filename , @extended ) ) {

$h3base = "EXTENDED" ;
} else {

$h3base = "KINK" ;
}

#get the residue numbers in the H3 C-terminus

&get_cterm_residues ( $lenh3 ) ; #Subroutine in file get_cterm_residues.pl


#get the name of the dssp file corresponding to the filename and  read the information
$prefix = substr ( $filename , 0 , length ( $filename ) - 4 ) ;
$DSSPFILE = $prefix.".dssp" ;
$DSSPPATH = "$dsspfiles/$DSSPFILE" ;
open ( DSSPPATH , $DSSPPATH ) || die ( "Exiting. File $DSSPFILE not found\n" ) ;


$lineskip = <DSSPPATH> ;

$line = <DSSPPATH> ;
chop ( $line ) ;

while ( $line ne '' ) {

&readdsspline ( $line ) ;

if ( $chain eq $heavychain ) {

# The array cterm_residues contains residues n-3, n-2, n-1, n and n+1 of the CDR H3 (CDR H3 == 1 to n )
if ( $residueno eq $cterm_residues[1] ||
$residueno eq $cterm_residues[2] ||
$residueno eq $cterm_residues[3] ||
$residueno eq $cterm_residues[4] ) {


printf H3_CTERM "%19s\t%-4s\t%1s\t%6.1f\t%6.1f\t%6.1f\t%2d\t%2.1f\t%8s\n",$filename,$residueno,$residue_single,$omega,$phi,$psi,$lenh3,$resol,$h3base ;

}

if ( $residueno eq $nterm_residues[0] ||
$residueno eq $nterm_residues[1] ||
$residueno eq $nterm_residues[2] ||
$residueno eq $nterm_residues[3] ) {


printf H3_NTERM "%19s\t%-4s\t%1s\t%6.1f\t%6.1f\t%6.1f\t%2d\t%2.1f\t%8s\n",$filename,$residueno,$residue_single,$omega,$phi,$psi,$lenh3,$resol,$h3base ;

}

}

$line = <DSSPPATH> ;
chop ( $line ) ;

}

printf H3_CTERM "\n" ;
printf H3_NTERM "\n" ;

}
$filename = <list> ;
chop ( $filename ) ;




}


