#!/usr/bin/perl

die ( "Exiting. Rosetta paths.txt file not found\n" ) unless ( -e "paths.txt" ) ;
die ( "Exiting. RAM rampaths.txt file not found\n" ) unless ( -e "rampaths.txt" ) ;

if ( @ARGV < 5 ) {

die ( "Exiting. Not enough arguments Usage: perl -P $0 <4 ltr pdb code> <which_framework:FR01|FR02> <build or refine or just_idealize: build|refine|just_idealize> <nstruct> <additional_flags:1|2|3 regular|w_snugfit|wo_snugfit\n" ) ;

}

#include "rampaths.txt"

$pdb = shift @ARGV ;
$which_framework = shift @ARGV ;
$mode = shift @ARGV ;
$nstruct = shift @ARGV ;
$additional_flags = shift @ARGV ;

$executable = "$pdb\_$mode\_loops.bash" ; # output
$condorscript_header = "$misc/base.con" ; # condorscript header file
$condorscript = "$pdb\_$mode\_loops.con" ;

system2( "mkdir -p $pdb/outerr" ) ;
open ( executable , ">$executable" ) ;

$prefix = "aa" ; $nstruct = $nstruct ; $max_frags = "350" ; $njobs = "188" ;

$xtra_flags = "" ;
if ( $additional_flags == 2 ) {
$xtra_flags = "-snug_fit -relax_dock -freeze_h3 -flank_relax 2" ;
} elsif ( $additional_flags == 3 ) {
$xtra_flags = "-relax_cdrs -freeze_h3 -flank_relax 2" ;

}
if ( $mode eq "build" ) {

$flags = "-antibody_modeler -quiet -h3 -H3_filter -ex1aro -ex2aro_only -find_disulf -norepack_disulf -norepack_antibody -unboundrot -use_pdb_numbering -ccd_closure -loop_frags -build_loop -compute_hbond -max_frags $max_frags $xtra_flags";

}    elsif ( $mode eq "refine" ) {

$flags = "-antibody_modeler -quiet -h3 -H3_filter -use_pdb_numbering -ccd_closure -refine_loop -ex1aro -ex2aro_only -unboundrot -norepack_antibody -find_disulf -compute_hbond  $xtra_flags" ;

}	elsif ( $mode eq "just_idealize" ) {

$njobs = 1 ;
$nstruct = 1 ;
$flags = "-antibody_modeler -quiet -h3 -ex1aro -ex2aro_only -find_disulf -norepack_disulf -unboundrot -use_pdb_numbering -ccd_closure -norepack_antibody -loop_frags -build_loop -max_frags $max_frags -compute_hbond -idealize_native" ;

}

$command ="$bin/rosetta.gcc $prefix $which_framework _  -s $which_framework -nstruct $nstruct $flags" ;

printf executable "\#\!/bin/bash\n" ;
printf executable "$command\n" ;
system2( "chmod +x $executable" ) ;

system2( "cat $condorscript_header > $condorscript" ) ;
system2( "echo Executable = ./$executable >> $condorscript" )  ;
system2( "echo pdb = $pdb >> $condorscript" ) ;
system2( "echo Queue $njobs >> $condorscript" ) ;

#system2( "bash $executable" ) ;
system2( "pwd" ) ;
#system2( "condor\_submit $condorscript" ) ;


