#!/usr/bin/perl

#Object : This script analyzes the query_type.align files resulting from the blast search
#Input : the query_type.align files
#Input : Files such as vltype, vhtype, Resolution database, query.vhtype, query.vltype, query_length in the currnt directory
#Output : Print to STDERR of the various alignments
#Output : queryL.pdb and queryH.pdb, the framework regions using script ram_mutate_pdb.pl


die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

if ( @ARGV < 0 ) {

print "Exiting...Not enough arguments\n  Usage: perl -P $0 <pid/bit>\n " ;

die ( ) ;

}

require "$scripts/readinfo.pl";

open ( perfectmatches , ">perfectmatches" ) || die ( "Exiting.Unable to open file perfectmatches\n" ) ;

@types = ( "light" , "heavy" ) ;

&readinfo; # subroutine in readinfo.pl

foreach $type (@types) {

$query_length = $query_length { $type } ;

open ( file , "query\_$type.align" ) || die ( "Exiting. File query\_$type.align not found\n" ) ;

$lineskip = 0 ;

while ($lineskip < 4){$line = <file>; $lineskip++; }
$line = <file> ;
chop($line) ;

while ( $line ne '' ) {


( $query , $match , $per_identity , $alignment_length , $mismatch , $gapopen , $qstart , $qend ,
$sstart , $send , $evalue , $bitscore ) = split ( /\t/ , $line )  ;

$argument = $match.$type  ;
$template_length = $Length { $argument } ; #data read in in readinfo.pl

$filter_alignment_length =  $query_length == $alignment_length  ;
$filter_query_length =  $query_length == $template_length  ;
#   $filter_notoutlier = $outlier_result { $argument } ne "true" ;

$filter = $filter_query_length && $filter_alignment_length && $per_identity == 100  ;

if ( $filter ) {
$value = $perfect_match { $argument } = "match" ;
printf perfectmatches "$match $type $value\n" ;
}

$line = <file> ;
chop ( $line ) ;

}

}

