#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"
require "$scripts/ram_read_matches.pl" || die ( "File $scripts/ram_read_matches.pl not found\n" ) ;
require "$scripts/readpdbline.pl" || die ( " File $scripts/readpdbline.pl not found\n" ) ;

if ( @ARGV < 1 ) {

print "Exiting...Not enough arguments\n Usage: perl -P $0 <pid/bit>\n " ;

die ( ) ;

}

$criterion = shift @ARGV ; # PID, Bit score, Consensus etc.

open ( queryL , ">queryL.pdb" ) ;
open ( queryH , ">queryH.pdb" ) ;


%threetoone=("ALA",A,"CYS",C,"ASP",D,"GLU",E,"PHE",F,"GLY",G,"HIS",H,"ILE",I,"LYS",K,"LEU",L,"MET",M,"ASN",N,"PRO",P,"GLN",Q,"ARG",R,"SER",S,"THR",T,"VAL",V,"TRP",W,"TYR",Y);
%onetothree=("A",ALA,"C",CYS,"D",ASP,"E",GLU,"F",PHE,"G",GLY,"H",HIS,"I",ILE,"K",LYS,"L",LEU,"M",MET,"N",ASN,"P",PRO,"Q",GLN,"R",ARG,"S",SER,"T",THR,"V",VAL,"W",TRP,"Y",TYR);
@types = ( "lfr" , "hfr" ) ;




&read_matches ; # Found in ram_read_matches.pl

for $type ( @types ) {

if ( $type eq "lfr" ) {
@fr = ( 4..23,35..49,57..88,98..105 ) ; $chn = "L"; $outputhandle = "queryL" ;
} elsif ( $type eq "hfr" ) {
@fr = ( 4..25,36..49,66..82,"82A","82B","82C",83..94,103..110 ) ; $chn = "H"; $outputhandle = "queryH" ;
}
&readqueryfasta ( $type ) ;

#    $templatefile = $match_pid { $type } if ( $criterion eq "pid" ) ;
#    $templatefile = $match_bit { $type } if ( $criterion eq "bit" ) ;
#    open ( templatefile , "$pdbfiles/$templatefile" ) || die ( "Exiting... File $pdbfiles/$templatefile not found\n" ) ;

$templatefile = "templateL.pdb" if ( $type eq "lfr" ) ;
$templatefile = "templateH.pdb" if ( $type eq "hfr" ) ;
open ( templatefile , $templatefile ) || die ( "Exiting... File $templatefile not found\n" ) ;


$line = <templatefile> ;
chop ( $line ) ;

while ( $line ne '' ) {
if ( $line =~ /^ATOM/ ) {

&readpdbline ( $line ) ; # Subroutine in readpdbline.pl
$residueno = $residueno.$insert_code if ( $insert_code ne ' ' ) ;

$found = 0 ;
unless ( $alt_loc =~ /B/ ) {

for ( $i = 0 ; $i <= @fr ; $i++ ) {
$mut_res = @fraa[$i] ;
$mut_res_no = @fr[$i] ;

next if ($chain ne $chn or $residueno ne $mut_res_no) ;
$found = 1 if($residueno eq $mut_res_no) ;

last if ( $found ) ;
}

if ( $found ) {


if ($mut_res eq $residue_single) {

printf $outputhandle "$line\n" ;

} else {

$line =~ s/$residue/$onetothree{$mut_res}/ ;
printf $outputhandle "$line\n" if ($atom eq "N" or $atom eq "CA" or $atom eq "C" or $atom eq "O") ;

}

}

}

} else {

printf $outputhandle "$line\n" unless ($line =~ /HEADER/ or $line =~ /TITLE/ or $line =~ /COMPND/) ;
}

$line = <templatefile> ;
chop ( $line ) ;
}
close ( $outputhandle ) ;
}


sub readqueryfasta {

my $type = $_[0]."svr" ;

$fasta = "query.".$type ;
open(fasta,$fasta) ;

$line = <fasta> ;
chop($line) ;

$line=<fasta> ;
chop($line) ;

$string{$type}=$line ;


@fraa = split(//,$string{$type}) ;

return ;

}
