#!/usr/bin/perl

if ( @ARGV < 3 ) {

print STDERR "Not enough arguments for script $0. Exiting...  \n Usage: $0 <reference.pdb> <mobile.pdb> <alignment:light|heavy>\n " ;

die () ;

}
$reference = shift @ARGV;
$mobile = shift @ARGV;
$alignment = shift @ARGV;

print "QUIET\n";
print "ZONE CLEAR\n";
print "ATOMS CA\n";
print "$reference $mobile\n";
print "reference $reference\n";
print "mobile $mobile\n";


if ($alignment eq "light"){
print "ZONE L4-L6\n";
print "ZONE L10-L23\n";
print "ZONE L35-L38\n";
print "ZONE L45-L49\n";
print "ZONE L57-L66\n";
print "ZONE L71-L88\n";
print "ZONE L98-L104\n";

print "fit\n";
print "WRITE queryLfitted.pdb\n";

}

if($alignment eq "heavy"){
print "ZONE H5-H6\n";
print "ZONE H10-H25\n";
print "ZONE H36-H39\n";
print "ZONE H46-H49\n";
print "ZONE H66-H94\n";
print "ZONE H103-H110\n";
print "fit\n";
print "WRITE queryHfitted.pdb\n";

}

