#!/usr/bin/perl


die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

sub readinfo {

$vltypepath = "$info/vltype" ;

$vhtypepath = "$info/vhtype" ;

$cdrdatabasepath = "$info/Cdrdatabase_all" ;

$outlierlistpath = "$info/outlierlist" ;

my $line , $pdbfile , $filename ;

open ( vhtypefile , $vhtypepath ) ;
$line = <vhtypefile> ;

chop ( $line ) ;

while($line ne '') {

(my $pdbfile,$vhtype)=split(/ +/,$line) ;

$vhtype{$pdbfile}=$vhtype ;

$line=<vhtypefile> ;
chop($line) ;

}

open ( vltypefile , $vltypepath ) ;

$line=<vltypefile> ;

chop($line) ;

while($line ne '') {

($pdbfile,$vltype)=split(/ +/,$line) ;

$vltype{$pdbfile}=$vltype ;

$line=<vltypefile> ;
chop($line) ;
}


open ( cdrdatabase , $cdrdatabasepath ) ;

$line=<cdrdatabase> ;
chop($line) ;
while($line ne '') {

(my $filename,$resol,$lenl1,$lenl2,$lenl3,$lenh1,$lenh2,$lenh3,$seql1,$seql2,$seql3,$seqh1,$seqh2,$seqh3,$source,$date,$VLTYPE,$FRAG)=split(/ +/,$line) ;

$resol { $filename } = $resol ;

#For the lengths of the full light and heavy chain sequences, see code after this loop.
#light chain : residues 4-101
#heavy chain : residues 5-106

$Length { $filename."lfr" } = 62 ;
$Length { $filename."hfr" } = 67 ;
$Length { $filename."lbeta" } = 22 ;
$Length { $filename."hbeta" } = 23 ;
$Length { $filename."l1" } = $lenl1 ;
$Length { $filename."l2" } = $lenl2 ;
$Length { $filename."l3" } = $lenl3 ;
$Length { $filename."h1" } = $lenh1 ;
$Length { $filename."h2" } = $lenh2 ;
$Length { $filename."h3" } = $lenh3 ;

$Seq { $filename."l1" } = $seql1 ;
$Seq { $filename."l2" } = $seql2 ;
$Seq { $filename."l3" } = $seql3 ;
$Seq { $filename."h1" } = $seqh1 ;
$Seq { $filename."h2" } = $seqh2 ;
$Seq { $filename."h3" } = $seqh3 ;

$Source { $filename } = $source ;
$VLTYPE { $filename } = $VLTYPE ;

$line = <cdrdatabase> ;
chop ( $line ) ;

}

open ( lightheavylengthfile , "$info/lightheavylengthfile" ) || die ( "Exiting $0. File $info/lightheavylengthfile not found\n" ) ;

$line = <lightheavylengthfile> ;
chop ( $line ) ;

while ( $line ne '' ) {

( my $filename , $chaintype , $length ) = split ( / +/ , $line ) ;

$Length { $filename.$chaintype } = $length ;

$line = <lightheavylengthfile> ;
chop ( $line ) ;

}

open ( outlierlist , "$outlierlistpath" ) || die ( "File $outlierlistpath not found\n" ) ;
$line = <outlierlist> ;
chop ( $line ) ;

while ( $line ne '' ) {

($argument , $result ) = split ( / +/ , $line ) ;

$outlier_result { $argument } = $result ;


$line = <outlierlist> ;
chop ( $line ) ;
}

if ( -e "query.vhtype" ) {
open(queryvhtypefile,"query.vhtype") ;
$line=<queryvhtypefile> ;
chop($line) ;
($dummyname,$query_vhtype)=split(/ +/,$line) ;
}

if ( -e "query.vltype" ) {
open(queryvltypefile,"query.vltype") ;
$line=<queryvltypefile> ;
chop($line) ;
($dummyname,$query_vltype)=split(/ +/,$line) ;
}

if ( -e "query_length" ) {
open(Length,"query_length") ;

$line = <Length> ;
chop($line) ;

while ($line ne '') {

($type,$query_length) = split(/ +/,$line) ;

$query_length{$type}=$query_length ;

$line = <Length> ;
chop($line) ;
}

}

}
1;
