#!/usr/local/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"


require "$scripts/readinfo.pl";
require "$scripts/getminimum_per_identity.pl";
require "$scripts/ram_match_hacks.pl" ;
require "$scripts/readcdrinfo.pl" ;

$pdb = shift @ARGV ;
$criterion = shift @ARGV ;
$eliminate_natives = shift @ARGV ;

open ( output , ">query.matches" ) ;
open ( output1, ">query.moreinfo" ) ;

@types = ( "lightheavy" , "lfrhfr" , "light" , "heavy" , "l1", "l2" , "l3" , "h1" , "h2" , "h3", "lfr" , "hfr" ) ; # aroop: added h3 for h3_graft

$minimum_alignment_length_factor = 0.70 ;
$maximum_resolution = 2.8 ;
$perfect_seq_match_threshold = 105 ;

&readinfo; # subroutine in readinfo.pl

foreach $type (@types) {

		$minimum_alignment_length_factor = 0.10 if ( $type eq "h3" ) ; # aroop: added h3 for h3_graft
		$minimum_alignment_length_factor = 0.55 if ( $type eq "h2" ) ;
		&identifymatch ( $type , $minimum_alignment_length_factor , $maximum_resolution , $negative_result )  ;
		$resol_best_bitscore { $type } = "none" if ( $resol_best_bitscore { $type } == 100 ) ;
		$best_match = $best_match { $type } || "none" ;
		$best_identity = $best_identity { $type } || "none" ;
		$best_resol = $best_resol { $type } || "none" ;
		$best_bitscore_match = $best_bitscore_match { $type } || "none" ;
		$best_bitscore = $best_bitscore { $type } || "none" ;
		$resol_best_bitscore = $resol_best_bitscore { $type } || "none" ;

#Hacks for pdbs in the testset that do not have matches for one or more regions.
		&ram_match_hacks ( $pdb , $type ) if ( $criterion eq "pid" && $best_match eq "none" || $criterion eq "bit" && $best_bitscore_match eq "none" ) ;
		$filter_error_pid = $best_match eq "none" ;
		$filter_error_bit = $best_bitscore_match eq "none" ;
		$filter_error = ( $filter_error_pid && $filter_error_bit ) ||
				( $criterion eq "pid" && $filter_error_pid )||
				( $criterion eq "bit" && $filter_error_bit ) ;

		if ( $filter_error ) {
				open ( errorlog , ">errorlog" ) ;
				printf errorlog "$type  WARNING!!!No matches found for type $type\n" ;
				printf output "$type  WARNING!!!No matches found for type $type\n" ;
		} else {
				printf output "%-3s %-19s %-6s %-4s %-19s %-6s %-4s\n" ,$type,$best_match,$best_identity,$best_resol,$best_bitscore_match,$best_bitscore,$resol_best_bitscore ;
				printf output1 "$type $best_bitscore_match $Source{$match} $VLTYPE{$match}\n" ;
		}
}

sub identifymatch {

		my $type ;

		($type,$minimum_alignment_length_factor,$maximum_resolution,$negative_result) = @_ ;

		$isLcdr = $type eq "l1" || $type eq "l2" || $type eq "l3" ;
		$isHcdr = $type eq "h1" || $type eq "h2" || $type eq "h3" ;
		$isfr = $type eq "lfr" || $type eq "hfr" ;
		$islight = $type eq "light" ;
		$isheavy = $type eq "heavy" ;
		$islfrhfr = $type eq "lfrhfr" ;
		$islightheavy = $type eq "lightheavy" ;


		$query_length = $query_length{$type} ;
		$minimum_alignment_length = $minimum_alignment_length_factor * $query_length ;
		$best_identity { $type } = $best_bitscore { $type } = 0 ;
		$resol_best_bitscore { $type } = 100 ;

		open ( file , "query\_$type.align" ) ;
		$lineskip = 0 ;
		while ( $lineskip < 4 ) { $line = <file>; $lineskip++; }
		$line = <file> ;
		chop($line) ;
		while ($line ne '') {
				($query,$match,$per_identity,$alignment_length,$mismatch,$gapopen,$qs,$qe,$ss,$se,$evalue,$bitscore)=split(/\t/,$line)  ;

				#aroop: hack to ensure that at least one hit is present
				if( $lineskip == 4 ) {
						$initial_query = $query;
						$initial_match = $match;
						$initial_per_identity = $per_identity;
						$initial_alignment_length = $alignment_length;
						$initial_evalue = $evalue;
						$initial_bitscore = $bitscore;		
				}
				$lineskip++;

				$argument = $match.$type  ;

				$matchlight = $match."light" ;
				$matchheavy = $match."heavy" ;
				$matchlightheavy = $match."lightheavy" ;
				$matchlfrhfr = $match."lfrhfr" ;

				$template_length = $Length { $argument } ; #data read in in readinfo.pl
				$filter_query_length = $filter_alignment_length = $filter_resol = 0 ;

				$filter_query_length =  ($query_length == $template_length)  ;
				$filter_query_length = 1 if ( $type eq "heavy" ) ;
				$filter_alignment_length =  $alignment_length > $minimum_alignment_length  ;

				$filter_resol = ($resol { $match } <= $maximum_resolution) ;
				$filter_notoutlier = $outlier_result { $argument } ne "true" ; #At present, null values for lfrhfr and lightheavy


				if ( $islightheavy )  {

						$filter_eliminate { $argument } = 0 ;
						$filter_threshold_pid = $per_identity >= $perfect_seq_match_threshold ;

						if ( $eliminate_natives ) {
								if ( $filter_threshold_pid && $filter_alignment_length) {
										$filter_eliminate { $argument } = 1 ;
								}
						}
				}

#match by identity

				$filter = $filter_query_length && $filter_alignment_length && $filter_resol && $filter_notoutlier ;
				$filter = $filter && ! ( $filter_eliminate { $matchlightheavy } ) if ( ! ( $islight || $isheavy ) ) ;

				if ( $filter ) {
						$negative_result = 0 ;
						$filter_change1 = $per_identity > $best_identity { $type } ;
						$filter_change2 = $per_identity == $best_identity { $type } ;
						$filter_change3 = $alignment_length > $best_alignment_length { $type } ;
						$filter_change4 = $alignment_length == $best_alignment_length { $type } ;
						$filter_change5 = $resol { $match }  < $best_resol { $type } ;
						$filter_change = $filter_change1 || ( $filter_change2 && $filter_change3 ) || ( $filter_change2 && $filter_change4 && $filter_change5 ) ;
						if ( $filter_change ) {
								$best_match { $type } = $match ;
								$best_identity { $type } = $per_identity ;
								$best_resol { $type } = $resol { $match } ;
								$best_alignment_length { $type } = $alignment_length ;
						}
				}

#match by bitscore

				$filter_bitscore = $bitscore >= $best_bitscore { $type } ;
				$filter = $filter_query_length  && $filter_bitscore && $filter_notoutlier && $filter_alignment_length ;
				$filter = $filter && ! ( $filter_eliminate { $matchlightheavy } )  if ( ! ( $islight || $isheavy ) ) ;

				if ( $filter )  {

						if ( $filter_resol && $resol { $match } <= $resol_best_bitscore { $type } )  {
								$best_bitscore_match { $type } = $match ;
								$best_bitscore { $type } = $bitscore ;
								$resol_best_bitscore { $type } = $resol { $match } ;
						}
				}
				$line = <file> ;
				chop($line) ;
		}

		# aroop: hack to ensure at least one hit is present
		if( ($best_match{$type} eq "") && ($best_bitscore_match{$type} eq "") && ($lineskip != 4) ) {
				print( "\n\nSERVER WARNING: LOW CONFIDENCE PREDICTION FOR CDR-$type\n" );
				print( "SERVER WARNING: CDR-$type fails acceptance threshold\n\n" );
				$best_match { $type } = $initial_match ;
				$best_identity { $type } = $initial_per_identity ;
				$best_resol { $type } = $resol { $initial_match } ;
				$best_alignment_length { $type } = $initial_alignment_length ;
				$best_bitscore_match { $type } = $initial_match;
				$best_bitscore { $type } = $initial_bitscore ;
				$resol_best_bitscore { $type } = $resol { $initial_match } ;
		}
		elsif( ($best_match{$type} eq "") && ($best_bitscore_match{$type} eq "") && ($lineskip == 4) ) {
				print( "\n\nSERVER WARNING: VERY LOW CONFIDENCE PREDICTION FOR CDR-$type\n" );
				print( "SERVER WARNING: CDR-$type does not have any sequence match, matching length only\n\n" );
				&readcdrinfo( $type, $query_length );
				$best_match { $type } = $main_filename ;
				$best_identity { $type } = 0 ;
		 		$best_resol { $type } = $main_resol;
		 		$best_alignment_length { $type } = 0 ;
		 		$best_bitscore_match { $type } = $main_filename;
		 		$best_bitscore { $type } = 0 ;
				$resol_best_bitscore { $type } = $main_resol;
		}
		close(file) ;
}

