#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

if ( @ARGV < 3 ) {

die ( " Not enough arguments for script $0. Exiting... \n  Usage: perl -P $0 <fasta_file_for_segment> <rosetta_fragment_file_name> <ab_fragment_file>\n" ) ;

}


require "$scripts/readinfo.pl";
require "$scripts/readdsspline.pl" ;
require "$scripts/get_cterm_residues.pl" ;
require "$scripts/removespaces.pl" ;
require "$scripts/get_mer_from_fasta.pl" ;
&readinfo ; # Subroutine in readinfo.pl ;

$fasta_file = shift @ARGV ;
$rosetta_fragment_file = shift @ARGV ;
$ab_fragment_file = shift @ARGV ;



&get_mer_from_fasta ( $fasta_file ) ; #Subroutine in get_mer_from_fasta.pl returns trimer/sequence data used in the for loop below.

for ( $position = 1 ; $position <= $ntrimer ; $position ++ ) {

$total_neighbors = 0 ;
$npositions_found  = 0 ;
@array = () ;


&read_fragment_file ($rosetta_fragment_file , $position ) ;
&read_fragment_file ( $ab_fragment_file , $position ) ;
if ( $total_neighbors == 200 ) {

printf STDERR "WARNING!! No Ab fragments made for position $position\n"  ;

} elsif ( $total_neighbors < 200 ) {

printf STDERR "WARNING! No rosetta fragments made for position $position\n"  ;

}

printf " %9s%13d %10s%13d\n","position:",$position,"neighbors:",$total_neighbors ;

foreach $element ( @array ) {

print "$element" ;

}

}

sub read_fragment_file {

my $fragment_file = $_[0] ;
my $handle = $fragment_file."handle" ;
my $position_not_found = 1 ;


open ( $handle , $fragment_file ) || die ("File $fragment_file not found\n" ) ;

while ( ! eof($handle) && $position_not_found )  {

$line = <$handle> ;
if ( $line =~ /position/ ) {
my $position_frag_file = &removespaces (substr($line,20,3)) ;
my $neighbors = &removespaces(substr($line,44,3));
if($position_frag_file == $position) {
$position_not_found = 0 ;
$npositions_found ++ ;
$total_neighbors = $total_neighbors + $neighbors ;
my $nlines = $neighbors*4 +1 ;
$nlines = $neighbors*4 if ( $npositions_found == 2 ) ;
for ( $i = 1 ; $i <= $nlines ; $i++ ) {
$lineskip = <$handle> if($i == 1 && $npositions_found==2);
$line=<$handle>;
push @array, $line ;
}
}
}
}

close($handle) ;

}




