#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

@types = ( "lfr" , "hfr" , "l1" , "l2" , "l3" , "h1" , "h2" , "h3" , "motif" , "lbeta" , "hbeta" , "light" , "heavy" , "lfrhfr" , "lightheavy" ) ;
$outputtype = 9 ;

foreach $type ( @types ) {
		$databasename = "database.$type" ;
		$databasepath = "$database/$databasename" ;
		$inputquery = "query.".$type ;
		$output = "query\_$type".".align" ;
		$evalue = 20000 ;
		$matrix = "PAM30" ;
		$wordsize = 2 ;
		$numbertokeep = 600 ;

		if ( $type =~ /fr/ || $type =~ /light/ || $type =~ /heavy/ ) {
				$evalue = 0.00001 ;
				$matrix = "BLOSUM62" ;
				$wordsize = 0 ;
		}
		system2(" $blast/blastall -p blastp -d $databasepath -i $inputquery -o  $output -e $evalue -M $matrix -W $wordsize -m $outputtype -b $numbertokeep" );
}
