#!/usr/local/bin/perl
use Cwd ;

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"


if ( @ARGV < 10 ) {

print STDERR "Not enough arguments for script $0. Exiting...\n Usage: perl -P $0 <pdbxxxx\_chothia.pdb> <run_blast_prep:0|1> <run_blast_matches:0|1> <template_creation:0|1> <rosetta_graft_loop:0|1> <rosetta_make_fragments:0|1> <rosetta_build_loops:0|1> <nstruct_build> <fastafile_lightchain> <fastafile_heavychain> \n " ;

die () ;

}

require "$scripts/ram_kink_query.pl" ;

$chainL = "L" ;
$chainH = "H" ;

$currentdir = getcwd ( ) ;

$pdb = shift @ARGV;
$run_blast_prep = shift @ARGV ;
$run_blast_matches = shift @ARGV ;
$template_creation = shift @ARGV ;
$rosetta_graft_loop = shift @ARGV ;
$rosetta_make_fragments = shift @ARGV ;
$rosetta_build_loops = shift @ARGV ;
$nstruct_build = shift @ARGV ;
$fastafile_light = shift @ARGV ;
$fastafile_heavy = shift @ARGV ;


#Hardcoded variable values

$criterion = "bit" ;
$frameworktemplate = "ram" ;
$cdrtemplate = "ram" ;
$native_h3_reconstruct = 0 ;
$eliminate_natives = 0 ;
$which_framework = "FR02" ;
$deep_graft = 1 ;
$vlvhalignment = 2 ;
$h3_fragment_type = 3 ;
$additional_flags = 3 ;
$pdb_input = 0 ;
$fasta_input = 1 ;



$nstruct_grafting = 1 ;
$rosetta_3mer_fragments = "rosetta_3mer_fragments" ;
$ab_3mer_fragments = "ab_3mer_fragments" ;
$fragments_h3_94_103 = "fragments_h3_94_103" ;
$ab_fragment_resol_threshold = 2.5 ;

#End hardcoded variable values

$pdbcode = substr ( $pdb , 3 , 4 ) ;
$pdbdir = "$currentdir/$pdbcode" ;
$build_loop_dir = "$currentdir/build" ;
$refine_loop_dir = "$currentdir/refine" ;

system2("mkdir -p $build_loop_dir" );
system2( "cp $scripts/paths.txt paths.txt" ) ;
unlink ( "errorlog" ) ;


&do_blast_prep if ( $run_blast_prep ) ;
&get_blast_matches if ( $run_blast_matches ) ;
&get_error ;
&create_template if ( $template_creation ) ;
&graft_canonical_loops if ( $rosetta_graft_loop ) ;
&make_fragments if ( $rosetta_make_fragments ) ;
&build_rosetta_loops if ( $rosetta_build_loops ) ;

sub do_blast_prep {
		system2("perl -P $scripts/ram_create_query_fasta.pl $pdb $chainL $chainH" ) if ( $pdb_input ) ;
		system2("perl -P $scripts/ram_mapping.pl" );
		system2("perl -P $scripts/ram_create_query_database.pl" );
		system2("perl -P $scripts/ram_create_query_database_lightheavy.pl" );
}

sub get_blast_matches {
		system2("perl -P $scripts/ram_blastscript.pl" ) ;
		system2("perl -P $scripts/ram_id_perfect_matches.pl" ) ;
		system2("perl -P $scripts/ram_analyze_blast.pl $pdb $criterion $eliminate_natives" ) ;
}

sub get_error {
		if ( -e "errorlog" ) {
				printf STDERR "No sequence matches for one or more regions \n  Exiting homology modeling protocol\n" ;
				system2("cat errorlog" );
				die ( ) ;
		}
}

sub create_template {

		system2( "echo TER > terfile" ) ;
		system2("perl -P $scripts/ram_copytemplates.pl $pdb_input $criterion $frameworktemplate $cdrtemplate $pdb" ) ;
		system2("perl -P $scripts/ram_mutate_pdb.pl $criterion" ) ;
		if ( $vlvhalignment == 1 ) {

# Superimpose lfr match onto the light chain of the hfr match pdb to create queryLfitted.pdb

				if ( $which_framework eq "FR01" ) {

						system2("perl -P $scripts/ram_profit_script.pl templateL.pdb queryH.pdb heavy > profit.in" ) ;
						system2("profit < profit.in >> profit.out" ) ;
						system2("grep Error profit.out" ) ;
						system2("cat queryL.pdb queryHfitted.pdb > FR01_nocdr.pdb" ) ;
						system2("$scripts/ram_blankcdrs.pl FR01_nocdr.pdb L > FR01_Lcdr.pdb" ) ;
						system2("$scripts/ram_blankcdrs.pl FR01_Lcdr.pdb H > FR01.pdb" ) ;

				} elsif ( $which_framework eq "FR02" ) {

						system2("perl -P $scripts/ram_profit_script.pl templateH.pdb queryL.pdb light > profit.in" ) ;
						system2("profit < profit.in > profit.out" ) ;
						system2("grep Error profit.out" ) ;
						system2("cat queryLfitted.pdb queryH.pdb > FR02_nocdr.pdb" ) ;
						system2("$scripts/ram_blankcdrs.pl FR02_nocdr.pdb L > FR02_Lcdr.pdb" ) ;
						system2("$scripts/ram_blankcdrs.pl FR02_Lcdr.pdb H > FR02.pdb" ) ;
}

		} elsif ( $vlvhalignment == 2 )  {

				if ( $which_framework eq "FR01" ) {

						system2("perl -P $scripts/ram_profit_script.pl templatelfrhfr.pdb queryL.pdb light > profit.in" ) ;
						system2("profit < profit.in > profit.out" ) ;
						system2("grep Error profit.out" ) ;

						system2("perl -P $scripts/ram_profit_script.pl templatelfrhfr.pdb queryH.pdb heavy > profit.in" ) ;
						system2("profit < profit.in >> profit.out" ) ;
						system2("grep Error profit.out" ) ;

						system2("cat queryLfitted.pdb queryHfitted.pdb > FR01_nocdr.pdb" ) ;
						system2("$scripts/ram_blankcdrs.pl FR01_nocdr.pdb L > FR01_Lcdr.pdb" ) ;
						system2("$scripts/ram_blankcdrs.pl FR01_Lcdr.pdb H > FR01.pdb" ) ;

				} elsif ( $which_framework eq "FR02" )  {
						system2("perl -P $scripts/ram_profit_script.pl templatelightheavy.pdb queryL.pdb light > profit.in" ) ;

						system2("profit < profit.in > profit.out" );

						system2("perl -P $scripts/ram_profit_script.pl templatelightheavy.pdb queryH.pdb heavy > profit.in" ) ;
						system2("profit < profit.in >> profit.out" ) ;

						system2("cat queryLfitted.pdb queryHfitted.pdb > FR02_nocdr.pdb" ) ;
						system2("$scripts/ram_blankcdrs.pl FR02_nocdr.pdb L > FR02_Lcdr.pdb" ) ;
						system2("$scripts/ram_blankcdrs.pl FR02_Lcdr.pdb H > FR02.pdb" ) ;
				}

		}
		system2("perl -P $scripts/ram_setup_rrun.pl $pdb_input $pdb $criterion $deep_graft" ) ;

		if ( $pdb_input ) {
				system2("perl -P $scripts_alt/extractres.pl L 4 105 $pdb > nativeL.pdb " ) ;
				system2("perl -P $scripts_alt/extractres.pl H 4 110 $pdb > nativeH.pdb " ) ;
				system2("cat nativeL.pdb terfile nativeH.pdb terfile > $pdbcode.pdb" );
		}
		system2("perl $scripts/pre_graft_antibody_cleaner.pl $which_framework" ) ;
}

sub graft_canonical_loops {

		printf STDERR "START LOOP GRAFTING: $pdb\n"  ;

		system2("$scripts/pdb_cleaner.pl $which_framework | tee temp.pdb" ) ;
		system2("mv temp.pdb $which_framework.pdb" ) ;

		unless ( $native_h3_reconstruct )  {
				system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -l1 -l2 -l3 -h1 -h2 -graft_h3 -superimpose -deep 2 -use_pdb_numbering -ccd_closure -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile") ;
				# system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -l1 -l2 -l3 -h1 -h2 -superimpose -deep 2 -use_pdb_numbering -ccd_closure -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile") ; // aroop: removed for h3_graft

		} else {
		
				$native_wo_h3 = "$pdbcode\_L_noh3.pdb"  ;
				system2("$scripts_alt/extractChains.pl L $pdbcode.pdb > $native_wo_h3" ) ;
				system2("$scripts_alt/extractres.pl H 4 94 $pdbcode.pdb >> $native_wo_h3" ) ;
				system2("$scripts_alt/extractres.pl H 103 110 $pdbcode.pdb >> $native_wo_h3" ) ;
				system2("$scripts/ram_blankcdrs_h3.pl $native_wo_h3 H > FR02.pdb" ) ;
				system2("$bin/rosetta.gcc aa $which_framework _ -antibody_modeler -nstruct $nstruct_grafting -quiet -use_pdb_numbering -s $which_framework -native $pdbcode -find_disulf -norepack_disulf|tee rosetta$which_framework\_grafting.logfile") ;

		}
		printf STDERR "END LOOP GRAFTING: $pdb\n"  ;

		system2("python $docking_scripts/pdb_scripts/makefixdisulf.py aa$which_framework\_0001.pdb" ) ;
		if( -e "aa$which_framework\_0001.fixdisulf" )  {
				system2("mv aa$which_framework\_0001.fixdisulf $which_framework.fixdisulf" ) ;
		}

# Housekeeping
		system2( "cp $which_framework.pdb $which_framework.pdb.template" )  ;
		system2( "cp aa$which_framework\_0001.pdb $which_framework.pdb" )  ;
		system2( "cp aa$which_framework\_0001.pdb pdb$which_framework\_chothia.pdb" )  ;
# End Housekeeping

		# The following is commented out since in the new version, we do output
    # a structure with the CDR H3 grafted. Thus we want the CDR H3 to be there.
		##Outputing grafted PDB without CDR H3
		#system2( "$scripts/remove_h3.pl aa$which_framework\_0001.pdb > grafted_noH3.pdb" );
		system2( "cp aa$which_framework\_0001.pdb grafted_noH3.pdb" );

}

sub make_fragments {

		$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3"  ;
		$fragment_file_9 = "aa$which_framework\_09\_05.200\_v1\_3"  ;

		if ( $h3_fragment_type == 1 )  {

				&make_rosetta_fragments ;
				system2( "ln -s $rosetta_3mer_fragments $fragment_file" )  ;

		} elsif ( $h3_fragment_type == 2 ) {

				&make_antibody_fragments  ;
				system2( "ln -s $ab_3mer_fragments $fragment_file" )  ;
				system2( "ln -s $rosettafrags/$pdbcode$fragment_file_9 $fragment_file_9" )  ;

		} elsif ( $h3_fragment_type == 3 ) {

				&make_rosetta_fragments ;
				&make_antibody_fragments ;
				system2("perl -P $scripts/ram_append_abfrags_to_rosettafrags2.pl $which_framework\_.fasta $rosetta_3mer_fragments $ab_3mer_fragments > $fragment_file") ;
		}
}

sub make_rosetta_fragments {

		chdir ( "$build_loop_dir" ) || die ( "Exiting. Unable to change to directory \'$build_loop_dir\'" )  ;

		$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3" ;

		system2("cp $scripts/rampaths.txt .") unless -e "rampaths.txt" ;
		system2("cp ../$which_framework.pdb .") unless -e "$which_framework.pdb" ;
		system2("cp $scripts/paths.txt  paths.txt")  unless -e "paths.txt" ;
		system2("cp $scripts/utilities.txt .") ;

		unless ( -e $rosetta_3mer_fragments ) {
				print "Making fragments for heavy chain residues 94-103...\n"  ;
				system2("perl -P $scripts/ram_make_rosetta_fragments.pl $which_framework|tee rosetta$which_framework\_frags.logfile") ;
				system2("mv $fragment_file $rosetta_3mer_fragments" ) ;
				print "Done\n" ;
		}
}


sub make_antibody_fragments {

		chdir ( "$build_loop_dir" ) || die ( "Exiting. Unable to change to directory \'$build_loop_dir\'" ) ;

		$fragment_file = "aa$which_framework\_03\_05.200\_v1\_3"  ;
		system2("ln -s $scripts/rampaths.txt .") unless -e "rampaths.txt"  ;
		system2("ln -s $pdbdir/$which_framework.pdb .") unless -e "$which_framework.pdb" ;
		system2("ln -s $scripts/paths.txt  paths.txt")  unless -e "paths.txt" ;
		system2("$scripts_alt/extractres.pl H 94 103 $which_framework.pdb > h3plus1.pdb" ) ;
		system2("$docking_scripts/pdb_scripts/pdb_fasta.pl h3plus1.pdb simple > $which_framework\_.fasta") ;
		system2("perl -P $scripts/ram_blastscript_h3frag.pl 3 0" ) ;
		system2("perl -P $scripts/ram_analyze_blast_h3frag.pl $pdb 3 0.2" ) ;
}

sub build_rosetta_loops {

		$mode = "build"  ;
		chdir ( "$build_loop_dir" )  ;

		system2( "cp $currentdir/hfr.pdb . " ) unless ( -e "hfr.pdb" )  ;
		system2( "cp $currentdir/lfr.pdb . " ) unless ( -e "lfr.pdb" )  ;

		system2( "perl -P $scripts/ram_create_H3CterNter.pl $pdb" ) ;
		system2( "perl -P $scripts/ram_create_condor_script.pl $pdbcode $which_framework $mode $nstruct_build $additional_flags" ) ;
}





