#!/usr/bin/perl

#include "rampaths.txt"

if (@ARGV < 1 ) {
		die ( "Not enough arguments. Exiting...Usage: $0 <profit_rmsd_file> \n" ) ;
}
require "$scripts/removespaces.pl" ;

$profitdata=shift @ARGV;
$outfile = "profit\_h3frags\_rmsd\_table" ;

open(profitdata,$profitdata)||die("File $profitdata not found\n");
open(outfile,">$outfile") ;

for ($i=1;$i <=15; $i++) {
		$lineskip =<profitdata> ;
}

$i=0 ;
$line =<profitdata> ;
chop($line) ;

while ($line ne '') {

		$i++ ;
		$i=1 if ($i == 5) ;
		if ( $i == 1 ) {
				@array = split ( / +/ , &removespaces ( $line ) ) ;
				$file1 = substr ( $array[2] , 0 , length ( $array[2] ) -4 ) ;
				$file2 = substr ( $array[3] , 0 , length ( $array[3] ) -4 ) ;
		}
		$frag_rmsd = substr($line,7,5) if ($i == 4) ;
		if($i == 4) {
				push @pdbfiles,$file1 unless($pushed{$file1}++) ;
				push @pdbfiles,$file2 unless($pushed{$file2}++) ;
				$argument1="$file1-$file2" ;
				$argument2="$file2-$file1" ;
				$frag_rmsd{$argument1}=$frag_rmsd{$argument2}=$frag_rmsd ;
		}

		$line =<profitdata> ;
		chop($line) ;
}

printf outfile  "pdbs " ;
foreach $file (@pdbfiles) {
		printf outfile  "$file " ;
}
printf outfile  "\n" ;
foreach $file1 (@pdbfiles) {
		printf outfile  "$file1 " ;
		foreach $file2 (@pdbfiles) {
				$argument = "$file1-$file2" ;
				$value_rmsd = $frag_rmsd{$argument} ;
				$value_rmsd = 0 if ($file1 eq $file2 ) ;
				printf  outfile "%10.4f ",$value_rmsd ;
		}
		printf outfile  "\n" ;
}
