#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;

#include "rampaths.txt"

use lib '$scripts' ;

if ( @ARGV < 4 ) {
		print STDERR "Not enough arguments for script $0. Exiting...
Usage: perl -P $0 <list> <startres1> <endres1> .. <startresn> <endresn> <chainID> \n " ;
		die () ;
}

require "$scripts/readpdbline.pl" ;

%threetoone=("ALA",A,"CYS",C,"ASP",D,"GLU",E,"PHE",F,"GLY",G,"HIS",H,"ILE",I,"LYS",K,"LEU",L,"MET",M,"ASN",N,"PRO",P,"GLN",Q,"ARG",R,"SER",S,"THR",T,"VAL",V,"TRP",W,"TYR",Y);

$nargs= $#ARGV +1 ;
$ngaps = ( $nargs - 2 ) / 2 ;
$list = shift @ARGV ;


for ( $i = 1 ; $i <= $ngaps ; $i++ ) {
    $begin [ $i ] = shift @ARGV ;
    $end [ $i ] = shift @ARGV ;
}

$getchain = shift @ARGV ;
$fastaornot = shift @ARGV ;

$type = "unset";
$type = "light" if ( $getchain eq "L" && $begin[1] == 4 && $end[1] == 101 ) ;
$type = "heavy" if ( $getchain eq "H" && $begin[1] == 5 && $end[1] == 106 ) ;


open ( list , $list ) || die ( "File $list not found\n" ) ;
open ( lightheavylengthfile , ">>$info/lightheavylengthfile" ) || die ( "Exiting. Unable to open $info/lightheavylengthfile\n" ) ;

printf STDERR "Printing sequence from structures in file $list\n" ;
&initialize ;


while ( $pdbfile ne '' ) {
		if ( -e $pdbfile ) {
				&readpdbfile ;
		}
		&initialize ;
}
close( list );
close( lightheavylengthfile );
sub initialize {
#get the pdbfilename and the chain ID's 
		$line = <list> ;
		chop ( $line ) ;
		$pdbfile = $line ;
		$printseq ='' ;
}

sub readpdbfile {
#read the actual pdb file and then identify the light and the heavy chain sequence.
    $filename = $pdbfile ;
    open ( pdbfile , $filename ) || die ( "File $filename not found\n" ) ;
		$line = <pdbfile> ;
    chop ( $line ) ;

    while ( $line ne '' ) {
				&readpdbline ( $line ) ; # Subroutine in readpdbline.pl
				if ( $identifier =~ "ATOM" and $atom =~ "CA" and $chain eq $getchain ) {
						for ( $i = 1 ; $i <= $ngaps ; $i++ ) {
								$begin = $begin [ $i ] ;
								$end = $end [ $i ] ;
								if( $residueno >= $begin and $residueno <= $end ) {
										$printseq = $printseq.$threetoone { $residue } unless ( $old_residueno eq $residueno and $old_alt_loc ne $alt_loc ) ;
								}
						}
						$old_residueno = $residueno ;
						$old_alt_loc = $alt_loc ;
				}
				$line = <pdbfile> ;
				chop ( $line ) ;
		}
		close( pdbfile );


    print "\>$pdbfile\n" if ( $fastaornot eq "fasta" ) ;
		print "$printseq\n" if ( $fastaornot eq "fasta" ) ;
    print "$pdbfile $printseq\n" if ( $fastaornot ne "fasta" ) ;
		if( $type ne "unset" ) {
				$Length = length ( $printseq ) ;
				printf lightheavylengthfile "$pdbfile $type $Length\n" ;
		}
}
