#!/usr/bin/perl

die ( " Exiting...File rampaths.txt not found \n" ) unless -e ( "rampaths.txt" ) ;
#include "rampaths.txt"

if ( @ARGV < 4 ) {
		print STDERR "Not enough arguments for script $0. Exiting...\n Usage: perl -P $0 <pdb_input:1|0 = pdb|fasta> <pdbxxxx\_chothia.pdb> <pid|bit> <deep_graft:0|1>\n " ;
		die () ;
}

require "$scripts/ram_read_matches.pl" || die ( "File $scripts/ram_read_matches.pl not found\n" ) ;

$pdb_input = shift @ARGV ;
$pdbfile = shift @ARGV ;
$criterion = shift @ARGV ; # PID, Bit score, Consensus etc.
$deep_graft = shift @ARGV ;

@types = ( "lfr" , "hfr" , "l1" , "l2" , "l3" , "h1" , "h2" , "h3" ) ;
system2(" cp $testset/$pdbfile . " ) unless ( ! $pdb_input ) ;
&read_matches ; #Subroutine in ram_read_matches.pl

foreach $type ( @types ) {

		$file = "templateL.pdb" if ( $type eq "lfr" ) ;
		$file = "templateH.pdb" if ( $type eq "hfr" ) ;
		$file = "templatel1.pdb" if ( $type eq "l1" ) ;
		$file = "templatel2.pdb" if ( $type eq "l2" ) ;
		$file = "templatel3.pdb" if ( $type eq "l3" ) ;
		$file = "templateh1.pdb" if ( $type eq "h1" ) ;
		$file = "templateh2.pdb" if ( $type eq "h2" ) ;
		$file = "templateh3.pdb" if ( $type eq "h3" ) ;

		if ( $type eq "lfr" ) {

				system2("$scripts_alt/extractChains.pl L $file > lfr.pdb " );
		} elsif ( $type eq "hfr" ) {
				system2("$scripts_alt/extractChains.pl H $file > hfr.pdb " );
		} elsif ( $type eq "l1" ) {
				if ( ! $deep_graft ) {
						system2("$scripts_alt/extractres.pl L 23 35 $file > l1.pdb " );
				} else {
						system2("$scripts_alt/extractres.pl L 20 38 $file > l1.pdb " );
				}
		} elsif ( $type eq "l2" ) {
				if ( ! $deep_graft ) {
						system2("$scripts_alt/extractres.pl L 49 57 $file > l2.pdb " );
				} else {
						system2("$scripts_alt/extractres.pl L 46 60 $file > l2.pdb " );
				}
		} elsif ( $type eq "l3" ) {
				if ( ! $deep_graft ) {
						system2("$scripts_alt/extractres.pl L 88 98 $file > l3.pdb " );
				} else {
						system2("$scripts_alt/extractres.pl L 85 101 $file > l3.pdb " );
				}
		} elsif ( $type eq "h1" ) {
				if ( ! $deep_graft ) {
						system2("$scripts_alt/extractres.pl H 25 36 $file > h1.pdb " );
				} else {
						system2("$scripts_alt/extractres.pl H 22 39 $file > h1.pdb " );
				}
		} elsif ( $type eq "h2" ) {
				if ( ! $deep_graft ) {
						system2("$scripts_alt/extractres.pl H 49 66 $file > h2.pdb " );
				} else {
						system2("$scripts_alt/extractres.pl H 46 69 $file > h2.pdb " );
				}
		} elsif ( $type eq "h3" ) {
				if ( ! $deep_graft ) {
						system2("$scripts_alt/extractres.pl H 94 103 $file > h3.pdb " );
				} else {
						system2("$scripts_alt/extractres.pl H 91 105 $file > h3.pdb " ); # aroop: added for h3_graft
						# system2("$scripts_alt/extractres.pl H 91 105 $file > h3.pdb " )unless ( ! $pdb_input ) ; // aroop: removed for h3_graft

				}
		}
}
