#!/usr/bin/perl

if ( @ARGV < 1 ) {
		die ( "Exiting. Not enough arguments.\nUsage: $0 <pdbfile from which CDR-H3 has to be deleted>>\n ") ;
}

$pdbfile = shift @ARGV;
open(pdbfile,$pdbfile)||die("PDB file $pdbfile not found\n");

$line=<pdbfile>;
chop($line);

while($line ne ''){
		
		$identifier = substr($line,0,6);
		$atomno = substr($line,6,5);
		$atom = substr($line,12,4);
		$alt_loc = substr($line,16,1);
		$residue = substr($line,17,3);
		$chain = substr($line,21,1);
		$residueno = substr($line,22,4);
		$insert_code=substr($line,26,1);
		$x = substr($line,30,8);
		$y = substr($line,38,8);
		$z =  substr($line,46,8);
		$occupancy = substr($line,54,6);
		$bfactor = substr($line,60,6);
		
		$int_res = 0 + $residueno;
		
		if( ($chain =~ /H/) && ($int_res >= 95) && ($int_res <= 102) ) {
				$x = "   0.000";
				$y = "   0.000";
				$z = "   0.000";
		}
		else{
				printf "%-6s%5s %-4s%1s%3s %1s%4s%1s   %8.3f%8.3f%8.3f%6.2f%6.2f              \n",$identifier,$atomno,$atom,$alt_loc,$residue,$chain,$residueno,$insert_code,$x,$y,$z,$occupancy,$bfactor;
		}

		if ($identifier =~ /TER/){
				printf "%-6s\n", $identifier;
		}
			
		$line = <pdbfile>;
		chop($line);
}

