#!/usr/bin/perl
use Cwd ;

if ( @ARGV < 1 ) {
		die ( "Exiting. Not enough arguments.
Usage: $0 <list of pdb filenames to append to database>\nEach line in the list should have the following entries separated by a space:\n<Four letter pdb code> <species:Murine|Camel|Human|Humanized|So-Other|Fluvirus|Llama> <fragment type:Fr-Other|Fab|Fv|Hc-Dimer|Lc-Dimer>\nENSURE THAT NEW STRUCTURES HAVE THE LIGHT AND THE HEAVY CHAINS AS 'L' & 'H'\nExample:perl -P ~/simcode/antibody/scripts/update_RosettaAntibody_database.pl list\nAn entry in the \"list\" file could be:\n2V7H Murine Fab\n(rampaths.txt and utilities.txt should be present in the current directory)\n") ;
}

unless ( -e "./rampaths.txt" ) {
		die ( "File rampaths.txt not found\n" ) ;
}
unless ( -e "./utilities.txt" ) {
		die ( "File utilities.txt not found\n" ) ;
}

#include "rampaths.txt"
# Copying file paths to all required directories
system( "cp $scripts/paths.txt ." );
system( "cp $scripts/*.txt $idealized/" );
system( "cp $scripts/*.txt $pdbfiles/" );
system( "cp $scripts/*.txt $database/" );
system( "cp $scripts/*.txt $abfrags/abfrags3" );
system( "cp $scripts/*.txt $abfrags/abfrags4" );
system( "cp $scripts/*.txt $abfrags/abfrags5" );
system( "cp $scripts/*.txt $dsspfiles/" );

$ab_list = shift @ARGV;
open( pdbs, "$ab_list" );
$pdbline = <pdbs>;
chomp( $pdbline );

while( $pdbline ne '' ) {
		@fields = split( /\ +/, $pdbline );
		$pdb = $fields[0].".pdb";
		$species = $fields[1];
		$frag = $fields[2];
		$pdbcode = substr( $pdb, 0, 4);
		$lower_pdbcode = lc( $pdbcode );
		print( "Processing... $pdb, $species, $frag\n" );
		
		# Extracting just the light and heavy chains 
		system( "extractChains.pl L $pdb | grep ATOM > L.pdb" );
		system( "extractChains.pl H $pdb | grep ATOM > H.pdb" );
		system( "grep HEADER $pdb > header" );
		system( "echo TER > terfile" );
		system( "cat header L.pdb terfile H.pdb > $pdbcode\_stripped.pdb" );
		system( "rm L.pdb H.pdb terfile" );
		
		# Chothia renumbering of antibody
		open( list, ">chothia_list" );
		print list ( "$pdbcode\_stripped LH:\n" );
		close( list );
		system( "$homedir/scripts/chothia_mapping.pl chothia_list" );
		system( "$homedir/scripts/chothia_renumber.pl chothia_list" );
		system( "mv $pdbcode\_stripped_chothia.pdb $pdbcode\_chothia.pdb" );
		system( "rm chothia_list *.heavy *.light $pdbcode\_stripped.pdb" );
		
		# Idealizing the antibody
		system( "echo TER > terfile" );
		system( "extractChains.pl L $pdbcode\_chothia.pdb|grep ATOM > L.pdb" );
		system( "extractChains.pl H $pdbcode\_chothia.pdb|grep ATOM > H.pdb" );
		system( "cat L.pdb terfile > L_chothia.pdb" );
		system( "cat H.pdb terfile > H_chothia.pdb" );
		system( "$bin/rosetta.gcc aa $pdbcode L -idealize -s L_chothia.pdb" );
		system( "$bin/rosetta.gcc aa $pdbcode H -idealize -s H_chothia.pdb" );
		
		# Superimposing the idealized chains
		system( "perl -P $scripts/ram_profit_script.pl $pdbcode\_chothia.pdb aaL_chothia_0001.pdb light > profit.in" ) ;
		system( "profit < profit.in" ) ;
		system( "rm profit.in aaL_chothia_0001.pdb" );
		system( "perl -P $scripts/ram_profit_script.pl $pdbcode\_chothia.pdb aaH_chothia_0001.pdb heavy > profit.in" ) ;
		system( "profit < profit.in" ) ;
		system( "rm profit.in aaH_chothia_0001.pdb" );
		system( "cat queryLfitted.pdb queryHfitted.pdb > $pdbcode\_idealized.pdb" );
		system( "rm query*.pdb header terfile L*.pdb H*.pdb" );
		
		# Copying renumbered and idealized antibodies to their respective directories
		system( "cp $pdbcode\_chothia.pdb $pdbfiles/pdb$lower_pdbcode\_chothia.pdb" );
		system( "cp $pdbcode\_idealized.pdb $pdbfiles/idealized/pdb$lower_pdbcode\_chothia.pdb" );
		system( "cp $pdbcode\_chothia.pdb pdb$lower_pdbcode\_chothia.pdb" );
		system( "cp $pdbcode\_idealized.pdb pdb$lower_pdbcode\_idealized.pdb" );
		system( "cp $pdbfiles/idealized/pdb$lower_pdbcode\_chothia.pdb $testset/" );
		
		# Create CDR Database entry and check for CDR H3 redundancy
		system( "ls  pdb$lower_pdbcode\_chothia.pdb > one_pdb_list" );
		system( "perl -P $scripts/ram_detectcdrs.pl one_pdb_list" );
		system( "perl -P $scripts/ram_parse_cdrdataline.pl $pdb $species $frag" );
		system( "cat $info/Cdrdatabase_all cdrdatabase_new1 > temp_cdrdatabase" );
		# Checking for CDR H3 redundancy
		$h3_seq = `cut -c 128-155 cdrdatabase_new1`;
		chomp( $h3_seq );
		system( "cut -c128-155 $info/Cdrdatabase_all > h3_seqs"); 
		system( "grep $h3_seq h3_seqs > h3_matches" );
		open( h3_match, "h3_matches" );
		$h3_redun = 0;
		$h3_hit = <h3_match>;
		chomp( $h3_hit );
		while( $h3_hit ne '' ) {
				if( $h3_hit eq $h3_seq ) {
						$h3_redun = 1;
						break;
				}
				$h3_hit = <h3_match>;
				chomp( $h3_hit );
		}
		close( h3_match );
		if( $h3_redun == 0 ) {
				system( "cat $idealized/list_fv_w_eliminations_nonrdnt_h3_0 one_pdb_list > temp_list_fv" );
				system( "mv temp_list_fv $idealized/list_fv_w_eliminations_nonrdnt_h3_0" );
		}
		system( "mv temp_cdrdatabase $info/Cdrdatabase_all" );
		system( "rm cdrdatabase_new1 one_pdb_list h3_seqs h3_matches" );
		
		# Create DSSP Entry
		system( "ls  pdb$lower_pdbcode\_idealized.pdb > one_pdb_list" );
		system( "perl -P $scripts/ram_create_dssp.pl one_pdb_list" );
		system( "mv $dsspfiles/pdb$lower_pdbcode\_idealized.dssp $dsspfiles/pdb$lower_pdbcode\_chothia.dssp" );
		system( "rm one_pdb_list" );
		
		# Add the antibody to respective category list
		system( "ls  pdb$lower_pdbcode\_chothia.pdb > one_pdb_list" );
		if( ($frag eq "Fr-Other") || ($frag eq "Fab" ) || ($frag eq "Fv") ) {
				system( "cat $pdbfiles/list_fv  one_pdb_list > temp_list_fv" );
				system( "mv  temp_list_fv $pdbfiles/list_fv" );
		}
		if( ($frag eq "Fr-Other") || ($frag eq "Fab" ) || ($frag eq "Fv") || ($frag eq "Hc-Dimer") ) {
				system( "cat $pdbfiles/list_fv_and_hdimer  one_pdb_list > temp_list_fv_and_hdimer" );
				system( "mv  temp_list_fv_and_hdimer $pdbfiles/list_fv_and_hdimer" );
		}
		if( ($frag eq "Fr-Other") || ($frag eq "Fab" ) || ($frag eq "Fv") || ($frag eq "Lc-Dimer") ) {
				system( "cat $pdbfiles/list_fv_and_ldimer  one_pdb_list > temp_list_fv_and_ldimer" );
				system( "mv  temp_list_fv_and_ldimer $pdbfiles/list_fv_and_ldimer" );
		}
		system( "rm one_pdb_list" );
		
		# Create CDR H3 fragments for the antibody
		$currentdir = getcwd();
		chdir( $idealized );
		system( "ls  pdb$lower_pdbcode\_chothia.pdb > one_pdb_list" );
		system( "perl -P $scripts/ram_create_CDR_fragments_frompdb.pl one_pdb_list H 94 103 h3 3" );
		system( "perl -P $scripts/ram_create_CDR_fragments_frompdb.pl one_pdb_list H 94 103 h3 4" );
		system( "perl -P $scripts/ram_create_CDR_fragments_frompdb.pl one_pdb_list H 94 103 h3 5" );
		system( "rm one_pdb_list" );
		chdir( $currentdir );
		
		# Calculating the Base of the CDR H3
		system( "cp pdb$lower_pdbcode\_chothia.pdb $lower_pdbcode.pdb" );
		system( "$bin/rosetta.gcc aa $lower_pdbcode _ -antibody_modeler -nstruct 1 -quiet -h3 -base -use_pdb_numbering -ccd_closure -s pdb$lower_pdbcode\_chothia -find_disulf -norepack_disulf" );
		system( "cat $info/h3_pseudo_dihedral $lower_pdbcode.H3_base > temp_H3_base" );
		system( "mv temp_H3_base $info/h3_pseudo_dihedral" );
		system( "rm pdb$lower_pdbcode\_chothia.pdb aapdb$lower_pdbcode\_chothia_0001.pdb *.fasc *.H3_base $lower_pdbcode.pdb" );
		system( "rm *_chothia.pdb *_idealized.pdb" );
		
		$pdbline = <pdbs>;
		chomp( $pdbline );
}

close( pdbs );

#  Create Fasta Sequences For Database Building
chdir( $pdbfiles );
system( "perl -P $scripts/ram_create_database.pl list_fv list_fv_and_ldimer list_fv_and_hdimer" );
chdir( $info );
system( "sort lightheavylengthfile | uniq | sort -k2 -r > temp" );
system( "mv temp lightheavylengthfile" );
chdir( $currentdir );
system( "rm $pdbfiles/*.txt" );

# Create Antibody Fragments: 3mers, 4mers and 5mers
chdir( $abfrags );
@abfragtypes = ( "3", "4", "5" );
foreach $abfragtype ( @abfragtypes ) {
		system( "cp $scripts/*.txt $abfrags/abfrags$abfragtype/" );
		chdir( "abfrags$abfragtype" );
		system( "ls *.pdb > list" );
		system( "perl -P $scripts/ram_create_h3_fragment_database.pl list H 1 $abfragtype h3 $abfragtype fasta" );
		system( "rm list *.txt" );
		chdir( "../" );
}
chdir( $currentdir );

# Creating BLAST databases
chdir( $database );
system( "perl -P $scripts/ram_create_database_lightheavy.pl" );
@databasetypes = ( "h1", "hbeta", "l2nterm", "light", "h2", "heavy", "l3", "lightheavy", "h3", "hfr", "lbeta", "motif", "h3cterm", "l1", "lfr", "h3nterm", "l2", "lfrhfr", "h3frag3", "h3frag4", "h3frag5" );
foreach $databasetype ( @databasetypes ) {
		$databasefile = "database.".$databasetype ;
		open( original, $databasefile );
		open( final, ">$databasefile\_new" );
		$id_line = <original>;
		$new_id_line = $id_line;
		chomp( $id_line );
		$fasta_line = <original>;
		$new_fasta_line = $fasta_line;
		chomp( $fasta_line );
		while( $id_line ne '' ) {
				if( ($id_line ne '') && ($fasta_line ne '') ) {
						print final ( "$new_id_line" );
						print final ( "$new_fasta_line" );
				}
				$id_line = <original>;
				$new_id_line = $id_line;
				chomp( $id_line );
				if( $id_line ne '' ) {
						$fasta_line = <original>;
						$new_fasta_line = $fasta_line;
						chomp( $fasta_line );
				}
		}
		close( final );
		close( original );
		system( "mv $databasefile\_new $databasefile" );
		system( "formatdb -i $databasefile" );
}
system( "rm *.txt" );
chdir( $currentdir );

# Creating CDR Fragments
chdir( "$dsspfiles" );
system( "ls *.dssp | sed 's/dssp/pdb/g' > list" );
system( "perl -P $scripts/create_fragments.pl list L 26 32 l1" );
system( "perl -P $scripts/create_fragments.pl list L 50 52 l2" );
system( "perl -P $scripts/create_fragments.pl list L 91 96 l3" );
system( "perl -P $scripts/create_fragments.pl list H 26 32 h1" );
system( "perl -P $scripts/create_fragments.pl list H 52 56 h2" );
system( "perl -P $scripts/create_fragments.pl list H 95 102 h3" );
system( "perl -P $scripts/create_fragments.pl list H 94 103 h3" );
system( "perl -P $scripts/create_h3fragments.pl list H 94 103 3" );
system( "perl -P $scripts/create_h3fragments.pl list H 94 103 4" );
system( "perl -P $scripts/create_h3fragments.pl list H 94 103 5" );
system( "cat $fragments/fragments_l1_26_32 $fragments/fragments_l2_50_52 $fragments/fragments_l3_91_96 > $fragments/fragments_l_all" );
system( "cat $fragments/fragments_h1_26_32 $fragments/fragments_h2_52_56 $fragments/fragments_h3_95_102 > $fragments/fragments_h_all" );
system( "cat $fragments/fragments_l_all $fragments/fragments_h_all > $fragments/fragments_all" );
system( "rm list *.txt" );
chdir( $currentdir );

system( "rm paths.txt $idealized/*.txt" );
