#!/bin/sh
#
# run_examples.sh
#
# Run the Design examples

program=`basename $0`

# NOTE: Change 'rosetta' to be the executable you are using.
rosetta="../source/rosetta.gcc"

# Make sure executable is valid
if [ ! -e $rosetta ]; then
    echo "$program: Executable missing.  Two possibilities:"
    echo "  (1) You didn't run 'RosettaDesign/setup.sh'"
    echo "  (2) You didn't build 'rosetta.gcc'."
    echo "      (If you are on a Mac modify run_examples.sh to use 'rosetta.mac'"
    exit;
fi

# We're running the executable in subdirectories: modify appropriately.
rosetta="../$rosetta"

# Create test directory

base_dir=flexible_backbone_design
test_dir=test.$base_dir

echo "Creating $test_dir"
rm -rf $test_dir
cp -fR $base_dir $test_dir

cd $test_dir

# Run Rosetta's design protocol for fixed backbones

echo -n "Fixed backbone test ..."
$rosetta -s 1ubq.pdb -design -fixbb -resfile resfile -ex1 -pdbout test -ndruns 3 > 1ubq_fixbb.log 2>&1
echo " done.  Status in '$test_dir/1ubq_fixbb.log'"

cd ../

# Create test directory

base_dir=flexible_backbone_design
test_dir=test.$base_dir

echo "Creating $test_dir"
rm -rf $test_dir
cp -fR $base_dir $test_dir

cd $test_dir

# Run Rosetta's design protocol for flexible backbones

echo -n "Flexible backbone test ..."
$rosetta da 1ubq _ -s 1ubq_faidl.pdb -design -mvbb -nstruct 3 > 1ubq_mvbb.log 2>&1
echo " done.  Status in '$test_dir/1ubq_mvbb.log'"

echo -n "Idealization test ..."
$rosetta -s 1ubq.pdb -idealize -fa_input > 1ubq_idealize.log 2>&1
echo " done.  Status in '$test_dir/1ubq_idealize.log'"
