#!/bin/sh
#
# setup.sh
#
# Setup environment for Rosetta to run the design protocol.

if [ -e "../rosetta++" ]; then
    echo "Creating 'source'"
    if [ -e source ]; then rm -f source; fi
    ln -s ../rosetta++ source
else
    echo "Cannot find '../rosetta++'.  Have you installed the 'rosetta_source' package?"
fi

if [ -e "../rosetta_database" ]; then
    echo "Creating 'database'"
    if [ -e database ]; then rm -f database; fi
    ln -s ../rosetta_database database
else
  echo "Cannot find '../rosetta_database'.  Have you installed the 'rosetta_database' package?"
fi

# if [ -e "../rosetta_scripts/design" ]; then
#     echo "Creating 'scripts'"
#     if [ -e scripts ]; then rm -f scripts; fi
#     ln -s ../rosetta_scripts/design scripts
# else
#     echo "Cannot find '../rosetta_scripts/design'.  Have you installed the 'rosetta_scripts' package?"
# fi

if [ -e "../rosetta_scripts/resfiles" ]; then
    echo "Creating 'scripts'"
    if [ -e scripts ]; then rm -f scripts; fi
    ln -s ../rosetta_scripts/resfiles scripts
else
    echo "Cannot find '../rosetta_scripts/resfiles'.  Have you installed the 'rosetta_scripts' package?"
fi

if [ -e "../rosetta_documentation/design" ]; then
    echo "Creating 'documentation'"
    if [ -e documentation ]; then rm -f documentation; fi
    ln -s ../rosetta_documentation/design documentation
else
    echo "Cannot find '../rosetta_documentation/design'.  Have you installed the 'rosetta_documentation' package?"
fi
