# RosettaDock example script
# JJG 8/20/2003

## this script is from the RosettaDock1.0 package, 
## which includes the input files for these examples

# be sure to have your PATH variable set correctly first (see ../README.txt)

# also be sure to have compiled the code and placed pFOLD.gnu in the
# bin/ directory.  [or a different compiler, replace gnu with absoft,
# e.g., in the varible below]

pdb=1UGH
compiler=gnu

# the first stage is a "prepack": this will remove the native side
# chain positions and replace them with Rosetta-generated side chains.
# This happens with the two docking partners far apart, to simulate
# the monomer components.

cd prepack/

rrun.sh $compiler $pdb aa -prepack -s $pdb -ex1 -ex34 -find_disulf

# here we copy the prepacked structure for later use as a starting structure
cp $pdb/aa/$pdb.ppk.pdb ../pdb/
cd ../


# one type of study is a small perturbation study:

cd perturb/

rrun.sh $compiler $pdb aa -dock_mcm -ex1 -ex34 -find_disulf -norepack_disulf -nstruct 2
# this will create five decoys near the starting (native) position

cd ../

# a global search is done as follows, except in a global search you
# would create many more decoys (~10^5)

cd global/

rrun.sh $compiler $pdb aa -dock_mcm -randomize1 -randomize2 -ex1 -ex34 \
    -find_disulf -norepack_disulf -nstruct 2
rrun.sh $compiler $pdb ab -dock_mcm -randomize1 -randomize2 -ex1 -ex34 \
    -find_disulf -norepack_disulf -nstruct 2
#...repeat many times...

# after creating many such decoys, combine the runs and cluster in
# post-processing: (requires R, see R-project.org)
pp_pdb.sh $pdb
# predicted models with scores and cluster sizes in $pdb/top200/clusterscores.bysize



# that's it!
# have fun and good luck.




### check flags
### rerun entire thing
