#!/bin/sh
#
# run_examples.sh
#
# Run the fragments examples

program=`basename $0`

# Fragment building script
make_fragments="../../source/make_fragments.pl"

# Make a test directory for the new runs
testdir=test.1ubq
/bin/rm -rf $testdir
cp -rf 1ubq $testdir

# Enter the test directory
cd $testdir
echo "Test directory: `pwd`"

# Make sure executable is valid
if [ ! -e $make_fragments ]; then
    echo "$program: Script missing.  Did you run 'RosettaFragments/setup.sh?'"
    exit;
fi

# Run NNMake (the fragment builder)

echo -n "Making fragments ..."
$make_fragments 1ubq_.fasta > 1ubq_fragments.log 2>&1
echo " done.  Status in '1ubq_fragments.log'"
