#!/bin/sh
#
# setup.sh
#
# Setup environment for Rosetta fragment construction.

if [ -e "../rosetta_fragments" ]; then
    echo "Creating 'source'"
    if [ -e source ]; then rm -f source; fi
    ln -s ../rosetta_fragments source
else
    echo "Cannot find '../rosetta_fragments'.  Have you installed the 'rosetta_fragments' package?"
fi

if [ -e "../rosetta_fragments/chemshift_database" ]; then
    echo "Creating 'chemshift_database'"
    if [ -e chemshift_database ]; then rm -f chemshift_database; fi
    ln -s ../rosetta_fragments/chemshift_database chemshift_database
else
  echo "Cannot find '../rosetta_fragments/chemshift_database'.  Have you installed the 'rosetta_database' package?"
fi

if [ -e "../rosetta_fragments/nnmake_database" ]; then
    echo "Creating 'nnmake_database'"
    if [ -e nnmake_database ]; then rm -f nnmake_database; fi
    ln -s ../rosetta_fragments/nnmake_database nnmake_database
else
  echo "Cannot find '../rosetta_fragments/nnmake_database'.  Have you installed the 'rosetta_database' package?"
fi

if [ -e "../rosetta_documentation/fragments" ]; then
    echo "Creating 'documentation'"
    if [ -e documentation ]; then rm -f documentation; fi
    ln -s ../rosetta_documentation/fragments documentation
else
    echo "Cannot find '../rosetta_documentation/fragments'.  Have you installed the 'rosetta_documentation' package?"
fi
