#!/bin/sh
#
# run_examples.sh
#
# Run the NMR examples

program=`basename $0`

# Make a test directory for the new runs
/bin/rm -rf test
mkdir test

# Enter the test directory
cd test
echo "Test directory: `pwd`"

# Scripts used in the examples
# NOTE: Change 'rosetta' to be the executable you are using.
rosetta="../../source/rosetta.gcc"

# Make sure executable is valid
if [ ! -e $rosetta ]; then
    echo "$program: Executable missing.  Two possibilities:"
    echo "  (1) You didn't run 'RosettaNMR/setup.sh'"
    echo "  (2) You didn't build 'rosetta.gcc'."
    echo "      (If you are on a Mac modify run_examples.sh to use 'rosetta.mac"
    exit;
fi

# Make a test directory for the new runs
# Link input files (fragment files) to test directory.
ln -s ../1d3z/1d3z_.fasta .
ln -s ../1d3z/aa1d3z_03_05.200_v1_3 .
ln -s ../1d3z/aa1d3z_09_05.200_v1_3 .
ln -s ../1d3z/paths.txt .

# Run Rosetta's ab initio protocol

echo -n "Distance constraints test ..."
$rosetta bb 1d3z _ -constant_seed -nstruct 1 -paths ../1d3z/paths.txt -cst cst_bb > 1d3z_cst.log 2>&1
echo " done.  Status in '1d3z_cst.log' and '1d3z_cst.fast.log"

echo -n "Relax test ... "
$rosetta dd 1d3z _ -relax -s 1d3z_test.pdb -cst cst_sc -dpl dpl_hn -nstruct 1 -constant_seed -paths ../1d3z/paths.txt > 1d3z_relax.log 2>&1
echo " done.  Status in '1d3z_relax.log'"


