// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_AnkyrinRepeat_classes
#define INCLUDED_AnkyrinRepeat_classes

// Rosetta Headers
#include "pose.h"

// C++ Headers
#include <string>

// jk Class definition for AnkyrinModule
class AnkyrinModule
{

private:

	pose_ns::Pose pose_;
	std::string name_;

public:

	// jk pose doesn't have a copy constructor, so compilers won't build us a default one.
	// jk For this reason, define a copy constructor which calls pose = operator
	inline AnkyrinModule() {};
	inline AnkyrinModule( const AnkyrinModule & in_AR ) { this->pose_ = in_AR.pose_; };
	inline AnkyrinModule & operator=( const AnkyrinModule & in_AR ) { this->pose_ = in_AR.pose_; return *this; };
	inline AnkyrinModule( std::string const & in_pdbfile ) { read_module( in_pdbfile ); };

	void read_module( std::string const & in_pdbfile );

	void replace_module_in_pose( pose_ns::Pose & protein_pose, int const start_seqpos );

};


#endif
