// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_AnkyrinRepeat_functions
#define INCLUDED_AnkyrinRepeat_functions

// C++ Headers
#include <string>

// forward declarations
namespace pose_ns { class Pose; }
class AnkyrinModule;

void do_AR_setup();

void load_AR_data( std::string const & AR_conservation_file );

void update_AR_interface_neighbors( pose_ns::Pose const & pose );

void convert_all_to_Asn( pose_ns::Pose & pose );

void convert_all_to_Asp( pose_ns::Pose & pose );

void convert_all_to_Ser( pose_ns::Pose & pose );

void convert_Asp_to_Asn( pose_ns::Pose & pose, int const seqpos );

void convert_Asn_to_Asp( pose_ns::Pose & pose, int const seqpos );

void repack_AspAsn( pose_ns::Pose & pose );


#endif
