// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15540 $
//  $Date: 2007-06-19 15:37:31 -0700 (Tue, 19 Jun 2007) $
//  $Author: chu $


#ifndef INCLUDED_ClassBondSmallMolecule
#define INCLUDED_ClassBondSmallMolecule


////////////////////////////////////////////////////////////////////////////////////////////////////
// /Class: BondSmallMolecule
//
///Project: Rosetta
//
/// Language: C++
//
///Author: Kristian Kaufmann
////////////////////////////////////////////////////////////////////////////////////////////////////


/// Rosetta Headers
#include"atom_chem.h"
#include"atom.h"
/// ObjexxFCL Headers
#include <numeric/xyzVector.hh>
#include <numeric/xyzMatrix.hh>
/// C++ Headers
#include<iostream>
#include<cmath>
// Using

typedef Atom * AtomAP;
// Forward


////////////////////////////////////////////////////////////////////////////////////////////////////
// BondSmallMolecule: Atomic BondSmallMolecule Class
////////////////////////////////////////////////////////////////////////////////////////////////////

class BondSmallMolecule
{


private: // Types //////////////////////////////////////////////////////////////////////////////////

public: // Types ///////////////////////////////////////////////////////////////////////////////////

public: // Creation /////////////////////////////////////////////////////////////////////////////


	//===============================================================================================
	// Default Constructor
	//===============================================================================================
	BondSmallMolecule( AtomAP & atom1, AtomAP & atom2)
	{
		atom1_=atom1;
		atom2_=atom2;
		rotable_=true;
		int success = atom2_->add_parentbond(this);
		if (success!=0){
			//std::cerr << "two parent atom assignment attempted" << std::endl;
			atom2_->add_childbond(this);
			rotable_=false;
		}
		atom1_->add_childbond(this);
		bondtype_=atom_chem::NO_BOND;

  	}


private: // Creation ///////////////////////////////////////////////////////////////////////////////


	//===============================================================================================
	// Copy Constructor
	//===============================================================================================
	BondSmallMolecule( BondSmallMolecule const & ); // Undefined: Disallow


public: // Creation ////////////////////////////////////////////////////////////////////////////////


	//===============================================================================================
	// Destructor
	//===============================================================================================

	~BondSmallMolecule()
	{
	atom1_->delete_bond( this );
	atom2_->delete_bond( this );
	}


private: // Assignment /////////////////////////////////////////////////////////////////////////////


	//===============================================================================================
	// Copy Assignment
	//===============================================================================================
	BondSmallMolecule &
	operator=( BondSmallMolecule const & ); // Undefined: Disallow


protected: // Assignment ///////////////////////////////////////////////////////////////////////////


public: // Inspectors //////////////////////////////////////////////////////////////////////////////

	inline
	bool
	IsRotable()const {
		return rotable_;
	}

	inline
	atom_chem::BondType
	get_bondtype() const
	{ return bondtype_;}

	inline
	void
	bonded_atoms(
	AtomAP & atomA, // The value of these pointers will be changed by this function
	AtomAP & atomB //
	){
		atomA=atom1_;
		atomB=atom2_;
		return;
	}

	inline
	double
	get_dihedral()const {
		return dwrcoordinates_.x();
	}

	inline
	double
	get_angle()const {
		return dwrcoordinates_.y();
	}

	inline
	double
	get_length() const{
		return dwrcoordinates_.z();
	}

	inline
	numeric::xyzVector<double>
	get_coordinates()const {
		return dwrcoordinates_;
	}

	inline
	numeric::xyzMatrix<double>
	get_rotation_matrix(
		const double theta,
		numeric::xyzVector<double> & origin
	){
		numeric::xyzVector<double> axis=(atom2_->get_coordinates()
		 - atom1_->get_coordinates());
		origin=atom1_->get_coordinates();
		axis.normalize();
		double quaternion[4];
		double sin_theta_2=sin(theta/2);
		quaternion[0]=cos(theta/2.0);
		quaternion[1]=sin_theta_2*axis.x();
		quaternion[2]=sin_theta_2*axis.y();
		quaternion[3]=sin_theta_2*axis.z();
		numeric::xyzVector<double> x_row(
			1-2*quaternion[2]*quaternion[2]-2*quaternion[3]*quaternion[3],//xx
			2*quaternion[1]*quaternion[2]-2*quaternion[0]*quaternion[3],//xy
			2*quaternion[1]*quaternion[3]+2*quaternion[2]*quaternion[0]);//xz

		numeric::xyzVector<double> y_row(
			2*quaternion[1]*quaternion[2]+2*quaternion[0]*quaternion[3],//yx
			1-2*quaternion[1]*quaternion[1]-2*quaternion[3]*quaternion[3],//yy
			2*quaternion[2]*quaternion[3]-2*quaternion[0]*quaternion[1]);//yz

		numeric::xyzVector<double> z_row(
			2*quaternion[1]*quaternion[3]-2*quaternion[0]*quaternion[2],//zx
			2*quaternion[2]*quaternion[3]+2*quaternion[0]*quaternion[1],//zy
			1-2*quaternion[1]*quaternion[1]-2*quaternion[2]*quaternion[2]);//zz

		return numeric::xyzMatrix<double>::rows_constructor( x_row,y_row,z_row);
	}




public: // Modifiers ///////////////////////////////////////////////////////////////////////////////

	inline
	void
	set_bondtype(
		atom_chem::BondType kind
	){ bondtype_ = kind; return;}

	inline
	void
	set_dihedral(
		double dihedral
	){ dwrcoordinates_.x()=dihedral; return;}

	inline
	void
	set_angle(
		double angle
	){ dwrcoordinates_.y()=angle; return;}

	inline
	void
	set_length(
		double length
	){ dwrcoordinates_.z()=length; return;}

	inline
	void
	set_coordinates(
		numeric::xyzVector<double> internal_coordinates
	){ dwrcoordinates_=internal_coordinates; return;}

	inline
	void
	set_rotability(
		bool rotable
	){
		rotable_=rotable; return;
	}




protected: // Functions ////////////////////////////////////////////////////////////////////////////


private: // Data ///////////////////////////////////////////////////////////////////////////////////
  AtomAP atom1_ ;		// pointer to parent atom not owned by bond.
  AtomAP atom2_ ;		// pointer to child atom not owned by bond.
  atom_chem::BondType bondtype_ ;        	// enumeration founs in atom_chem.h
  numeric::xyzVector<double> dwrcoordinates_; // torsion space parameters.
					// x=dihedral of atom1_ parent bond, y=angle between current bond and atom1_
					// parent bond, z=length of current bond
  bool rotable_ ;		// bond flexibility not implemented yet.


}; // BondSmallMolecule
////////////////////////////////////////////////////////////////////////////////////////////////////


#endif
