// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

// C++ headers
#include <cstdlib>
#include <cstdio>
#include <iostream>
#include <map>
#include <string>
#include <algorithm>
//#include <ifstream>

// Rosetta headers
#include "aa_name_conversion.h"
#include "misc.h"
#include "param.h"
#include "DesignMap.h"
#include "ConformerLibHandler.h"
#include "aaproperties_pack.h" // need this for MAX_ATOM MAX_AA
#include "read_paths.h" //need this for read_file thingy"
#include "pack.h" //need this for num_from_name, get_aa_rotno_to_packedrotno()
#include "read_aaproperties.h" // need this for atom_num_from_atom_name
#include "pack_geom_inline.h" // for align_bk and lineup_bk
#include "param_aa.h"
#include "input_pdb.h" // for dihedral()
#include "files_paths.h" // for use_bbind_conformer
#include "RotamerSet.h"
#include "rotamer_functions.h"

// ObjexxFCL headers
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/formatted.io.hh>


//using namespace param;
//Utility Headers
#include <utility/basic_sys_util.hh>
//#include <utility/io/irstream.hh>
#include <utility/io/izstream.hh>


////////////////////////////////////////////////////////////////////////////////
/// @begin	isConformerKeyValid
///
/// @brief  check to see if conformers exist in this phi-psi space
///
/// @detailed
///
/// @param  key - [in] - a pre-assembled key, aa:phi:psi
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors   psh
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool ConformerLibHandler::isConformerKeyValid(std::string key) {

  std::map<std::string, FArray1D_int>::iterator iterator;
  iterator = rotamerSerialRanges.find(key);
  if (iterator != rotamerSerialRanges.end()){
    return 1;
  }
  return 0;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin	conformerKeyFromCoord
///
/// @brief	gets conformer keys for a particular aa at a seqpos
///
/// @detailed
/// 				generates the assembled key by referencing the amino acid at a seqpos
///					by looking up the phi psi values from misc namespace
/// 				first by binning the phi psi into dunbrack definition
///
/// @param  aa - [in] -
/// @param  seqpos - [in] -
///
/// @global_read phi[], psi[]
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors psh
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
std::string ConformerLibHandler::conformerKeyFromCoord(int seqpos, int aa ) {

  using namespace misc; // for phi[] psi[]
  using namespace files_paths; // for use_bbind_conformer
  using namespace param_aa; // for aa_pro

  int dunphi, dunpsi;
  float decoyphi, decoypsi;
  std::string key;
  std::stringstream bufferString;
  bufferString.clear();
  bufferString.seekp(0,std::ios_base::beg);

  if (phi(seqpos) < 0) {  // making phi psi periodic for dunbrack bin conversion
    decoyphi = phi(seqpos)+360;
  } else {
    decoyphi = phi(seqpos);
  }
  if (psi(seqpos) < 0) {
    decoypsi = psi(seqpos)+360;
  } else {
    decoypsi = psi(seqpos);
  }
  dunphi = (round(decoyphi/10)*10);//converted to binned values
  dunpsi = (round(decoypsi/10)*10);
  if (dunphi > 180){ dunphi -= 360; }
  if (dunpsi > 180){ dunpsi -= 360; }
  //if bbind conformer is used, force all phi psi values to 999
  //expcept for proline which should always be bbdep
  if (use_bbind_conformer && aa != aa_pro) {
    dunphi = 999;
    dunpsi = 999;
  }
  //generate key from res[]
  bufferString << aa << ":" << dunphi << ":" << dunpsi ;
  key = bufferString.str();
  return key;
  // end of key generation
}

////////////////////////////////////////////////////////////////////////////////
/// @begin  readBDALib
///
/// @brief  read BDA's clustered conformer library
///
/// @detailed
/// bda library is different because it does not have records for C and O.
/// So use it's corresponding build function to copy the mainchain from
/// fullcoord and only use the sidechains
///
/// @param  confLibChoice - [in] - which one to read from 0.1 (largest) to 0.9 (smallest)
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors  psh
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void ConformerLibHandler::readBDALib(std::string scaleFileName) {

  using namespace param; // for MAX_ATOM MAX_AA
  using namespace files_paths; // for use_bbind_conformer switch
  using namespace param_aa; // for aa_his

  char threeLetterCode[4];
  char lineInitBuffer[5];
  char atomNameBuffer[5];
  std::string atomName;
  std::string aaName;
  std::string key, prevkey;
  int phi,psi;
  int phibin, psibin;
  int prevphi, prevpsi;
  int prevStartConfSerial, prevaan;
  int conformerSerial;
  int prevCount; // this is needed for HIS variants because the index has to continue for the two diffrerent types, only aav changes
  char line[200];
  int aan; // to hold amino acid number used in rosetta
  int aav; // amino acid variant number
  int atomNum; //to store the converted atom number from atom name
  FArray1D_int	mapBuffer;
  FArray1D_float coordBuffer(3); // to load x,y,z
  std::string conformer_library_name;

  //initialization
  libraryStorage.dimension(3,MAX_ATOM(),7500,MAX_AA()); //7000 being a temp max serial number
  conformer_aav.dimension(MAX_AA(),7500);
  mapBuffer.dimension(2);
  probabilityForEachRotamerSerial.dimension(7500,MAX_AA());
  scaleArray.dimension(MAX_AA(), MAX_AA_VARIANTS());
  prevCount = 0;
  prevphi=-1; // make sure it is outside of range
  prevpsi=-1;
  prevStartConfSerial=0;
  prevaan=0;
  prevkey=" ";
  readScale(scaleFileName);
  for (int i = 1 ; i <= MAX_AA() ; i++){
    int count = 0;
    for (int j = 1; j <= MAX_AA_VARIANTS(); j++){
      //empty values were initialized to be -1, skip just in case MAX_AA_VARIANTS is set elsewhere to be more than 2
      if (scaleArray(i,j) != -1) {
	if (i == aa_his && j == 1) { // if i equals 7.  Only deal with his variants for now
	  aaName = "HIE";
	} else if ( i == aa_his && j == 2) {
	  aaName = "HID";
	  count = prevCount; // prevCount offset so the two his can be read into the same HIS group
	} else {
	  name_from_num(i,aaName);
	}
	char scaleValue[4];
	sprintf(scaleValue,"%3.1f",scaleArray(i,j));
	std::stringstream nameBuffer;
	if (use_bbind_conformer && i != aa_pro) { // force prolines to be bbdep
	  nameBuffer << "bda_bbind/" << aaName.c_str() << "/" << aaName.c_str() << "_" << scaleValue;
	} else {
	  nameBuffer << "bda_bbdep/" << aaName.c_str() << "/" << aaName.c_str() << "_" << scaleValue;
	}

	conformer_library_name= nameBuffer.str();
	utility::io::izstream & iunit( open_data_file( conformer_library_name ) );
	bool firstEntrySet = false; // switch for setting first line marker
	while (! iunit.eof()){
	  aav=1; // reset variant type
	  std::stringstream bufferString;
	  iunit.getline(line, 200);
	  //read lines
	  std::sscanf(line, "%4s", lineInitBuffer);
	  //std::cout<<lineInitBuffer<<std::endl;
	  if (strcmp(lineInitBuffer,"USER")==0) { //process remark line
	    std::sscanf( line+17,"%3s", threeLetterCode);
	    std::sscanf( line+21,"%5d", &conformerSerial);
	    std::sscanf( line+30, "%4d", &phi );
	    std::sscanf( line+38, "%4d", &psi );
	    // std::sscanf( line+98, "%8f", &perc );
	    phibin = ((phi+180)/10);
	    psibin = ((psi+180)/10);
	    //std::cout << "conformerSerial" << conformerSerial << std::endl;
	    //construct the key
	    if (strcmp(threeLetterCode,"HID")==0) {
	      //	std::cout << "hid?" << std::endl;
	      threeLetterCode[0] = 'H';
	      threeLetterCode[1] = 'I';
	      threeLetterCode[2] = 'S';
	      aav=2;
	      conformerSerial += prevCount;
	      //std::cout << "confSerial " << conformerSerial << std::endl;
	      //bypass for testing with bbind
	      //	continue;
	      //			std::cout << threeLetterCode << std::endl;
	    } else if (strcmp(threeLetterCode,"HIE")==0){
	      threeLetterCode[0]= 'H';
	      threeLetterCode[1]= 'I';
	      threeLetterCode[2]= 'S';
	    } else if (strcmp(threeLetterCode,"HSP")==0){
	      //std::cout << "hsp" << std::endl;
	      continue;
	    }
	    //else if (strcmp(threeLetterCode,"GLY")==0){
	    //		continue; //skip glys
	    //	}
	    num_from_name(threeLetterCode, aan);
	    bufferString.clear();
	    bufferString.seekp(0,std::ios_base::beg);
	    if (use_bbind_conformer && i != aa_pro){ //bbind
	      bufferString << aan << ":" << phi << ":" << psi;
	    } else {
	      bufferString << prevaan << ":" << prevphi << ":" << prevpsi ;
	    }
	    key=bufferString.str();
	    //	std::cout << "key" << key << std::endl;
	    //end of key
	    count++; // increment per USER entry, reset when see new aa/phi/psi
	    mapBuffer(2) = count; // keep getting updated with the current count
	    if (use_bbind_conformer && i != aa_pro){
	      if (firstEntrySet == false){
		mapBuffer(1) = 1; // hardwire for now
		//	std::cout << "mp1 " << mapBuffer(1) << std::endl;
		rotamerSerialRanges[key] = mapBuffer;
		firstEntrySet=true;
	      } else {
		mapBuffer(2) = count;
		//	std::cout << "mp2 " << mapBuffer(2) << std::endl;
		rotamerSerialRanges[key] = mapBuffer;
	      }
	      conformer_aav(aan,conformerSerial) = aav;
	      //std::cout << rotamerSerialRanges[key](1) << " " << rotamerSerialRanges[key](2) << " " << key << std::endl;
	    } else { //bbdep
	      //the following only works for concatenated library files,
	      //preserve incase the behavior will be changed in the future
	      //doing it this way will have an extra entry when the first line is
	      //read and had to do something
	      //about the last line.  But the result is pretty elegant.
	      if ((prevphi != phi || prevpsi!= psi || prevaan != aan)){
		mapBuffer(1)=prevStartConfSerial;
		mapBuffer(2)=prevStartConfSerial+count-1;
		count = 0;
		if ((mapBuffer(2) - mapBuffer(1) + 1) >= 9){  //if more than 9, keep
		  rotamerSerialRanges[key] = mapBuffer;
		}
		if ( i == aa_pro ){ // if proline always keep even if count < 9
		  rotamerSerialRanges[key] = mapBuffer;
		}
		prevphi=phi;
		prevpsi=psi;
		prevStartConfSerial = conformerSerial;
		prevaan=aan;
		prevkey=key;
		//std::cout << rotamerSerialRanges[key](1) << " " << rotamerSerialRanges[key](2) << " " << key << std::endl;
		//	mapBuffer.initializer_clear(); // restart the array for the next set
	      }
	      //store aav type
	      conformer_aav(aan,conformerSerial) = aav;
	    }

	  } else if (strcmp(lineInitBuffer, "ATOM")==0){ //process coordinates
	    std::sscanf(line+17,"%3s", threeLetterCode);
	    std::sscanf(line+12,"%4c", atomNameBuffer);
	    atomName.assign(atomNameBuffer,0,4); //force to be a length 4 string
	    std::sscanf( line+30, "%8f", &coordBuffer(1));
	    std::sscanf( line+38, "%8f", &coordBuffer(2));
	    std::sscanf( line+46, "%8f", &coordBuffer(3));
	    if (strcmp(threeLetterCode,"HID")==0) {
	      threeLetterCode[0] = 'H';
	      threeLetterCode[1] = 'I';
	      threeLetterCode[2] = 'S';
	      aav=2;
	      //bypass for testing with bbind
	      //	continue;
	    } else if (strcmp(threeLetterCode,"HIE")==0){
	      threeLetterCode[0]= 'H';
	      threeLetterCode[1]= 'I';
	      threeLetterCode[2]= 'S';
	    } else if (strcmp(threeLetterCode,"HSP")==0){
	      continue;
	    }
	    //			else if (strcmp(threeLetterCode,"GLY")==0){
	    //				continue; //skip glys
	    //			}

	    atom_num_from_atom_name(atomName,aan,aav,atomNum);
	    //	if (aan == 7)
	    //	std::cout << "atomnum" << atomNum << " atomname" << atomName << " " << threeLetterCode << conformerSerial << std::endl;
	    //store coordinates in a 4D array
	    libraryStorage(1,atomNum,conformerSerial,aan) = coordBuffer(1);
	    libraryStorage(2,atomNum,conformerSerial,aan) = coordBuffer(2);
	    libraryStorage(3,atomNum,conformerSerial,aan) = coordBuffer(3);

	    //std::cout << conformerSerial << ":" << aan << ":" << libraryStorage(1,atomNum,conformerSerial,aan) << std::endl;
	  } else if (strcmp(lineInitBuffer, "TER")==0){
	    continue;
	  } else { // screw up?
	    std::cout << "STOP:: error reading conformer library file" << std::endl;
	    utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	  }
	}
	//std::cout << rotamerSerialRanges[key](1) << " " << rotamerSerialRanges[key](2) << "eof" << key << std::endl;

	iunit.close();
	iunit.clear();
	if ((!use_bbind_conformer) || i == aa_pro){
	  // process the last entry , ugly hack.... but works
	  // needs a new key as it has to reflect the current aa and not prevaa
	  std::stringstream bufferString;
	  bufferString.clear();
	  bufferString.seekp(0,std::ios_base::beg);
	  bufferString << aan << ":" << phi << ":" << psi ;
	  key=bufferString.str();
	  mapBuffer(1)=prevStartConfSerial;
	  mapBuffer(2)=conformerSerial;
	  if ((mapBuffer(2) - mapBuffer(1) + 1) >= 9){  //if more than 9, keep
	    rotamerSerialRanges[key] = mapBuffer;
          }
	  if (i == aa_pro) { // if proline always keep even if count < 9
	    rotamerSerialRanges[key] = mapBuffer;
	  }
	  //std::cout << rotamerSerialRanges[key](1) << " " << rotamerSerialRanges[key](2) << "eof" << key << std::endl;
	}
      } // if scaleArray
      prevCount = count;
    } // for j
  } // for i

  return;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin  readScale
///
/// @brief  read the scale file that specifies the rmsd cluster distance for
///         each aa
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors  psh
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void ConformerLibHandler::readScale(std::string scaleFileName) {

  using namespace files_paths; // for use_bbind_conformer
  using namespace param; // for MAX_AA MAX_AA_VARIANTS
  std::string aaName;
  int aan, aav;
  float scale;
  scaleArray.dimension(MAX_AA(),MAX_AA_VARIANTS());
  //initialize to unreasonable values to be safe
  for (int i =1 ; i<= MAX_AA(); i++){
    for (int j = 1 ; j <= MAX_AA_VARIANTS(); j++){
      scaleArray(i,j) = -1;
    }
  }
  std::stringstream bufferStream;
  if (use_bbind_conformer) {
    bufferStream << "bda_bbind/" << scaleFileName;
  } else {
    bufferStream << "bda_bbdep/" << scaleFileName;
  }
  utility::io::izstream & iunit( open_data_file( bufferStream.str()) );
  while (! iunit.eof()){
    iunit >> bite( 3, aaName) >> skip(1) >> bite(3, scale) >> skip ;
    //std::cout << aaName.c_str() << std::endl;
    //std::cout << scale << std::endl;
    //only handle HIS variant for now
    //std::cout << "aaName " << aaName << ":" << std::endl;
    if (strcmp(aaName.c_str(), "HIE" ) ==0){
      aan = 7;
      aav = 1;
    } else if (strcmp(aaName.c_str(),"HID")==0){
      aan = 7;
      aav = 2;
    } else {
      num_from_name(aaName.c_str(),aan);
      aav = 1;
    }
    if (strcmp(aaName.c_str(),"END") ==0){
      break;
    }
    //std::cout << aan << std::endl;
    scaleArray(aan,aav) = scale;
  }

  return;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin  readLib
///
/// @brief  read conformer library (currently not completed) do not use.
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors  psh
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void ConformerLibHandler::readLib() {

  using namespace aaproperties_pack; //for MAX_ATOM MAX_AA
  using namespace param;

  char threeLetterCode[4];
  char lineInitBuffer[5];
  char atomNameBuffer[5];
  std::string atomName;
  std::string key, prevkey;
  int phi,psi;
  int phibin, psibin;
  int prevphi, prevpsi;
  int conformerSerial, prevStartConfSerial, prevaan;
  //float perc;
  char line[200];
  int aan; // to hold amino acid number used in rosetta
  int aav; // amino acid variant number
  int atomNum; //to store the converted atom number from atom name
  FArray1D_int	mapBuffer;
  FArray1D_float coordBuffer(3); // to load x,y,z
  std::string conformer_library_name;

  //initialization
  libraryStorage.dimension(3,MAX_ATOM(),6000,MAX_AA()); //6000 being a temp max serial number
  mapBuffer.dimension(2);
  probabilityForEachRotamerSerial.dimension(6000,MAX_AA());
  prevphi=-1; // make sure it is outside of range
  prevpsi=-1;
  prevStartConfSerial=0;
  prevaan=0;
  prevkey=" ";

  conformer_library_name = "confDunEqiv3.full.lib";
  //	conformer_library_name = "testconfDun.lib";
  utility::io::izstream & iunit( open_data_file( conformer_library_name ) );
  while (! iunit.eof()){
    aav=1; // reset variant type
    std::stringstream bufferString;
    iunit.getline(line, 200);
    //read lines
    std::sscanf(line, "%4s", lineInitBuffer);
    if (strcmp(lineInitBuffer,"REMA")==0) { //process remark line
      std::sscanf( line+7,"%3s", threeLetterCode);
      std::sscanf( line+10,"%6d", &conformerSerial);
      std::sscanf( line+80, "%4d", &phi );
      std::sscanf( line+85, "%4d", &psi );
      //		  std::sscanf( line+98, "%8f", &perc );
      phibin = ((phi+180)/10);
      psibin = ((psi+180)/10);
      //std::cout << "conformerSerial" << conformerSerial << std::endl;
      //construct the key
      if (strcmp(threeLetterCode,"HID")==0) {
	//	std::cout << "hid?" << std::endl;
	threeLetterCode[0] = 'H';
	threeLetterCode[1] = 'I';
	threeLetterCode[2] = 'S';
	//aav=2;
	continue;
	//	std::cout << threeLetterCode << std::endl;
      } else if (strcmp(threeLetterCode,"HIE")==0){
	threeLetterCode[0]= 'H';
	threeLetterCode[1]= 'I';
	threeLetterCode[2]= 'S';
      } else if (strcmp(threeLetterCode,"HSP")==0){
	//std::cout << "hsp" << std::endl;
	continue;
      }
      num_from_name(threeLetterCode, aan);
      bufferString.clear();
      bufferString.seekp(0,std::ios_base::beg);
      bufferString << prevaan << ":" << prevphi << ":" << prevpsi ;
      key=bufferString.str();
      //			probabilityForEachRotamerSerial(conformerSerial, aan) = perc;
      //std::cout << key << std::endl;
      //end of key
      mapBuffer(2) = conformerSerial; // keep getting updated with the current serial number
      //doing it this way will have an extra entry when the first line is read and had to do something
      //about the last line.  But the result is pretty elegant.
      if ((prevphi != phi || prevpsi!= psi || prevaan != aan)){
	mapBuffer(1)=prevStartConfSerial;
	mapBuffer(2)=conformerSerial-1;
	rotamerSerialRanges[key] = mapBuffer;
	prevphi=phi;
	prevpsi=psi;
	prevStartConfSerial = conformerSerial;
	prevaan=aan;
	prevkey=key;
	//				std::cout << rotamerSerialRanges[key](1) << " " << rotamerSerialRanges[key](2) << " " << key << std::endl;
	//			mapBuffer.initializer_clear(); // restart the array for the next set
      }
    } else if (strcmp(lineInitBuffer, "ATOM")==0){ //process coordinates
      std::sscanf(line+17,"%3s", threeLetterCode);
      std::sscanf(line+12,"%4c", atomNameBuffer);
      atomName.assign(atomNameBuffer,0,4); //force to be a length 4 string
      std::sscanf( line+30, "%8f", &coordBuffer(1));
      std::sscanf( line+38, "%8f", &coordBuffer(2));
      std::sscanf( line+46, "%8f", &coordBuffer(3));
      if (strcmp(threeLetterCode,"HID")==0) {
	//  std::cout << "hid?" << std::endl;
        threeLetterCode[0] = 'H';
        threeLetterCode[1] = 'I';
        threeLetterCode[2] = 'S';
        aav=2;
        continue;
	//  std::cout << threeLetterCode << std::endl;
      } else if (strcmp(threeLetterCode,"HIE")==0){
        threeLetterCode[0]= 'H';
        threeLetterCode[1]= 'I';
        threeLetterCode[2]= 'S';
      } else if (strcmp(threeLetterCode,"HSP")==0){
        //std::cout << "hsp" << std::endl;
        continue;
      }

      atom_num_from_atom_name(atomName,aan,aav,atomNum);
      //std::cout << "atomnum" << atomNum << " atomname" << atomName << " " << threeLetterCode << conformerSerial << std::endl;
      //store coordinates in a 4D array
      libraryStorage(1,atomNum,conformerSerial,aan) = coordBuffer(1);
      libraryStorage(2,atomNum,conformerSerial,aan) = coordBuffer(2);
      libraryStorage(3,atomNum,conformerSerial,aan) = coordBuffer(3);

      //std::cout << conformerSerial << ":" << aan << ":" << libraryStorage(1,atomNum,conformerSerial,aan) << std::endl;

    } else { // screw up?
      std::cout << "STOP:: error reading conformer library file" << std::endl;
      utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
    }
  }
  // process the last entry , ugly hack.... but works
  mapBuffer(1)=prevStartConfSerial;
  mapBuffer(2)=conformerSerial;
  rotamerSerialRanges[key] = mapBuffer;
  //std::cout << rotamerSerialRanges[key](1) << " " << rotamerSerialRanges[key](2) << "eof" << key << std::endl;
}

