// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef INCLUDED_ConformerLibHandler_H
#define INCLUDED_ConformerLibHandler_H

// ObjexxFCL headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/FArray2Da.hh>

// C++ headers
#include <map>

class RotamerSet;

class ConformerLibHandler {

  private:

  FArray4D_float libraryStorage;
  FArray2D_int conformer_aav;
  std::map<std::string, FArray1D_int> rotamerSerialRanges;
  FArray2D_float probabilityForEachRotamerSerial;

  FArray2D_float scaleArray; // for storing lib scale factors for all 20 amino acids
  void readScale(std::string scaleFileName); // init scaleArray from file

  inline int round(double value)
    { return int(value+0.5); }

  public:

  std::string conformerKeyFromCoord(int seqpos, int aa);
  bool isConformerKeyValid(std::string key);

  void readLib();
  void readBDALib(std::string scaleFileName);

  inline FArray2Dp_float getSliceWithSerialNumber(int serialnum, int aan)
    { return libraryStorage.a(1,1,serialnum,aan); }

  friend class RotamerSet;

};

#endif //INCLUDE_ConformerLibHandler_H
