// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef DEFINED_DEBUGGING_ANNEALER_HEADER
#define DEFINED_DEBUGGING_ANNEALER_HEADER

#include "RotamerAssigningAnnealer.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

namespace pack
{

class DebuggingAnnealer : public RotamerAssigningAnnealer
{
 public:
	DebuggingAnnealer(
		std::vector<int> & rot_to_pack,
		FArray1D_int & bestrotamer_at_seqpos,
		float & bestenergy,
		bool start_with_current, // start simulation with current rotamers
		InteractionGraphBase * ig,
		const RotamerSet * p_rotamer_set,
		FArray1DB_int & current_rot_index,
		bool calc_rot_freq,
		FArray1D_float & rot_freq
	);

	DebuggingAnnealer(
		FArray1D_int & bestrotamer_at_seqpos,
		float & bestenergy,
		bool start_with_current, // start simulation with current rotamers
		InteractionGraphBase * ig,
		const RotamerSet * p_rotamer_set,
		FArray1DB_int & current_rot_index,
		bool calc_rot_freq,
		FArray1D_float & rot_freq
	);

	virtual ~DebuggingAnnealer();
	void run();

 private:
	InteractionGraphBase* ig_;
	DebuggingAnnealer(const DebuggingAnnealer& rhs);
};

}
#endif
