// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef DIRECTED_SIMULATED_ANNEALER_H
#define DIRECTED_SIMULATED_ANNEALER_H

#include <vector>
#include <string>

// Rosetta Headers
#include "SimAnnealerBase.h"
#include "InteractionGraphFWD.h"

#include <ObjexxFCL/FArray2Da.hh>

// forward declaration
class RotamerSet;

namespace pack{

  namespace directed_design {

    using namespace std;

    // ____________________ Entry ____________________

    class Entry {
    public:
      typedef enum { WEIGHT, RESIDUE, RESPAIR, UNDEF } Type;

      Type type; // the type of this entry
      float w; // the weight for this entry
      int a,b; // the residue(s) for this entry

      Entry() : type(UNDEF) {}

    }; // class Entry

    istream& operator>>(istream& in, Entry& e);
    ostream& operator<<(ostream& out, const Entry& e);

    // ____________________ File ____________________

    class File {
    public:
      vector<Entry> vEntries;

      File();
      File(const string& filename);

    }; // class File

    istream& operator>>(istream& in, File& e);
    ostream& operator<<(ostream& out, const File& e);

  } // namespace directed_design

  // ____________________ DirectedSimAnnealer ____________________

  class DirectedSimAnnealer : public SimAnnealerBase
  {
  public:
    DirectedSimAnnealer(std::vector<int> & rot_to_pack,
			FArray1D_int & bestrotamer_at_seqpos,
			float & bestenergy,
			bool start_with_current, // start simulation with current rotamers
			InteractionGraphBase * ig,
			const RotamerSet * p_rotamer_set,
			FArray1DB_int & current_rot_index,
			bool calc_rot_freq,
			FArray1D_float & rot_freq
			);

    DirectedSimAnnealer(FArray1D_int & bestrotamer_at_seqpos,
			float & bestenergy,
			bool start_with_current, // start simulation with current rotamers
			InteractionGraphBase * ig,
			const RotamerSet * p_rotamer_set,
			FArray1DB_int & current_rot_index,
			bool calc_rot_freq,
			FArray1D_float & rot_freq
			);

    virtual ~DirectedSimAnnealer();
    void run();
    int pick_a_rotamer( int, int);

    //void read_weight_file(const std::string& filename);
    void set_weight_file(directed_design::File& file);

  private:
    InteractionGraphBase* ig_;
    DirectedSimAnnealer(const DirectedSimAnnealer& rhs);
    std::vector<int> rot_to_pack_;

  protected:

    directed_design::File file_;
    FArray2D_float weights_;

  }; // DirectedSimAnnealer

} // namespace pack

#endif


