// -*- mode:c++;tab-width:1;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15655 $
//  $Date: 2007-06-26 10:16:38 -0700 (Tue, 26 Jun 2007) $
//  $Author: ashworth $

#ifndef INCLUDED_DNAPose
#define INCLUDED_DNAPose

#include <vector>

#include "pose.h" // required for declaring a Pose in a class def

#include "dna_classes.h"

#include "InteractionGraphFWD.h"
#include "PackerTask_fwd.h"
#include "RotamerSetFWD.h"
#include <utility/io/all.fwd.hh>

// Encapsulation of DNA interface design protocol(s), based around a DNA Pose
// still unsure whether it would be a good idea to actually derive from Pose
//class DnaPose : public pose_ns::Pose {
class DnaPose {

	private:
		pose_ns::Pose backup_pose_; // useful to keep a backup for design cycles
		std::vector< int > ref_seq_;
		std::string infile_root_;
		DnaNeighbors dna_neighbors_;
		std::list< ResInfo > interface_list_;
		bool initialized_;

		void init2();
		void configure_design_behavior( PackerTask const & task );
		void output_moltenres( utility::io::orstream & outf );

	public:
		pose_ns::Pose pose_;
		// basepairing info (usually for reference--not dynamically synched)
		// unpaired nucleotides also described here
		DnaSeqInfo dna_info_;
		// DNA-design-specific options (should read options upon creation)
		DnaOptions opt_;
		std::string outfile_root_;

		// constructor
		DnaPose() : initialized_(false) {}

		// copy constructor -- UNTESTED
		DnaPose( DnaPose const & src )
		{
			pose_ = src.pose_;
			dna_info_ = src.dna_info_;
			opt_ = src.opt_;
			interface_list_ = src.interface_list_;
			dna_neighbors_ = src.dna_neighbors_;
			ref_seq_ = src.ref_seq_;
			infile_root_ = src.infile_root_;
			outfile_root_ = src.outfile_root_;
		}

		void init();
		void init( pose_ns::Pose const & pose );

		void mutate_bases( DnaSeqInfo const & seq );

		void
		find_dna_interface(
			PackerTask & task,
			float prox_dis2,
			float arg_dis2
		);

		void
		minimize(
			bool const output_structure,
			int const run = 0
		);

		void output_pdb( int const run = 0 );

		// the following beg for derived packer classes?

		void design();

		float
		probe_dna_specificity(
			PackerTask & task,
			RotamerSet const & rotset,
			pack::InteractionGraphBase * ig,
			FArray1D_int & cri,
			FArray1D_float & ligE1b,
			DnaSeqInfo const & targetseq,
			FArray1DB_int const & sequence_ids,
			float const anchor_val
		);

		std::list< NamedFloat > const
		analyze_specificity(
			PackerTask & task,
			RotamerSet const & rotset,
			pack::InteractionGraphBase * ig,
			FArray1D_int & cri,
			FArray1D_float & ligE1b,
			std::list< DnaSeqInfo > const & seqs,
			FArray1DB_int const & sequence_ids
		);

		bool
		revert(
			PackerTask & task,
			RotamerSet const & rotset,
			pack::InteractionGraphBase * ig,
			FArray1D_int & cri,
			FArray1D_float & ligE1b,
			DnaSeqInfo const & targetdna,
			float const orig_spec
		);

		bool
		single_mutant_multistate(
			PackerTask & task,
			RotamerSet const & rotset,
			pack::InteractionGraphBase * ig,
			FArray1D_int & cri,
			FArray1D_float & ligE1b,
			DnaSeqInfo const & targetdna,
			float const ref_energy
		);

		void bb_moves();
};

#endif
