// /////////////////////////////////////////////////////////////////////////////////////
// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
// @domain_insertion.cc
//
// @brief
// Routine to create a loop using pose
//
// @detailed:
// To use this mode, enter -switch_test, -loop_end and -loop_begin followed by
// the start and end of the loop you would like created
//
// @authors: Monica Berrondo
//
// @last_modified: March 21 2006
// /////////////////////////////////////////////////////////////////////////////////////

#ifndef INCLUDED_DomainInsertionMode
#define INCLUDED_DomainInsertionMode

#include "pose_fwd.h"
#include "SplicedProtein.h"

#include "numeric/xyzVector.hh"

#include <vector>
#include <map>
#include <list>
#include <string>
#include <utility>

// main protocol functions
void
domain_insertion_main();

void
domins_centroid_main_protocol(
		pose_ns::Pose & combined_pose,
		pose_ns::Score_weight_map & weight_map,
		int const iter,
		int const cycles
		);

void
domins_insertion_flop(
		pose_ns::Pose & pose,
		int cycles,
		pose_ns::Score_weight_map & weight_map,
		pose_ns::Monte_carlo & mc
		);

void
domins_starting_position_rigid_body_move(
		pose_ns::Pose & pose,
		int iter
		);

void
domins_rigid_body_and_loop_move_protocol(
		pose_ns::Pose & pose,
		int cycles
		);
// end main protocol functions

// ------------------------------------------------------------------------------------
void
randomize_insert_domain(
		pose_ns::Pose & pose
		);

void
perturb_insert_domain(
		pose_ns::Pose & pose
		);

void
domins_close_gap(
		pose_ns::Pose & pose
		);

void
domins_build_loops(
		pose_ns::Pose & pose,
		int iter
		);
// end randomizing and initial position functions

// ------------------------------------------------------------------------------------

// set up functions
void
domins_generate_start(
	//	pose_ns::Pose & pose
		std::vector <int> & sizes,
		std::vector <int> & new_start,
		std::vector <int> & start,
		std::map <std::string, int> & ip
		);

void
domins_fill_sizes(
		bool & circular,
		std::map<std::string,int> & ip
		);

void
domins_initial_setup(
		pose_ns::Pose & pose
		);

void
domins_input_map(
		std::vector <int> sizes,
		std::vector <int> new_start,
		std::vector <int> start,
		std::map<std::string,int> & ip
		);

void
domins_setup_map( );

void
create_insertion_map(
		std::vector <int> sizes,
		std::vector <int> new_start,
		std::vector <int> start,
		pose_ns::Pose const & host_protein,
		pose_ns::Pose const & insert_protein
		);

void
initialize_struct(
		);

void
domins_create_fold_tree(
		pose_ns::Pose & pose,
		bool const centroid,
		int const type
		);

void
domins_set_info(
		int & last_repeated,
		int & overlap
		);

void
domins_initialize_pose(
		);

void
domins_get_parameters(
				std::map<std::string, std::string> & params,
				std::string filename
);
// end set up functions

// ------------------------------------------------------------------------------------

// generate a pose with a combination of the insertion and host domain and store in new pose
void
copy_combined_pose(
		std::vector <int> sizes,
		std::vector <int> new_start,
		std::vector <int> start,
		pose_ns::Pose const & host_protein,
		pose_ns::Pose const & insert_protein,
		pose_ns::Pose & return_protein
		);

// get and store the start and native poses if it exists
void
domins_native(
		pose_ns::Pose & native_pose
		);

void
domins_start(
		pose_ns::Pose & start_pose
		);

void
domins_fasta_start(
		pose_ns::Pose & start_pose
		);
// ------------------------------------------------------------------------------------

// rms and distance functions
int
find_min_loop_length(std::vector <double> average_dist);

float
domins_calc_ins_rms(
		pose_ns::Pose const & pose
		);

float
domins_calc_rb_rms(
		pose_ns::Pose const & pose
		);

float
domins_calc_loop_rms(
		pose_ns::Pose const & pose,
		int const & loop
		);

float
domins_calc_rms(
		pose_ns::Pose const & pose
		);

numeric::xyzVector <double>
domins_calc_midpoint(
		pose_ns::Pose const & pose,
		int const start,
		int const stop
		);
// end rms and distance functions

// ------------------------------------------------------------------------------------

// internal options and modes
void
domins_get_mode(
		bool & fullatom,
		int & iter,
		int & cycles
		);

numeric::xyzVector <double>
get_loop_com(
		pose_ns::Pose & pose
		);

void
check_random_distribution(
		pose_ns::Pose & pose
		);

// ------------------------------------------------------------------------------------
#endif
