// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 6875 $
//  $Date: 2005-10-23 14:29:10 -0700 (Sun, 23 Oct 2005) $
//  $Author: mentzer $
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2005 University of Washington
// (C) 199x-2005 University of California Santa Cruz
// (C) 199x-2005 University of California San Francisco
// (C) 199x-2005 Johns Hopkins University
// (C) 199x-2005 University of North Carolina, Chapel Hill
// (C) 199x-2005 Vanderbilt University

/// @file   rosetta/Dunbrack4D.cc
///
/// @brief  dun_chi and dun_sd array wrapper supporting variable numbers of chi angles
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


// Rosetta Headers
#include "Dunbrack4D.h"


namespace dunbrack_pack {


	/// @brief Uninitialized key value
	Dunbrack4D::ushort const Dunbrack4D::npos =
	 static_cast< Dunbrack4D::ushort >( -1 );

	/// @brief Mask to select the 14 bits of the index (and max index value + 1)
	Dunbrack4D::ushort const Dunbrack4D::index_mask =
	 static_cast< Dunbrack4D::ushort >( 16383 ); // 2^0 + ... + 2^13

	/// @brief Mask to select the 2 bits of the nchi value
	Dunbrack4D::ushort const Dunbrack4D::nchi_mask =
	 static_cast< Dunbrack4D::ushort >( 49152 ); // 2^14 + 2^15

	/// @brief Shift to extract the nchi value
	Dunbrack4D::ushort const Dunbrack4D::nchi_shift =
	 static_cast< Dunbrack4D::ushort >( 14 );


} // namespace dunbrack_pack
