// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision:
//  $Date:
//  $Author:

#ifndef INCLUDED_Flag_h
#define INCLUDED_Flag_h

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//		Kosta Makrodimitris,Ph.D. (KMa) 2006-02
//
//###############################################
/*
Flag class is a general purpose class
It could be used for other flags in Rosetta
and it's no need for someone to rewrite
it again eg for -surface
public:
Flag flag;
and
in options.cc you initialize with
if ( truefalseoption("surface") ) surface::mode.flag.enable();
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include <string>

class Flag
{
private:

	Flag(const Flag & F);
	Flag & operator=(const Flag & F);


public:							// Constructors

	Flag( std::string const & name )
		: enabled_(false)
		, name_(name)
	{}


	~Flag()
	{}


	void enable();

	bool is_enabled();


private:

	bool enabled_;
	std::string name_;

}; // class Mode

#endif // INCLUDE_Flag

