// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_HotspotRotamer
#define INCLUDED_HotspotRotamer

//Rosetta headers
#include "Rotamer.h"
#include "DesignMap.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray2Da.hh>

// C++ Headers
#include <iosfwd>
#include <list>
#include <string>
#include <vector>

// forward declarations
//class DesignMap;
class PackerTask;
class RotamerSet;
//class packingPackage;
namespace pack { class InteractionGraphBase; }
namespace pose_ns { class Pose; }



// jk This lightweight class is effectively just a struct containing all the info required for repacking
// jk Note: it's a class just so that handling of pointers is a little safer...
class packingPackage {

public:

	pack::InteractionGraphBase * ig;
	RotamerSet * rotamer_set;
	PackerTask * Task;
	FArray1D_int current_rot_index;
	FArray2D_short neighbor_indexno;
	FArray1D_bool allowed_rotamers;
	FArray1D_bool seqpos_with_fixed_rotamers;

	packingPackage();
	~packingPackage();
	void reset();
	void reset_IG_only();

};


// jk This lightweight class is just used to fix/unfix rotamers,
// so that scope will determine when the "unfix" is called (for safety)
class rotamerFix {

private:

	DesignMap starting_design_map;
	int fix_seqpos_;
	packingPackage * packing_package_;

public:

	rotamerFix( int const fix_seqpos, packingPackage * packing_package );
	~rotamerFix();

	// Prevent compiler from generating these
	rotamerFix();
	rotamerFix( rotamerFix & );
	rotamerFix & operator =( rotamerFix const & src );

};


// jk Class definition for HotspotHbond
class HotspotHbond
{

private:

	bool Hbond_found;  // true once member data has been filled in
	bool hs_acceptor;  // true if the hotspot is the acceptor, false otherwise

	int don_seqpos;
	int don_Hbond_atm;
	int don_Hbond_base;

	int acc_seqpos;
	int acc_Hbond_atm;
	int acc_Hbond_base;

public:

	inline HotspotHbond() { Hbond_found = false; };

	inline void set_all( int const in_don_seqpos, int const in_don_Hbond_atm,
											 int const in_don_Hbond_base, int const in_acc_seqpos,
											 int const in_acc_Hbond_atm, int const in_acc_Hbond_base,
											 bool const in_hs_acceptor ) {
		don_seqpos = in_don_seqpos; don_Hbond_atm = in_don_Hbond_atm;
		don_Hbond_base = in_don_Hbond_base; acc_seqpos = in_acc_seqpos;
		acc_Hbond_atm = in_acc_Hbond_atm; acc_Hbond_base = in_acc_Hbond_base;
		hs_acceptor = in_hs_acceptor; Hbond_found = true;
	};

	void apply_atom_tree( pose_ns::Pose & pose, bool const use_atom_tree );

	inline bool backbone() const { if ((don_Hbond_base == 1) || (acc_Hbond_base == 3)) return true; return false; };

	inline int partner_seqpos() const { if ( hs_acceptor ) return don_seqpos; return acc_seqpos; };

};



// jk Class definition for HotspotRotamer (derives from Rotamer)

class HotspotRotamer : public Rotamer {

	friend void loop_over_second_Hbond( const void * in_dc, int const second_Hbond_num, int const unused_j, int const unused_k );

private:

	HotspotHbond hsr_Hbond;
	int partner_seqpos_;
	int stack_seqpos_;

	bool test_hotspot_HB_ene(
    int const fixedres, int const fixedaa,
		int const fixedaav, FArray2Da_float fixedxyz,
		float const hb_ene_threshold,
		bool const disallow_backbone,
		bool const disallow_sidechain
  );

	std::string get_outpdb_fname( std::string const tag ) const;

	bool hr_bump_check( pose_ns::Pose const & pose,
		bool const self, bool const interface, float const hr_bump_thres );

	bool test_for_hotspot_burial( pose_ns::Pose const & pose );

	bool find_self_Hbond( pose_ns::Pose const & pose );

	bool find_interface_Hbond( pose_ns::Pose const & pose, bool const use_strict_criteria );

	bool find_interface_stack( pose_ns::Pose const & pose, bool const use_strict_criteria, bool const silent_mode = true );

	int find_best_available_AspAsn( pose_ns::Pose const & pose ) const;

	void hsr_minimize(
  	pose_ns::Pose & curr_pose,
		PackerTask const & Task,
		bool const flexible_chi,
		bool const flexible_backbone
  );

	void redesign(
	  bool const design_hotspot_environment,
		bool const design_periphery,
		bool const update_packingPackage,
	  pose_ns::Pose & curr_pose,
		packingPackage & packing_package
  );

	void fix_hotspot_contacts(
	  pose_ns::Pose const & pose,
		PackerTask & Task
  );

	void restrict_rotamer_list_to_hotspot_contacts(
		FArray1D_bool & allowed_rotamers,
    RotamerSet & interface_rotamer_set,
		FArray1D_int & current_rot_index,
		FArray1D_int & resid_2_moltenres,
		FArray2DB_int & first_rot_for_aa,
		const DesignMap & design_map
  );

	float loop_over_second_Hbond(
    int const second_Hbond_num,
	  pose_ns::Pose & pre_second_Hbond_pose,
		RotamerSet const & second_Hbond_rotamer_set,
		packingPackage & packing_package
	);

	float loop_over_AR_modules(
	  pose_ns::Pose & in_pose,
		packingPackage & hsr_surrounding_packing_package
	);

	float design_around_hotspot(
	  pose_ns::Pose & in_pose,
		bool const update_packingPackage,
		packingPackage & hsr_surrounding_packing_package
	);

	void setup_packingPackage(
		bool const design_hotspot_environment,
		bool const design_periphery,
  	pose_ns::Pose & curr_pose,
		packingPackage & interface_packing_package
  );

	void find_second_Hbond(
    pose_ns::Pose const & pose,
    RotamerSet & second_Hbond_rotamer_set,
		const FArray1D_bool & valid_partner_positions,
		const PackerTask & Task
  );


public:

	HotspotRotamer(	int const in_aa, int const in_aav, int const in_seqpos,
    FArray1Da_float in_rchi, FArray2Da_float in_rotcoord,
    FArray1Da_float in_rotactcoord );

	HotspotRotamer(	int const in_aa, int const in_aav, int const in_seqpos,
    FArray1Da_float in_rchi );

	inline int stack_seqpos( pose_ns::Pose const & pose ) {
		find_interface_stack( pose, false, true ); return stack_seqpos_;
	};

	void explode( std::list < HotspotRotamer > & exploded_rotamers );

	bool valid_self_OneBody( pose_ns::Pose const & pose, bool const silent_mode = true );

	bool valid_interface_OneBody( pose_ns::Pose const & pose, bool const use_strict_criteria, bool const silent_mode = true );

	void incorporate_hotspot(
	  pose_ns::Pose const & start_pose,
  	packingPackage & hsr_surrounding_packing_package
  );

	void write_outpdb( pose_ns::Pose const & pose, std::string const tag ) const;

};


////// Supporting functions //////

void transform_rotamers_for_new_binding_mode(
	pose_ns::Pose & curr_pose,
	packingPackage & packing_package
);

void rebuild_rotamers_at_seqpos(
  int const seqpos,
	pose_ns::Pose & curr_pose,
	packingPackage & packing_package
);

void keep_rotamer_from_pose(
  int const seqpos,
	pose_ns::Pose & curr_pose,
	packingPackage & packing_package
);

void keep_rotamer_from_pose(
  int const seqpos,
	pose_ns::Pose & curr_pose,
	int const rot_to_replace,
	packingPackage & packing_package
);

void update_all_1body(
	packingPackage & packing_package
);


void explode_for_second_Hbond(
  pose_ns::Pose const & pose,
	RotamerSet & second_Hbond_rotamer_set,
	int const rot_aa,
	int const rot_seqpos,
	int const natro_seqpos,
	const PackerTask & Task,
	bool const do_self_bump_check = true,
	bool const do_interface_bump_check = true
);

void reweight_interface_energies(
	PackerTask & Task,
	const pose_ns::Pose & curr_pose,
  float const interface_weight_factor
);

void reweight_hotspot_energies(
	PackerTask & Task,
	const pose_ns::Pose & curr_pose,
	int const hsr_seqpos,
  float const hotspot_weight_factor
);

bool valid_hotspot_neighbor_aa( int const aa );

bool valid_periphery_aa( int const aa );

int count_interface_neighbors( pose_ns::Pose const & pose, int const seqpos );


#endif
