// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_HotspotRotamerList
#define INCLUDED_HotspotRotamerList

// Rosetta Headers
#include <HotspotRotamer.h>

// C++ Headers
#include <iosfwd>
#include <list>
#include <vector>
#include <string>
#include <iostream>

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.io.hh>

// forward declarations
class DesignMap;


// jk Class definition for position_hotspot_rotamer_list
class position_hotspot_rotamer_list
{

private:

	int resnum;
	std::list < HotspotRotamer > rotamer_list;

public:

	inline int num_rot() { return rotamer_list.size(); };

	inline int get_resnum() { return resnum; };

	inline void set_resnum( int const new_resnum ) { resnum = new_resnum; };

	inline void add_rotamer( HotspotRotamer new_rot ) { rotamer_list.push_back(new_rot); };

	void setup_position_rotamers( int const aa, int const aav, DesignMap & design_map );

	void redesign_around_rotamer_list( DesignMap & design_map );

	void screen_across_rotamer_list( DesignMap & design_map );

};


// Supporting functions

std::string get_checkpoint_fname();

void remove_checkpoint_file();

void read_checkpoint_file( int & last_completed_seqpos, int & last_completed_rotnum );

void write_checkpoint_file( int const last_completed_seqpos, int const last_completed_rotnum );

#endif
