// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef InteractionGraphSupport_H
#define InteractionGraphSupport_H

//Rosetta Headers
#include "InteractionGraphFWD.h"
#include "RotamerSetFWD.h"
#include "PackerTask_fwd.h"

//ObjexxFCL
#include <ObjexxFCL/ObjexxFCL.Project.hh>


namespace pack {

extern bool dynamically_decide_between_lazy_and_precomputed;
extern bool tight_memory_restrictions;
extern bool lazy_ig;
extern bool linmem_ig;
extern bool minimalist_ig;
extern bool use_sasa_pack_score;
extern bool output_dot_kinemage;
extern int megs_for_rpes_limit;


InteractionGraphBase *
get_interaction_graph(
	RotamerSet & rotamer_set,
	PackerTask const & task,
	FArray2DB_short & neighbor_indexno
);

PDInteractionGraph *
create_and_initialize_PDInteractionGraph(
	RotamerSet & rotamer_set
);

SparseSASAInteractionGraph *
create_and_initialize_SASAInteractionGraph(
	RotamerSet & rotamer_set,
	PackerTask const & task
);

LazyInteractionGraph*
create_and_initialize_LazyInteractionGraph(
	RotamerSet & rotamer_set
);

MinimalistInteractionGraph*
create_and_initialize_MinimalistInteractionGraph(
	RotamerSet & rotamer_set
);

LinearMemoryInteractionGraph*
create_and_initialize_LinearMemoryInteractionGraph(
	RotamerSet & rotamer_set
);

LazySASAInteractionGraph*
create_and_initialize_LazySASAInteractionGraph(
	RotamerSet & rotamer_set,
	PackerTask const & task
);

MinimalistSASAInteractionGraph*
create_and_initialize_MinimalistSASAInteractionGraph(
	RotamerSet & rotamer_set,
	PackerTask const & task
);

LinMemSASAInteractionGraph*
create_and_initialize_LinearMemorySASAInteractionGraph(
	RotamerSet & rotamer_set,
	PackerTask const & task
);


void
initialize_interaction_graph(
	PrecomputedPairEnergiesInteractionGraph * ig,
	RotamerSet & rotamer_set
);

void
initialize_sasa_graph(
	SASAGraph * ig,
	RotamerSet & rotamer_set,
	const DesignMap & design_map
);

void
initialize_on_the_fly_interaction_graph
(
	OnTheFlyInteractionGraph * ig,
	RotamerSet & rotamer_set
);


bool
on_the_fly_graph_compatible_with_task();

bool
predict_precomputed_graph_exceeds_memory_restriction(
	RotamerSet & rotamer_set,
	FArray2DB_short & neighbor_indexno
);

bool
predict_lazy_faster_than_precomputed(
	RotamerSet & rotamer_set,
	FArray2DB_short & neighbor_indexno
);

unsigned int
predict_num_rotamer_pairs(
	RotamerSet & rotamer_set,
	FArray2DB_short & neighbor_indexno
);

//void
//writeDotsForRotamerAssignment(
//	PrecomputedPairEnergiesInteractionGraph * ig,
//	DesignMap & designmap,
//	RotamerSet const & rotamer_set,
//	FArray1DB_int & rotamer_assignment,
//	int run
//);

//void
//write_output_dot_kinemage(
//	SASAInteractionGraph * sig,
//	int run
//);

} //namespace pack
#endif //InteractionGraphSupport_H

