// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.11 $
//  $Date: 2006/10/20 13:14:14 $
//  $Author: plato $

#ifndef LAZY_INTERACTION_GRAPH_H
#define LAZY_INTERACTION_GRAPH_H

#include "AminoAcidNeighborSparseMatrix.h"
#include "OnTheFlyInteractionGraph.h"

#include <ObjexxFCL/FArray3D.hh>

//Lazy interaction graph uses as much memory as a PDInteractionGraph, but it evaulates
//rotamer pair energies only as it needs them and stores them for later, instead
//of requiring an extensive precomputation phase.

namespace pack
{

class LazyNode;
class LazyEdge;
class LazyInteractionGraph;

class LazyNode : public OnTheFlyNode
{
public:
	LazyNode(
		InteractionGraphBase * owner,
		int node_id,
		int num_states
	);

	virtual ~LazyNode();

	//virtual methods inherited from NodeBase
	virtual void prepare_for_simulated_annealing();
	virtual void print() const;
	virtual bool state_unassigned() const { return current_state_ == 0;}
	virtual float get_totalE() const { return curr_state_total_energy_;}

	void assign_zero_state();
	void assign_state(int new_state);
	void partial_assign_state( int new_state );
	void complete_state_assignment();

	inline
	int get_current_state() const { return current_state_; }

	inline
	float get_one_body_energy_current_state() const
	{ return curr_state_one_body_energy_; }

	inline
	float project_deltaE_for_substitution
	(
		int alternate_state,
		float & prev_node_energy
	);

	void commit_considered_substitution();
	float compute_pair_energy_for_current_state( int edge_making_energy_request );

	inline
	void acknowledge_neighbors_state_substitution(
		int edge_to_altered_neighbor,
		float new_edge_energy,
		int other_node_new_state,
		SparseMatrixIndex const & other_node_new_state_sparse_info
	);

	void
	acknowledge_neighbors_partial_state_substitution(
		int edge_to_altered_neighbor,
		int other_node_new_,
		SparseMatrixIndex const & other_node_new_state_sparse_info
	);

	inline
	SparseMatrixIndex const &
	get_sparse_mat_info_for_curr_state() const;

	void print_internal_energies();

	void update_internal_energy_sums();

	static int num_rpe_calcs;
	static int num_procrastinated_committed;

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:

	inline
	rotamer_trie const &
	get_current_rotamer()
	{
		return get_rotamer( current_state_ );
	}

	inline
	float &
	get_curr_rotamer_actcoords();

	//Hooks for SASANode< V, E, G > class
	float get_curr_pd_energy_total() const { return curr_state_total_energy_;}
	float get_alt_pd_energy_total() const { return alternate_state_total_energy_;}
	void set_alternate_state( int alt ) { alternate_state_ = alt; }
	int get_alternate_state() const { return alternate_state_; }
	void calc_deltaEpd( int alternate_state );
	bool considering_alternate_state() const
	{
		return alternate_state_is_being_considered_;
	}


private:

	//void
	//set_alt_aa_offsets_from_edge(int edge_index, FArray2D_int const & offsets);

	/*
	float
	compute_rotamer_pair_energy(
		int edge_making_energy_request,
		int state_this,
		int state_other,
		int aa_this,
		int aa_other,
		rotamer_trie const & this_rotamer,
		rotamer_trie const & other_rotamer,
		FArray1Da_float & this_rotamer_actcoords,
		FArray1Da_float & other_rotamer_actcoords
	);
	*/

	void update_internal_vectors();

	inline
	LazyEdge* get_incident_lazy_edge( int index ) const
	{
		return ( LazyEdge* ) get_incident_edge( index );  // c-style cast since static_cast won't compile
	}

	inline
	LazyNode* get_adjacent_lazy_node( int index ) const
	{
		return ( LazyNode* ) get_adjacent_node( index );  // c-style cast since static_cast won't compile
	}

	inline
	LazyInteractionGraph* get_lazy_ig_owner() const
	{
		return ( LazyInteractionGraph* ) get_owner(); // c-style cast since static_cast won't compile
	}

	FArray3D_int aa_offsets_for_edges_;
	FArray2D_int num_states_for_aa_type_for_higher_indexed_neighbor_;
	std::vector< FArray1Da_float > edge_matrix_ptrs_;
	std::vector< int > neighbors_curr_state_;
	std::vector< SparseMatrixIndex > neighbors_curr_state_sparse_info_;

	int current_state_;
	SparseMatrixIndex curr_state_sparse_mat_info_;
	float curr_state_one_body_energy_;
	float curr_state_total_energy_;
	std::vector< float > curr_state_two_body_energies_;

	int alternate_state_;
	SparseMatrixIndex alt_state_sparse_mat_info_;
	float alternate_state_one_body_energy_;
	float alternate_state_total_energy_;
	std::vector< float > alternate_state_two_body_energies_;

	bool alternate_state_is_being_considered_;
	bool procrastinated_;

	//no default constructor, uncopyable
	LazyNode();
	LazyNode( LazyNode const & );
	LazyNode & operator = ( LazyNode const & );

};

class LazyEdge : public OnTheFlyEdge
{
public:
	LazyEdge(
		InteractionGraphBase* owner,
		int first_node_ind,
		int second_node_ind
	);

	virtual ~LazyEdge();

	virtual
	void
	set_sparse_aa_info(
		FArray2DB_bool const &
	);

	//virtual methods inherited from EdgeBase
	virtual void declare_energies_final();
	virtual void prepare_for_simulated_annealing();

	float get_current_two_body_energy() const;

	virtual void wipe_edge();

	void acknowledge_state_change(
		int node_ind,
		int new_state,
		SparseMatrixIndex const & new_state_sparse_info,
		float & new_energy
	);
	void acknowledge_state_zeroed( int node_ind );

	void acknowledge_partial_state_change(
		int node_ind,
		int new_state,
		SparseMatrixIndex const & new_state_sparse_info
	);
	float get_energy_following_partial_state_assignment();

	static
	inline
	float get_alternate_state_energy_first_node(
		int first_node_alt_state,
		int second_node_orig_state,
		SparseMatrixIndex const & second_node_orig_state_sparse_info,
		int first_node_state_offset_minus_1,
		int second_node_curr_num_states_per_aatype,
		int aa_neighbor_offset,
		FArray1DB_float & edge_energy_table
	);

	static
	inline
	float get_alternate_state_energy_second_node(
		int first_node_orig_state,
		int second_node_alt_state,
		SparseMatrixIndex const & first_node_orig_state_sparse_info,
		SparseMatrixIndex const & second_node_alternate_state_sparse_info,
		int second_node_alt_state_num_states_per_aatype,
		int aa_neighbor_offset,
		FArray1DB_float & edge_energy_table
	);

	static
	inline
	void store_interaction_energy_first_node(
		//int first_node_alt_state,
		//int second_node_orig_state,
		SparseMatrixIndex const & second_node_orig_state_sparse_info,
		int first_node_state_offset_minus_1,
		int second_node_curr_num_states_per_aatype,
		int aa_neighbor_offset,
		FArray1DB_float & edge_energy_table,
		float interaction_energy
	);


	static
	inline
	void store_interaction_energy_second_node(
		//int first_node_orig_state,
		//int second_node_alt_state,
		SparseMatrixIndex const & first_node_orig_state_sparse_info,
		SparseMatrixIndex const & second_node_alternate_state_sparse_info,
		int second_node_alt_state_num_states_per_aatype,
		int aa_neighbor_offset,
		FArray1DB_float & edge_energy_table,
		float interaction_energy
	);

	inline
	void acknowledge_substitution(
		int substituted_node_index,
		float const curr_state_energy,
		int nodes_new_state,
		SparseMatrixIndex const & nodes_new_state_sparse_info
	);

	float & get_edge_table_ptr();
	int get_two_body_table_size() const;

	void print_current_energy() const;

	bool build_sc_only_rotamer() { return true;}

	FArray2D_int const & get_offsets_for_aatypes( );
	FArray1D_int const & get_second_node_num_states_per_aa();

	static float const NOT_YET_COMPUTED_ENERGY; //an energy lower than any RPE could ever be

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:

	//Hooks for SASAEdge< V, E, G > class
	void declare_energies_final_no_deletion() { LazyEdge::prepare_for_simulated_annealing(); }
	void prepare_for_simulated_annealing_no_deletion() { LazyEdge::prepare_for_simulated_annealing(); }
	bool pd_edge_table_all_zeros() const { return false;}

private:
	void get_energy_for_state_pair(
		int nodes_states[ 2 ],
		SparseMatrixIndex sparse_matrix_indices[ 2 ]
	);

	inline
	LazyNode* get_lazy_node( int index ) const
	{
		return (LazyNode*) get_node( index ); //c-style cast since static_cast won't compile
	}

	inline
	LazyInteractionGraph* get_lazy_ig_owner() const
	{
		return (LazyInteractionGraph*) get_owner(); //c-style cast since static_cast won't compile
	}

	void
	wipe_two_body_energies_for_node_state( int node, int state );

	AminoAcidNeighborSparseMatrix< float > two_body_energies_;
	float curr_state_energy_;
	bool partial_state_assignment_;
	bool ran_annealing_since_pair_energy_table_cleared_;

	//no default constructor, uncopyable
	LazyEdge();
	LazyEdge( LazyEdge const & );
	LazyEdge & operator = ( LazyEdge const & );

};

class LazyInteractionGraph : public OnTheFlyInteractionGraph
{
public:
	LazyInteractionGraph( int numNodes );
	virtual ~LazyInteractionGraph();

	//virtual methods inherited from InteractionGraphBase
	virtual void  blanket_assign_state_0();
	virtual float set_state_for_node(int node_ind, int new_state);
	virtual float set_network_state( FArray1DB_int & node_states);
	virtual void consider_substitution(
		int node_ind,
		int new_state,
		float & delta_energy,
		float & prev_energy_for_node
	);
	virtual float  commit_considered_substitution();
	virtual float get_energy_current_state_assignment();
	virtual int get_edge_memory_usage() const;
	virtual void print_current_state_assignment() const;
	virtual void set_errorfull_deltaE_threshold( float deltaE );
	virtual float get_energy_sum_for_vertex_group( int group_id );

	// jk Clear stored energies for a particular pair of nodes
	virtual void reset_node_pair( int const node1, int const node2 );

	bool build_sc_only_rotamer() const;

	virtual unsigned int count_static_memory() const;
	virtual unsigned int count_dynamic_memory() const;

protected:

	virtual NodeBase* create_new_node( int node_index, int num_states);
	virtual EdgeBase* create_new_edge( int index1, int index2);

	//Hooks for SASAInterationGraph< V, E, G >
	float get_energy_PD_current_state_assignment();
	void update_internal_energy_totals();

	inline
	LazyNode* get_lazy_node(int index) const
	{
		return (LazyNode*) get_node( index ); //c-style cast since static_cast won't compile
	}

private:
	int num_aa_types_;
	int num_commits_since_last_update_;
	float total_energy_current_state_assignment_;
	float total_energy_alternate_state_assignment_;
	int node_considering_alt_state_;

	static const int COMMIT_LIMIT_BETWEEN_UPDATES = 1024; // 2^10

	//no default constructor, uncopyable
	LazyInteractionGraph();
	LazyInteractionGraph( LazyInteractionGraph const & );
	LazyInteractionGraph & operator = ( LazyInteractionGraph const & );

};

} //end namespace pack

#endif


