// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef LIGANDATOMPAIRENERGY_H_
#define LIGANDATOMPAIRENERGY_H_

////////////////////////////////////////////////////////////////////////////////
////////////////////
// LigandAtomPairEnergy Class
//
// Project: Rosetta
//
// Language: C++
//
// Author: Kristian Kaufmann, Vanderbilt University
////////////////////////////////////////////////////////////////////////////////
////////////////////


// Rosetta Headers
#include "atom.h"
#include "atom_chem.h"
#include "fast_pairenergy.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

// C++ Headers
#include <utility>


// Using


// Forward


////////////////////////////////////////////////////////////////////////////////
// LigandAtomPairEnergy: Class for handling pair energy calculation for Ligand
////////////////////////////////////////////////////////////////////////////////
class LigandAtomPairEnergy
{


private: // Types //////////////////////////////////////////////////////////////
////////////////////


public: // Types ///////////////////////////////////////////////////////////////
////////////////////


public: // Creation /////////////////////////////////////////////////////////
////////////////////


        //======================================================================
        // Default Constructor
        //======================================================================
        LigandAtomPairEnergy( Atom * atom1, Atom * atom2)
        {
        	atom_pair_.first=atom1;
        	atom_pair_.second=atom2;
        	distance_=-9.0;
        	atom_1_state_=atom_2_state_=9999;
        	get_energies(repE_,atrE_,solE_);
        }


public: // Creation ///////////////////////////////////////////////////////////


        //======================================================================
        // Copy Constructor
        //======================================================================
        LigandAtomPairEnergy( const LigandAtomPairEnergy & p)
        {
          atom_pair_=p.atom_pair_;
          atom_1_state_=p.atom_1_state_;
          atom_2_state_=p.atom_2_state_;
          distance_=p.distance_;
          repE_=p.repE_;
          atrE_=p.atrE_;
          solE_=p.solE_;

        };


public: // Creation ////////////////////////////////////////////////////////////
        //======================================================================
        // Destructor
        //======================================================================
        virtual
        ~LigandAtomPairEnergy()
        {}


public: // Assignment /////////////////////////////////////////////////////////

        //======================================================================
        // Copy Assignment
        //======================================================================
        LigandAtomPairEnergy &
        operator=( LigandAtomPairEnergy const & p){
						if (this != &p){
							atom_pair_=p.atom_pair_;
          		atom_1_state_=p.atom_1_state_;
          		atom_2_state_=p.atom_2_state_;
          		distance_=p.distance_;
          		repE_=p.repE_;
          		atrE_=p.atrE_;
          		solE_=p.solE_;
						return *this;
					}
					else{
						std::cerr << "LigandAtomEnergy object to itself!!" << std::endl;
						return *this;
					}
        }

protected: // Assignment ///////////////////////////////////////////////////////



public: // Inspectors //////////////////////////////////////////////////////////

inline
void
get_energies(
	float & repulE,
	float & attracE,
	float & solvatE
){
	if(atom_pair_.first->get_state()==atom_1_state_ &&
			atom_pair_.second->get_state()==atom_2_state_){
		//atoms haven't changed return stored values.
		repulE=repE_;
		attracE=atrE_;
		solvatE=solE_;
		return;
	}else if( distance_ == distance(atom_pair_.first->get_coordinates(),
									atom_pair_.second->get_coordinates())){
		//atoms haven't changed relative postions return stored values and update
		// state member variables.
		repulE=repE_;
		attracE=atrE_;
		solvatE=solE_;
		atom_1_state_=atom_pair_.first->get_state();
		atom_2_state_=atom_pair_.second->get_state();
		return;
	}else{
		// atoms have changed. update everything
		repE_=0.0;
		atrE_=0.0;
		solE_=0.0;
		float const cp_weight=1.0;//borrowed from ligand.cc get_sc_haE
		atom_1_state_=atom_pair_.first->get_state();
		atom_2_state_=atom_pair_.second->get_state();
		FArray1D_float atom_1_coord(3),atom_2_coord(3);
		for ( int k=1; k<= 3; ++k ) {
			atom_1_coord(k) = atom_pair_.first->get_coordinates()(k);
			atom_2_coord(k) = atom_pair_.second->get_coordinates()(k);
		}
		fast_pairenergy(atom_1_coord(1),atom_2_coord(1),
				atom_pair_.first->get_ros_atom_type(),
				atom_pair_.second->get_ros_atom_type(),solE_,atrE_,repE_,distance_,cp_weight
			);
		//fast_pairenergy calculates solE, atrE, repE, and distance
		repulE=repE_;
		attracE=atrE_;
		solvatE=solE_;
		return;
	}
}

public: // Modifiers //////////////////////////////////////////////////////////

protected: // Functions ///////////////////////////////////////////////////////


private: // Data ///////////////////////////////////////////////////////////////
	std::pair<Atom * , Atom * > atom_pair_; // non-owning pointers
	size_t atom_1_state_;// state of atom_1 at last update
	size_t atom_2_state_;// state of atom_2 at last update
	float distance_;// distance between between pai at last update
	float repE_;// van der Waals repulsion Energy of last update
	float atrE_;// van der Waals attraction Energy of last update
	float solE_;// solvation Energy



}; // Class LigandAtomPairEnergy
////////////////////////////////////////////////////////////////////////////////

#endif /*LIGANDATOMPAIRENERGY_H_*/
