// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef NEGATIVE_DESIGN_H
#define NEGATIVE_DESIGN_H

// Rosetta Headers
#include "ParallelSimAnneal.h"

// forward declaration
class RotamerSet;

namespace pack{

  class ParallelSimAnneal;

  class NegativeDesign :  public ParallelSimAnneal
    {
    public:
      NegativeDesign(
			      const RotamerSet * p_rotamer_set,
			      FArray2DB_bool & neighborlist,
			      FArray1D_int & bestrotamer_at_seqpos,
			      float & bestenergy,
			      bool start_with_current, // start simulation with current rotamers
			      InteractionGraphBase * ig,
			      FArray1DB_int & current_rot_index,
			      bool calc_rot_freq,
			      FArray1D_float & rot_freq
			      );

      virtual ~NegativeDesign();
      void run();

    protected:
      int num_prot_conformations, preferred_state, reference_state;
      double reference_state_boltz_factor, previous_probability_of_preferred_state;
      void setup_vertex_groups_for_negative_design();
      void moltenres_in_given_chain( std::string const & pdb_chain_in, int & moltenres_out );
      bool evaluate_probability_of_preferred_state();
      double setup_ref_state_and_return_boltz_factor();

    private:
      NegativeDesign(const NegativeDesign& rhs);
  };

}//end of namespace

#endif
