// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

// Rosetta Headers
#include "PackerTaskResidueWeights.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray2D.hh>


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeight::PackerTaskResidueWeight
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
PackerTaskResidueWeight::PackerTaskResidueWeight() {

	aa_dependent = false;
	weight = 1.;
	return;
}


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeight::get_resres_weight
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
float PackerTaskResidueWeight::get_resres_weight( int const aa1, int const aa2 ) const {

	if ( ! aa_dependent ) return weight;
	return ( aa_dep_weights(aa1,aa2) );
}


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeight::set_resres_weight
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void PackerTaskResidueWeight::set_resres_weight( float const new_weight, int const aa1, int const aa2 ) {

	using namespace param;

	if ( ! aa_dependent ) {
		aa_dep_weights.dimension(MAX_AA(), MAX_AA(), 1.);
		aa_dependent = true;
	}
	aa_dep_weights(aa1, aa2) = new_weight;
	return;
}


///////////////////////////////////////////////////////////////
////////   END OF METHODS FOR PACKERTASKRESIDUEWEIGHT   ///////
/////   START OF METHODS FOR PACKERTASKRESIDUEWEIGHTMAP   /////
///////////////////////////////////////////////////////////////





//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeightMap::generate_map_inx
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
int PackerTaskResidueWeightMap::generate_map_inx( int const seqpos1, int const seqpos2 ) const {
	using namespace param;
	return ( ( seqpos1 * numres_) + seqpos2 );
}


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeightMap::ensure_seqpos_swap
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void PackerTaskResidueWeightMap::ensure_seqpos_swap( int & seqpos1, int & aa1,
																									 int & seqpos2, int & aa2 ) const {

	if ( seqpos1 > seqpos2 ) {
		int const tmp_seqpos(seqpos1);
		seqpos1=seqpos2;
		seqpos2=tmp_seqpos;
		int const tmp_aa(aa1);
		aa1=aa2;
		aa2=tmp_aa;
	}

	return;
}


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeightMap::ensure_seqpos_swap
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void PackerTaskResidueWeightMap::ensure_seqpos_swap( int & seqpos1, int & seqpos2 ) const {

	if ( seqpos1 > seqpos2 ) {
		int const tmp_seqpos(seqpos1);
		seqpos1=seqpos2;
		seqpos2=tmp_seqpos;
	}

	return;
}


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeightMap::check_for_reweighted_pair
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool PackerTaskResidueWeightMap::check_for_reweighted_pair( int seqpos1, int seqpos2 ) const {

  if ( WeightMap.empty() ) return false;

	ensure_seqpos_swap( seqpos1, seqpos2 );

	int const map_inx = generate_map_inx( seqpos1, seqpos2 );
	std::map< int, PackerTaskResidueWeight >::const_iterator p = WeightMap.find( map_inx );

	if ( p != WeightMap.end() ) {
		return true;
	}
	return false;

}


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeightMap::get_weight
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
float PackerTaskResidueWeightMap::get_weight( int seqpos1, int aa1,
																							int seqpos2, int aa2 ) const {

	if ( WeightMap.empty() ) return 1.;

	ensure_seqpos_swap( seqpos1, aa1, seqpos2, aa2 );

	int const map_inx = generate_map_inx( seqpos1, seqpos2 );
	std::map< int, PackerTaskResidueWeight >::const_iterator p = WeightMap.find( map_inx );

	if ( p != WeightMap.end() ) {
		return (p->second).get_resres_weight( aa1, aa2 );
	}
	return 1.;

}


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeightMap::set_weight
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void PackerTaskResidueWeightMap::set_weight( float const new_weight, int seqpos1, int seqpos2 ) {

	ensure_seqpos_swap( seqpos1, seqpos2 );

	int const map_inx = generate_map_inx( seqpos1, seqpos2 );
	std::map< int, PackerTaskResidueWeight >::iterator p = WeightMap.find( map_inx );

	if ( p != WeightMap.end() ) {
		(p->second).set_resres_weight( new_weight );
	} else {
		PackerTaskResidueWeight r;
		r.set_resres_weight( new_weight );
		WeightMap.insert(std::make_pair(map_inx,r));
	}

	return;

}


//////////////////////////////////////////////////////////////////////////////
/// @begin PackerTaskResidueWeightMap::set_weight
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @remarks
///
/// @refrences
///
/// @authors John Karanicolas
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void PackerTaskResidueWeightMap::set_weight( float const new_weight,
																					 int seqpos1, int aa1,
									                         int seqpos2, int aa2 ) {

	ensure_seqpos_swap( seqpos1, aa1, seqpos2, aa2 );

	int const map_inx = generate_map_inx( seqpos1, seqpos2 );
	std::map< int, PackerTaskResidueWeight >::iterator p = WeightMap.find( map_inx );

	if ( p != WeightMap.end() ) {
		(p->second).set_resres_weight( new_weight, aa1, aa2 );
	} else {
		PackerTaskResidueWeight r;
		r.set_resres_weight( new_weight, aa1, aa2 );
		WeightMap.insert(std::make_pair(map_inx,r));
	}

	return;

}



