// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef PARALLEL_SIM_ANNEAL_H
#define PARALLEL_SIM_ANNEAL_H

// Rosetta Headers
#include "ParallelSimAnnealBase.h"

// forward declaration
class RotamerSet;

namespace pack{

  class ParallelSimAnneal;

  class ParallelSimAnneal :  public ParallelSimAnnealBase
    {
    public:
      ParallelSimAnneal(
			const RotamerSet * p_rotamer_set,
			FArray2DB_bool & neighborlist,
			FArray1D_int & bestrotamer_at_seqpos,
			float & bestenergy,
			bool start_with_current, // start simulation with current rotamers
			InteractionGraphBase * ig,
			FArray1DB_int & current_rot_index,
			bool calc_rot_freq,
			FArray1D_float & rot_freq
			);

      virtual ~ParallelSimAnneal();
      void run();

    protected:
      void create_a_random_sequence();
      void propogate_mutations_to_equivalent_residues();
      void enforce_common_amino_acids_for_equivalent_sequence_positions();

    private:
      ParallelSimAnneal(const ParallelSimAnneal& rhs);
  };

}//end of namespace

#endif
