// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef PARALLEL_SIM_ANNEAL_BASE_H
#define PARALLEL_SIM_ANNEAL_BASE_H

// Rosetta Headers
#include "SimAnnealerBase.h"
#include "ResidueData.h"


// forward declaration
class RotamerSet;

namespace pack{

  class ParallelSimAnnealBase;

  class ParallelSimAnnealBase :  public SimAnnealerBase
    {
    public:
      ParallelSimAnnealBase(
			const RotamerSet * p_rotamer_set,
			FArray2DB_bool & neighborlist,
			FArray1D_int & bestrotamer_at_seqpos,
			float & bestenergy,
			bool start_with_current, // start simulation with current rotamers
			InteractionGraphBase * ig,
			FArray1DB_int & current_rot_index,
			bool calc_rot_freq,
			FArray1D_float & rot_freq
			);

      virtual ~ParallelSimAnnealBase();
      virtual void run() = 0;

    protected:
      vector<int> best_rotamers_ever;
      int num_of_rot_to_pack_;
      InteractionGraphBase* ig_;
      FArray2DB_bool & neighborlist_;
      const RotamerSet * p_rotamer_set_;
      std::map<int, ResidueData> master_sequence_map;
      vector< list<int> > equivalent_residues;
      vector<int> rot_to_pack;
      list<int> key_sequence_positions;
      list<int> mutant_sequence_positions;
      int amino_acid_mutated_to;
      void revert_to_best_sequence();
      void print_iteration_status();
      void print_current_DNA_sequence();
      void print_current_amino_acid_sequence();
      void print_current_sequences();
      void fill_rot_to_pack_for_current_sequence();
      void add_current_rotamers_and_start_with_them();
      void add_current_rotamers_for_packing();
      void pack_set_of_rotamers();
      void accept_new_sequence_from_packing_run();
      void output_best_rotamers();
      void make_a_random_mutation();
      void make_a_sequential_substitution();
      void make_a_sequential_mutation();
      void make_a_cluster_of_random_mutations( const double & percent_of_key_residues_to_mutate_input );
      void reject_mutations();
      void add_rotamers_to_pack_for_neighbors_of_mutated_residues();
      void add_rotamers_to_pack_for_residue_list( const list<int> & residue_list_input );
      int number_of_possible_mutations();
      float delta_energy, previous_energy, energy_of_best_run;

    private:
      vector<int> possible_amino_acids_vector, key_sequence_positions_vector;
      void reset_amino_acid_vector_for_sequential_mutations();
      void reset_sequence_position_vector_for_sequential_mutations();
      void create_list_of_key_sequence_positions();
      void read_equiv_resfile();
      void create_residue_data_map();
      void add_neighbor_info_to_master_sequence_map();
      ParallelSimAnnealBase(const ParallelSimAnnealBase& rhs);
  };

}//end of namespace

#endif
