// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.2 $
//  $Date: 2006/01/14 21:12:20 $
//  $Author: plato $

#ifndef PRECOMPUTED_PAIR_ENERGIES_INTERACTION_GRAPH_H
#define PRECOMPUTED_PAIR_ENERGIES_INTERACTION_GRAPH_H

// Rosetta Headers
#include "InteractionGraphBase.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

namespace pack
{

class PrecomputedPairEnergiesNode;
class PrecomputedPairEnergiesEdge;
class PrecomputedPairEnergiesInteractionGraph;

class PrecomputedPairEnergiesNode : public NodeBase
{
public:
	virtual ~PrecomputedPairEnergiesNode() {}

	PrecomputedPairEnergiesNode(
		InteractionGraphBase * owner,
		int node_id,
		int num_states)
	:
		NodeBase( owner, node_id, num_states )
	{}

	virtual void set_amino_acid_types( std::vector< int > const & ) = 0;
	virtual void add_to_one_body_energy( int state, float energy) = 0;
	virtual void update_one_body_energy( int state, float energy) = 0;

};

class PrecomputedPairEnergiesEdge : public EdgeBase
{
public:
	virtual ~PrecomputedPairEnergiesEdge() {}
	PrecomputedPairEnergiesEdge(
		InteractionGraphBase* owner,
		int first_node_ind,
		int second_node_ind)
	:
		EdgeBase( owner, first_node_ind, second_node_ind )
	{}

	virtual
	void set_sparse_aa_info(FArray2DB_bool const & sparse_conn_info) = 0;

	virtual
	bool get_sparse_aa_info( int node1aa, int node2aa) = 0;

	virtual
	void force_aa_neighbors(int node1aa, int node2aa) = 0;

	virtual
	void force_all_aa_neighbors() = 0;

	virtual
	void add_to_two_body_energy(int const, int const, float const) = 0;

	virtual
	void add_to_two_body_energies( FArray2DB_float const & res_res_energy_array ) = 0;

	virtual
	void set_two_body_energy(int const, int const, float const) = 0;

	virtual
	void clear_two_body_energy(int const, int const) = 0;

	virtual float get_two_body_energy( int const, int const ) = 0;

};

class PrecomputedPairEnergiesInteractionGraph : public InteractionGraphBase
{
public:
	virtual ~PrecomputedPairEnergiesInteractionGraph() {}
	PrecomputedPairEnergiesInteractionGraph( int num_nodes )
	:
		InteractionGraphBase( num_nodes )
	{}

	virtual
	void set_aatypes_for_node(int node_ind, std::vector< int > const & aatypes);

	virtual void set_num_aatypes( int ) = 0;
	virtual int get_num_aatypes() const = 0;

	void add_to_nodes_one_body_energy
	(
		int node_ind,
		std::vector< float > const & one_body_energies
	);

	void add_to_nodes_one_body_energy
	(
		int node_ind,
		FArray1DB_float const & one_body_energies
	);

	void add_to_nodes_one_body_energy
	(
		int node_ind,
		int state_id,
		float const one_body_energy
	);

	void set_sparse_aa_info_for_edge
	(
		int node1,
		int node2,
		FArray2DB_bool const & sparse_conn_info
	);

	bool get_sparse_aa_info_for_edge
	(
		int node1,
		int node2,
		int node1aa,
		int node2aa
	);

	void force_aa_neighbors_for_edge
	(
		int node1,
		int node2,
		int node1aa,
		int node2aa
	);

	void force_all_aa_neighbors_for_edge
	(
		int node1,
		int node2
	);

	void add_to_two_body_energies_for_edge
	(
		int node1,
		int node2,
		FArray2DB_float const & res_res_energy_array
	);

	void add_to_two_body_energies_for_edge
	(
		int node1,
		int node2,
		int state_node1,
		int state_node2,
		float const two_body_energy
	);

	void set_two_body_energy_for_edge
	(
		int node1,
		int node2,
		int state_node1,
		int state_node2,
		float const two_body_energy
	);

	void clear_two_body_energy_for_edge
	(
		int node1,
		int node2,
		int state_node1,
		int state_node2
	);

	virtual float get_two_body_energy_for_edge
	(
		int node1,
		int node2,
		int state_node1,
		int state_node2
	);

	virtual void declare_edge_energies_final(int node1, int node2);

};

} //end namespace pack
#endif
