// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef INCLUDED_ROTAMER_OPTIONS
#define INCLUDED_ROTAMER_OPTIONS

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Ds.hh>
#include <ObjexxFCL/FArray2Ds.hh>
#include <ObjexxFCL/FArray3Ds.hh>

// C++ Headers
#include <map>
#include <vector>

namespace exchi_flags {
  void extra_rot_sample_names_initializer( FArray1D_string & names );
  // If you would like to add new chi sampling options, change three files:
  // RotamerOptions.h RotamerOptions.cc and rotamer_functions.cc
  // Add new chi sampling options to the end of the enumeration list
  // and not in the middle of it, or the meaning of "-ex1 7" will
  // change and that will upset people.
  enum ExtraRotSample {
    NO_EXTRA_CHI_SAMPLES,          //0
    EX_ONE_STDDEV,                 //1
    EX_ONE_HALF_STEP_STDDEV,       //2
    EX_TWO_FULL_STEP_STDDEVS,      //3
    EX_TWO_HALF_STEP_STDDEVS,      //4
    EX_FOUR_HALF_STEP_STDDEVS,     //5
    EX_THREE_THIRD_STEP_STDDEVS,   //6
    EX_SIX_QUARTER_STEP_STDDEVS,   //7
		EX_NINE_QUARTER_AND_THIRD_STEP_STDDEVS, //8
    ExtraRotSampleCardinality
  };
  extern FArray1D_string ExtraRotSampleNames;
}

class RotamerOptions
{
	private:
		void fill_ex_step_sets();
		std::vector< std::vector<float> > ex_step_sets;

 public:

  bool ex1;
  bool ex2;
  bool ex3;
  bool ex4;
  bool ex1aro;
  bool ex1aro_half;
  bool ex2aro_only;
  bool ex1aro_exposed;
  bool ex2aro_exposed;
  bool exOH;
  bool excys;
  exchi_flags::ExtraRotSample ex1_sample_level;
  exchi_flags::ExtraRotSample ex2_sample_level;
  exchi_flags::ExtraRotSample ex3_sample_level;
  exchi_flags::ExtraRotSample ex4_sample_level;
  bool exrotset_from_db;
  FArray3D< exchi_flags::ExtraRotSample > extrachi_flag;
  FArray3D< exchi_flags::ExtraRotSample > explode_flag;
  int extrachi_cutoff;
  int base_rotamer_buried_cutoff;

  bool rot_pert;
  bool rot_pert_input;
  float pert_acc_prob;
  float pert_size;

  bool use_input_sc;
  bool use_input_cb;

  bool rot_opt;

  bool dump_rotamers_pdb_flag;
  int dump_rotamers_pdb_res;

  bool rot_explode;
	exchi_flags::ExtraRotSample rot_explode_sample_level_chi12;
	exchi_flags::ExtraRotSample rot_explode_sample_level_chi3;
	exchi_flags::ExtraRotSample rot_explode_sample_level_chi4;
  bool rot_explode_accept_all;
	int rot_explode_debug_number_screens;
	bool rot_explode_rtmin;
	bool minimize_best_rotamers;
  float explode_cutoff;

  bool dna_rotamers_exist;

  bool do_rotamer_bias;
  bool bias_rotamers_by_replacement;
  std::map<int, float> extra_bias_weights;


  RotamerOptions();

  inline ~RotamerOptions() { return; };

  void setup_exflags();

  void read_rotamer_flags();

  exchi_flags::ExtraRotSample get_extra_rot_sample_level(
    std::string const str, exchi_flags::ExtraRotSample default_sample_level
  );

	std::vector<float>
	ex_step_set( exchi_flags::ExtraRotSample const opt )
	{
		return ex_step_sets[opt];
	}

  void set_ex12( bool const ex1, bool const ex2, bool const ex1_aro = false );

};

#endif
