// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7739 $
//  $Date: 2006-03-23 14:43:49 -0500 (Thu, 23 Mar 2006) $
//  $Author: monica $
//
//  @begin SplicedProtein.cc
//
//  @brief
//  Creates a map with protein insertion information
//
//  @detailed:
//  The map shows where the original pdb information came from and how it corresponds in to the
//  information in the new pdb of a combined pose that will be output.
//
//  @authors: Monica Berrondo
//
//  @last_modified: April 07 2006

#ifndef INCLUDED_SplicedProtein
#define INCLUDED_SplicedProtein

// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers

// C++ Headers
#include <string>
#include <vector>

// insertion map class that contains the mapping information
class SplicedProtein {
public:
	int fusion_protein_res_num; // residue number from the "fused" protein (combination of host and insertion proteins)
	std::string original_pdb_filename; // filename of the original pdb
	std::string original_protein_type; // type of protein of the original protein (host or insertion)
	//enum original_protein_type {HOST_PROTEIN, INSERTION_PROTEIN};
	int original_protein_res_num; // sequential rosetta residue number from the original protein (eg, goes from 1-nres per protein)
	int original_protein_pdb_res_num; // residue number (from pdb) of the original protein
	int residue_repetition; // set as either 0 or positive number.  default is 0, positive number indicates that there is more than one of the same residues from the same protein

	// constructors
	SplicedProtein()
	{}

	SplicedProtein (
				int const fpres,
				std::string const op,
				std::string const opt,
				int const opres,
				int const oppres,
				int const resrep
				)
	{
		fusion_protein_res_num = fpres;
		original_pdb_filename = op;
		original_protein_type = opt;
		original_protein_res_num = opres;
		original_protein_pdb_res_num = oppres;
		residue_repetition = resrep;
	}

	// function to delete everything from the map
  void
	reset_spliced_protein_map();

	// function to put the information into the map
	void
	pushback_segment(
				std::string const name,
				std::string const type,
				int const protein_start,
				int const segment_start,
				int const segment_size,
				pose_ns::Pose const & pose
				);

	// function to set the value of residue repetition
	void
	set_repetition(
			int const protein_start,
			int const segment_start,
			int const segment_size,
			std::string const type,
			std::vector <int> repeated_residues,
			int const repetition
	 );

	// returns the residue number of the combined protein
	void get_combined_residue_from_pdb(
			int &num_out,
			std::string name_in,
			int num_in,
			int start,
			int end,
			int resrep_in
	 );

	// returns the residue number of the combined protein
	void get_combined_residue(
			int &num_out,
			std::string name_in,
			int num_in,
			int start,
			int end,
			int resrep_in
	 );

	friend std::ostream &operator<< ( std::ostream &os, SplicedProtein const &inmap );

	void
	print_map();
};
#endif

