// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision:
//  $Date:
//  $Author:

#ifndef INCLUDED_SurfaceMode_h
#define INCLUDED_SurfaceMode_h


// Rosetta Headers
#include "Flag.h"

// Numeric Headers
#include <numeric/xyzVector.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <vector>


//==============================================================================
//
//  add -surface mode to model proteins with surfaces eg mica, hydroxyapatite
//
//		Kosta Makrodimitris,Ph.D. (KMa) 2006-02
//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// C++ Headers
// ObjexxFCL Headers
// #include <iosfwd>
//==============================================================================
//2006-02
//KMa surface
//==============================================================================
namespace surface
{

//GLOBAL TO SURFACE ALWAYS

 //?????????????????????????????????????????????????????????????????????


class SurfaceMode
{

private:

	SurfaceMode(const SurfaceMode & s);
	SurfaceMode & operator=(const SurfaceMode & s);

public:
	SurfaceMode( )
		: flag("surface")
		, PDB3atoms_planeCell(3,0)
		, ABdistance(0.0)
		, ACdistance(0.0)
	{}

	~SurfaceMode( )
	{}

	 numeric::xyzVector<double>
	 proteinmove_surface_symmetry();

	 	 numeric::xyzVector<double>
	 protein_surfacemove_symmetry() ;

public:
    Flag flag;

    numeric::xyzVector<double> surface3pointA0, surface3pointB0,
		surface3pointC0, vAB0, vAC0, centerG_surface;

	 FArray1D_int PDB3atoms_planeCell;
	// std::vector<int> PDB3atoms_planeCell ;

    double ABdistance, ACdistance ;

};

extern SurfaceMode mode;



} //namespace surface
#endif





