// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13164 $
//  $Date: 2007-02-29 16:51:28 -0500 (Wed, 28 Feb 2007) $
//  $Author: leaverfa $

//Rosetta Headers
#include "aa_name_conversion.h"
#include "param.h"
#include "param_aa.h"

//STL Headers
#include <iostream>

////////////////////////////////////////////////////////////////////////////////
/// @begin num_from_name
///
/// @brief
/// a function that converts amino acid three letter code into
/// a number between 1-29, alphabetical by one letter code
///
/// @detailed
///
/// @param  xxx - [in/out]? -
/// @param  translate - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
num_from_name(
	std::string const & xxx,
	int & translate
)
{
	using namespace param;
	using namespace param_aa;

	// If enable_dna is off, prevent the dna 3-letter codes from
	// being checked

	//dr int const upper_limit = ( dna_enabled() ? MAX_AA() : MAX_AUTH_AA );
	//dr with nnaa just always check
	int const upper_limit = MAX_AA();

	for ( int i = 1; i <= upper_limit; ++i ) {
		if ( xxx == aa_name3(i) ) {
			translate = i;
			return;
		}
	}
	//*** if xxx is not equal to any of these then set the amino acid type to 0
	translate = 0;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin num_from_res1
///
/// @brief
/// a function that converts amino acid one letter code into
/// a number between 1-29, alphabetical by one letter code
///
/// @detailed
///
/// @param  x - [in/out]? -
/// @param  translate - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
num_from_res1(
	char const x,
	int & translate
)
{
	using namespace param;
	using namespace param_aa;

	for ( int i = 1, ie = MAX_AA(); i <= ie; ++i ) {
		if ( x == aa_name1(i) ) {
			translate = i;
			return;
		}
	}
//*** if x is not equal to any of these then set the amino acid type to 0
	translate = 0;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin num_from_res3
///
/// @brief
/// a function that converts amino acid three letter code into
/// a number between 1-29, alphabetical by one letter code
///
/// @detailed
///
/// @param  x - [in/out]? -
/// @param  translate - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
/// Alex Morozov
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
num_from_res3(
	std::string const & x,
	int & translate
)
{
	using namespace param;
	using namespace param_aa;

	for ( int i = 1, ie = MAX_AA(); i <= ie; ++i ) {
		if ( x == aa_name3(i) ) {
			translate = i;
			return;
		}
	}
//*** if x is not equal to any of these then set the amino acid type to 0
	translate = 0;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin name_from_num
///
/// @brief
///
/// @detailed
///
/// @param  x - [in/out]? -
/// @param  invtranslate - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
name_from_num(
	int x,
	std::string & invtranslate
)
{
	using namespace param;
	using namespace param_aa;

	if ( x > MAX_AA() || x <= 0 ) {
		std::cerr << "name_from_num called with aa code out of range! aa: "
							<< x << std::endl;
		std::cerr << "  Aborting..." << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	invtranslate = aa_name3(x);
}

////////////////////////////////////////////////////////////////////////////////
/// @begin res1_from_num
///
/// @brief
///
/// @detailed
///
/// @param  x - [in/out]? -
/// @param  invtranslate - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
res1_from_num(
	int x,
	std::string & invtranslate
)
{
	using namespace param;
	using namespace param_aa;

	if ( x > MAX_AA() || x < 0 ) {
		std::cout << "res1_from_num called with aa code out of range!" << std::endl;
		std::cout << "  Aborting..." << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	invtranslate = aa_name1(x);
}

////////////////////////////////////////////////////////////////////////////////
/// @begin res1_from_num
///
/// @brief
///
/// @detailed
///
/// @param  x - [in/out]? -
/// @param  invtranslate - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
res1_from_num(
	int x,
	char & invtranslate
)
{
	using namespace param;
	using namespace param_aa;

	if ( x > MAX_AA() || x < 0 ) {
		std::cout << "res1_from_num called with aa code out of range!" << std::endl;
		std::cout << "  Aborting..." << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	invtranslate = aa_name1(x);
}
