// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16901 $
//  $Date: 2007-09-03 18:49:14 -0700 (Mon, 03 Sep 2007) $
//  $Author: kaufmann $


// Rosetta Headers
#include "aaproperties_pack.h"
#include "hbonds_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>

// Using
using namespace hbonds;
using namespace param;


//bk namespace for amino acid properties
//bk variables have information about all
//bk possible atoms an amino acid variant can have
//jss _complete is no longer needed since they were identical to these


namespace aaproperties_pack {

namespace properties_per_aa_aav { // properties for each amino acid variant
	FArray1D_int nvar( MAX_AA(), 0 ); // how many variants does each amino acid have

	FArray2D_int natoms( MAX_AA(), MAX_AA_VARIANTS() );
	FArray2D_int nside( MAX_AA(), MAX_AA_VARIANTS() ); // # of sidechains per amino acid
	FArray2D_int nheavyatoms( MAX_AA(), MAX_AA_VARIANTS() );
	FArray2D_int first_scatom( MAX_AA(), MAX_AA_VARIANTS() );

	FArray2D_int HNpos( MAX_AA(), MAX_AA_VARIANTS() ); // backbone HN position
	FArray2D_int HApos( MAX_AA(), MAX_AA_VARIANTS() );
	FArray2D_int nacceptors( MAX_AA(), MAX_AA_VARIANTS() ); // # of hbond acceptors
	FArray3D_int accpt_pos( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // hbond acceptor positions
	FArray2D_int nH_polar( MAX_AA(), MAX_AA_VARIANTS() ); // number of polar H per residue
	FArray3D_int Hpos_polar( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // posn of polar H (atm #)
	FArray2D_int nH_aromatic( MAX_AA(), MAX_AA_VARIANTS() ); // number of aromatic H
	FArray3D_int Hpos_aromatic( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // posn of aromatic H
	FArray2D_int nH_apolar( MAX_AA(), MAX_AA_VARIANTS() ); // number of apolar H
	FArray3D_int Hpos_apolar( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // position of apolar H

	FArray2D_int nchi( MAX_AA(), MAX_AA_VARIANTS() );
	FArray4D_int chi_atoms( 4, MAX_CHI, MAX_AA(), MAX_AA_VARIANTS() ); // chi atoms; four for each nchi
	FArray4D_bool chi_required( MAX_CHI, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // chi needed to bld atm?
	FArray3D_int length_chi_rigid_atom_list( MAX_CHI, MAX_AA(), MAX_AA_VARIANTS() );
	FArray4D_int chi_rigid_atom_list( MAX_ATOM(), MAX_CHI, MAX_AA(), MAX_AA_VARIANTS() );
}

namespace properties_per_atom_aa_aav { // properties for each atom in aa/aav
	FArray3D_int fullatom_type( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
	FArray3D_string atom_name( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS(), std::string( 4, ' ' ) );
	FArray3D_string atom_type_char( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS(), std::string( 4, ' ' ) );
	FArray4D_float icoor( 3, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
	FArray4D_int ta( 3, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
	FArray3D_int cp_atom_num( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );

	std::map< int, std::vector<bool> > major_groove_hb_atom;
	FArray3D_int atom_base( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
	FArray3D_int abase2( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );

	FArray3D_int na_anchor( 3, MAX_AA(), MAX_AA_VARIANTS() );
}


namespace properties_atom_nbr_in_aa_aav { // info on neighbors per atom in aa/aav
	int const max_bonded_neighbors( 5 );
	int const max_angle_neighbors( 15 );
	int const max_dihe_neighbors( 45 );
	FArray3D_int nhydrogens_on_atm( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // number of hydrogens bound
		// to the specified heavy atom
	FArray4D_int hydrogens_on_atm( 4, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // atom position numbers
		// for hydrogens bound to a given heavy atom
	FArray3D_int nbonded_neighbors( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
		// atom number of neighbor
	FArray4D_int bonded_neighbor( max_bonded_neighbors, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
	FArray3D_int nangle_neighbors( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
		// atom number of neighbor
	FArray4D_int angle_neighbor( max_angle_neighbors, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
	FArray3D_int ndihe_neighbors( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
		// atom number of neighbor
	FArray4D_int dihe_neighbor( max_dihe_neighbors, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );

	FArray3D_float atomic_charge( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // explicitly assigned partial atomic charges
}


namespace properties_water {
	int const max_h2o_per_aa = { 5 }; // maximum number of waters per rotamer
	FArray2D_int nh2o( MAX_AA(), MAX_AA_VARIANTS() ); // number of waters
	FArray3D_int h2opos( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
	FArray4D_int h2o_on_atm( max_h2o_per_aa, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // what waters are connected to this atom
	FArray3D_int nh2o_on_atm( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // how many waters are on this atom (must be a heavyatom)
	FArray3D_int heavy_atm_on_h2o( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // which heavy atom is connected to this water
	FArray3D_int hyd_atm_on_h2o( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // which hydrogen atom is connected to this water, if water is an acceptor
	FArray3D_int template_atm_on_h2o( MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() ); // which  template atom is connected to this water
}


	/////////////////////////////////////////////////////////////////////////////////////////////////////
	//  see .h file for   BRIEF INSTRUCTIONS ON HOW TO DEFINE A NEW ATOM TYPE IN ROSETTA
	//////////////////////////////////////////////////////////////////////////////////////////////////////

namespace properties_atomtype {

	void
	atom_type_name_initializer( FArray1D_string & atom_type_name )
	{ //bk names for the different atom types
		if ( atom_type_name.u() == 0 ) return;
		atom_type_name( 1) = "CNH2";
		atom_type_name( 2) = "COO ";
		atom_type_name( 3) = "CH1 ";
		atom_type_name( 4) = "CH2 ";
		atom_type_name( 5) = "CH3 ";
		atom_type_name( 6) = "aroC";
		atom_type_name( 7) = "Ntrp";
		atom_type_name( 8) = "Nhis";
		atom_type_name( 9) = "NH2O";
		atom_type_name(10) = "Nlys";
		atom_type_name(11) = "Narg";
		atom_type_name(12) = "Npro";
		atom_type_name(13) = "OH  ";
		atom_type_name(14) = "ONH2";
		atom_type_name(15) = "OOC ";
		atom_type_name(16) = "S   ";
		atom_type_name(17) = "Nbb ";
		atom_type_name(18) = "CAbb";
		atom_type_name(19) = "CObb";
		atom_type_name(20) = "OCbb";
		atom_type_name(21) = "Phos";//P in phosphate,dna CHARMM27, Kosta Makrodimitris 10/2005
		atom_type_name(22) = "Hpol";
		atom_type_name(23) = "Hapo";
		atom_type_name(24) = "Haro";
		atom_type_name(25) = "HNbb";
		if ( atom_type_name.u() == 25 ) return;
		atom_type_name(26) = "HOH ";
		if ( atom_type_name.u() == 26 ) return;
		atom_type_name(27) = "F   ";
		atom_type_name(28) = "Cl  ";
		atom_type_name(29) = "Br  ";
		atom_type_name(30) = "I   ";
		atom_type_name(31) = "Zn2p";
		atom_type_name(32) = "Fe2p";
		atom_type_name(33) = "Fe3p";
		atom_type_name(34) = "Mg2p";
		atom_type_name(35) = "Ca2p";
		atom_type_name(36) = "Na1p";
		atom_type_name(37) = "K1p ";
		atom_type_name(38) = "Au  "; //  Gold in cubic close packed lattice, David Masica
		atom_type_name(39) = "Oice"; //  Oxygen in Ice, David Masica
		atom_type_name(40) = "Hice"; //  Hydrogen in Ice, David Masica
		atom_type_name(41) = "Si  "; //  Silicon, in alpha-Quartz David Masica
		atom_type_name(42) = "Osi "; //  Oxygen in alpha-Quartz, David Masica
		atom_type_name(43) = "OP  "; //  Oxygen in phosphate, CHARMM27, Kosta Makrodimitris 10/2005
		atom_type_name(44) = "OHP "; //  Hydroxyl/ester Oxygen in phosphate, CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_name(45) = "HOP "; //  Hydrogen in phosphate, CHARMM27, Kosta Makrodimitris 10/2005
		atom_type_name(46) = "Pha "; //  P/ HA(HydroxyApatite), S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_name(47) = "OPha"; //  OP/HA(HydroxyApatite), S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_name(48) = "OHha"; //  OH/HA(HydroxyApatite), S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_name(49) = "Hha "; //  HO/HA(HydroxyApatite), S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_name(50) = "CS1 "; // C1 pyranose sugars (glucose, mannose, galactose, etc), Liang & Brady 94, bkidd
		atom_type_name(51) = "CS2 "; // C2 pyranose sugars (glucose, mannose, galactose, etc), Liang & Brady 94, bkidd
		atom_type_name(52) = "CS5 "; // C5 pyranose sugars (glucose, mannose, galactose, etc), Liang & Brady 94, bkidd
		atom_type_name(53) = "CS6 "; // C6 pyranose sugars (glucose, mannose, galactose, etc), Liang & Brady 94, bkidd
		atom_type_name(54) = "O5  "; // O5 pyranose sugars (glucose, mannose, galactose, etc), Liang & Brady 94, bkidd
		atom_type_name(55) = "VOOC"; //  1 ASP/GLU
		atom_type_name(56) = "VCOO"; //  2 ASP/GLU
		atom_type_name(57) = "VOCN"; //  3 ASN/GLN or BB
		atom_type_name(58) = "VNOC"; //  4 ASN/GLN or BB
		atom_type_name(59) = "VCON"; //  5 ASN/GLN or BB
		atom_type_name(60) = "VSOG"; //  6 SER OG
		atom_type_name(61) = "VSCB"; //  7 SER CB
		atom_type_name(62) = "VCSG"; //  8 CYS SG
		atom_type_name(63) = "VCCB"; //  9 CYS CB
		atom_type_name(64) = "VRNH"; // 10 ARG NH
		atom_type_name(65) = "VRNE"; // 11 ARG NE
		atom_type_name(66) = "VKNZ"; // 12 LYS NZ
		atom_type_name(67) = "VKCE"; // 13 LYS CE
		atom_type_name(68) = "VHND"; // 14 HIS ND
		atom_type_name(69) = "VHNE"; // 15 HIS NE
		atom_type_name(70) = "VHCB"; // 16 HIS CB
		atom_type_name(71) = "VHPO"; // 17 HPOL
	}

	void
	hybridization_initializer( FArray1D_int & hybridization )
	{ //bk hybridization state of different atom types -- formerly used to determine type of hbond
		if ( hybridization.u() == 0 ) return;
		hybridization( 1) = SP2_HYBRID;  // CNH2
		hybridization( 2) = SP2_HYBRID;  // COO
		hybridization( 3) = SP3_HYBRID;  // CH1
		hybridization( 4) = SP3_HYBRID;  // CH2
		hybridization( 5) = SP3_HYBRID;  // CH3
		hybridization( 6) = SP2_HYBRID;  // aroC
		hybridization( 7) = SP2_HYBRID;  // Ntrp
		hybridization( 8) = RING_HYBRID; // Nhis
		hybridization( 9) = SP2_HYBRID;  // NH2O
		hybridization(10) = SP3_HYBRID;  // NLYS
		hybridization(11) = SP2_HYBRID;  // Narg
		hybridization(12) = SP2_HYBRID;  // Npro
		hybridization(13) = SP3_HYBRID;  // OH
		hybridization(14) = SP2_HYBRID;  // ONH2
		hybridization(15) = SP2_HYBRID;  // OOC
		hybridization(16) = SP3_HYBRID;  // S
		hybridization(17) = SP2_HYBRID;  // Nbb
		hybridization(18) = SP3_HYBRID;  // CAbb
		hybridization(19) = SP2_HYBRID;  // CObb
		hybridization(20) = SP2_HYBRID;  // OCbb
		hybridization(21) = SP3_HYBRID;  // Phos
		hybridization(22) = H_HYBRID;    // Hpol
		hybridization(23) = H_HYBRID;    // Hapo
		hybridization(24) = H_HYBRID;    // Haro
		hybridization(25) = H_HYBRID;    // HNbb
		if ( hybridization.u() == 25 ) return;
		hybridization(26) = SP3_HYBRID;  // H2O
		if ( hybridization.u() == 26 ) return;
		hybridization(27) = SP3_HYBRID;  // F
		hybridization(28) = SP3_HYBRID;  // Cl
		hybridization(29) = SP3_HYBRID;  // Br
		hybridization(30) = SP3_HYBRID;  // I
		hybridization(31) = SP3_HYBRID;  // Zn2p
		hybridization(32) = SP3_HYBRID;  // Fe2p
		hybridization(33) = SP3_HYBRID;  // Fe3p
		hybridization(34) = SP3_HYBRID;  // Mg2p
		hybridization(35) = SP3_HYBRID;  // Ca2p
		hybridization(36) = SP3_HYBRID;  // Na1p
		hybridization(37) = SP3_HYBRID;  // K1p
		hybridization(38) = SP3_HYBRID;  // Au, ?
		hybridization(39) = SP3_HYBRID;  // O IN ICE
		hybridization(40) = H_HYBRID;    // H IN ICE
		hybridization(41) = SP3_HYBRID;  // Si in qurtz
		hybridization(42) = SP3_HYBRID;  // O in quartz
		hybridization(43) = SP3_HYBRID;  // O in phosphate O=P, Kosta Makrodimitris 10/2005
		hybridization(44) = SP3_HYBRID;  // O in phosphate O-H,O-C Kosta Makrodimitris 11/2005
		hybridization(45) = H_HYBRID;  // H in phosphate H-O-P, Kosta Makrodimitris 10/2005
		hybridization(46) = SP3_HYBRID;  // P/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		hybridization(47) = SP3_HYBRID;  // OP/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		hybridization(48) = SP3_HYBRID;  // OH/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		hybridization(49) = H_HYBRID;    // HO/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		hybridization(50) = SP2_HYBRID;  // CS1 sugar atoms, bkidd
		hybridization(51) = SP2_HYBRID;  // CS2 sugar atoms, bkidd
		hybridization(52) = SP2_HYBRID;  // CS5 sugar atoms, bkidd
		hybridization(53) = SP2_HYBRID;  // CS6 sugar atoms, bkidd
		hybridization(54) = SP2_HYBRID;  // 05 sugar atoms, bkidd
		hybridization(55) = H_HYBRID;    //
		hybridization(56) = H_HYBRID;    //
		hybridization(57) = H_HYBRID;    //
		hybridization(58) = H_HYBRID;    //
		hybridization(59) = H_HYBRID;    //
		hybridization(60) = H_HYBRID;    //
		hybridization(61) = H_HYBRID;    //
		hybridization(62) = H_HYBRID;    //
		hybridization(63) = H_HYBRID;    //
		hybridization(64) = H_HYBRID;    //
		hybridization(65) = H_HYBRID;    //
		hybridization(66) = H_HYBRID;    //
		hybridization(67) = H_HYBRID;    //
		hybridization(68) = H_HYBRID;    //
		hybridization(69) = H_HYBRID;    //
		hybridization(70) = H_HYBRID;    //
		hybridization(71) = H_HYBRID;    //
	}

	void
	HBdonchemtype_initializer( FArray1D_int & HBdonchemtype )
	{ //bk HBdonchemtype state of different atom types -- used (w/ HBaccchemtype) to decide type of hbond
		using namespace hbonds;

		if ( HBdonchemtype.u() == 0 ) return;
		HBdonchemtype( 1) = hbdon_NO;  // CNH2
		HBdonchemtype( 2) = hbdon_NO;  // COO
		HBdonchemtype( 3) = hbdon_NO;  // CH1
		HBdonchemtype( 4) = hbdon_NO;  // CH2
		HBdonchemtype( 5) = hbdon_NO;  // CH3
		HBdonchemtype( 6) = hbdon_NO;  // aroC
		HBdonchemtype( 7) = hbdon_SC;  // Ntrp // protonated ring N
		HBdonchemtype( 8) = hbdon_NO;  // Nhis // unprotonated ring N
		HBdonchemtype( 9) = hbdon_SC;  // NH2O
		HBdonchemtype(10) = hbdon_SC;  // NLYS
		HBdonchemtype(11) = hbdon_SC;  // Narg
		HBdonchemtype(12) = hbdon_NO;  // Npro
		HBdonchemtype(13) = hbdon_SC;  // OH
		HBdonchemtype(14) = hbdon_NO;  // ONH2
		HBdonchemtype(15) = hbdon_NO;  // OOC
		HBdonchemtype(16) = hbdon_NO;  // S
		HBdonchemtype(17) = hbdon_BBN; // Nbb
		HBdonchemtype(18) = hbdon_NO;  // CAbb
		HBdonchemtype(19) = hbdon_NO;  // CObb
		HBdonchemtype(20) = hbdon_NO;  // OCbb
		HBdonchemtype(21) = hbdon_NO;  // Phos
		HBdonchemtype(22) = hbdon_NO;  // Hpol
		HBdonchemtype(23) = hbdon_NO;  // Hapo
		HBdonchemtype(24) = hbdon_NO;  // Haro
		HBdonchemtype(25) = hbdon_NO;  // HNbb
		if ( HBdonchemtype.u() == 25 ) return;
		HBdonchemtype(26) = hbdon_SC;  // H2O
		if ( HBdonchemtype.u() == 26 ) return;
		HBdonchemtype(27) = hbdon_NO;  // F
		HBdonchemtype(28) = hbdon_NO;  // Cl
		HBdonchemtype(29) = hbdon_NO;  // Br
		HBdonchemtype(30) = hbdon_NO;  // I
		HBdonchemtype(31) = hbdon_NO;  // Zn2p
		HBdonchemtype(32) = hbdon_NO;  // Fe2p
		HBdonchemtype(33) = hbdon_NO;  // Fe3p
		HBdonchemtype(34) = hbdon_NO;  // Mg2p
		HBdonchemtype(35) = hbdon_NO;  // Ca2p
		HBdonchemtype(36) = hbdon_NO;  // Na1p
		HBdonchemtype(37) = hbdon_NO;  // K1p
		HBdonchemtype(38) = hbdon_NO;  // Au, ?
		HBdonchemtype(39) = hbdon_NO;  // O IN ICE
		HBdonchemtype(40) = hbdon_NO;  // H IN ICE
		HBdonchemtype(41) = hbdon_NO;  // Si in qurtz
		HBdonchemtype(42) = hbdon_NO;  // O in quartz
		HBdonchemtype(43) = hbdon_NO;  // O in phosphate O=P, Kosta Makrodimitris 10/2005
		HBdonchemtype(44) = hbdon_NO;  // O in phosphate O-H,O-C Kosta Makrodimitris 11/2005
		HBdonchemtype(45) = hbdon_NO;  // H in phosphate H-O-P, Kosta Makrodimitris 10/2005
		HBdonchemtype(46) = hbdon_NO;  // P/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		HBdonchemtype(47) = hbdon_NO;  // OP/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		HBdonchemtype(48) = hbdon_NO;  // OH/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		HBdonchemtype(49) = hbdon_NO;  // HO/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		HBdonchemtype(50) = hbdon_NO;  // CS1 sugar atoms, bkidd
		HBdonchemtype(51) = hbdon_NO;  // CS2 sugar atoms, bkidd
		HBdonchemtype(52) = hbdon_NO;  // CS5 sugar atoms, bkidd
		HBdonchemtype(53) = hbdon_NO;  // CS6 sugar atoms, bkidd
		HBdonchemtype(54) = hbdon_NO;  // 05 sugar atoms, bkidd
		HBdonchemtype(55) = hbdon_NO;    //
		HBdonchemtype(56) = hbdon_NO;    //
		HBdonchemtype(57) = hbdon_NO;    //
		HBdonchemtype(58) = hbdon_NO;    //
		HBdonchemtype(59) = hbdon_NO;    //
		HBdonchemtype(60) = hbdon_NO;    //
		HBdonchemtype(61) = hbdon_NO;    //
		HBdonchemtype(62) = hbdon_NO;    //
		HBdonchemtype(63) = hbdon_NO;    //
		HBdonchemtype(64) = hbdon_NO;    //
		HBdonchemtype(65) = hbdon_NO;    //
		HBdonchemtype(66) = hbdon_NO;    //
		HBdonchemtype(67) = hbdon_NO;    //
		HBdonchemtype(68) = hbdon_NO;    //
		HBdonchemtype(69) = hbdon_NO;    //
		HBdonchemtype(70) = hbdon_NO;    //
		HBdonchemtype(71) = hbdon_NO;    //
	}

	void
	HBaccchemtype_initializer( FArray1D_int & HBaccchemtype )
	{ //bk HBaccchemtype state of different atom types -- used to determine type of hbonds
		using namespace hbonds;

		if ( HBaccchemtype.u() == 0 ) return;
		HBaccchemtype( 1) = hbacc_NO;  // CNH2
		HBaccchemtype( 2) = hbacc_NO;  // COO
		HBaccchemtype( 3) = hbacc_NO;  // CH1
		HBaccchemtype( 4) = hbacc_NO;  // CH2
		HBaccchemtype( 5) = hbacc_NO;  // CH3
		HBaccchemtype( 6) = hbacc_NO;  // aroC
		HBaccchemtype( 7) = hbacc_NO;  // Ntrp // protonated ring N
		HBaccchemtype( 8) = hbacc_RING;// Nhis // deprotonated ring N
		HBaccchemtype( 9) = hbacc_NO;  // NH2O
		HBaccchemtype(10) = hbacc_NO;  // NLYS
		HBaccchemtype(11) = hbacc_NO;  // Narg
		HBaccchemtype(12) = hbacc_NO;  // Npro
		HBaccchemtype(13) = hbacc_SP3; // OH   // hydroxyl O in Ser, Thr and Tyr
		HBaccchemtype(14) = hbacc_SP2; // ONH2 // carbonyl O in Asn and Gln
		HBaccchemtype(15) = hbacc_SP2; // OOC  // carboyxl O in Asp and Glu
		HBaccchemtype(16) = hbacc_NO;  // S
		HBaccchemtype(17) = hbacc_NO;  // Nbb
		HBaccchemtype(18) = hbacc_NO;  // CAbb
		HBaccchemtype(19) = hbacc_NO;  // CObb
		HBaccchemtype(20) = hbacc_BB;  // OCbb // backbone O'
		HBaccchemtype(21) = hbacc_NO;  // Phos
		HBaccchemtype(22) = hbacc_NO;  // Hpol
		HBaccchemtype(23) = hbacc_NO;  // Hapo
		HBaccchemtype(24) = hbacc_NO;  // Haro
		HBaccchemtype(25) = hbacc_NO;  // HNbb
		if ( HBaccchemtype.u() == 25 ) return;
		HBaccchemtype(26) = hbacc_SP3; // H2O
		if ( HBaccchemtype.u() == 26 ) return;
		HBaccchemtype(27) = hbacc_NO;  // F
		HBaccchemtype(28) = hbacc_NO;  // Cl
		HBaccchemtype(29) = hbacc_NO;  // Br
		HBaccchemtype(30) = hbacc_NO;  // I
		HBaccchemtype(31) = hbacc_NO;  // Zn2p
		HBaccchemtype(32) = hbacc_NO;  // Fe2p
		HBaccchemtype(33) = hbacc_NO;  // Fe3p
		HBaccchemtype(34) = hbacc_NO;  // Mg2p
		HBaccchemtype(35) = hbacc_NO;  // Ca2p
		HBaccchemtype(36) = hbacc_NO;  // Na1p
		HBaccchemtype(37) = hbacc_NO;  // K1p
		HBaccchemtype(38) = hbacc_SP3; // Au, ?  hbacc_SP3underspecified - maybe don't know 2 adj to determine lone pairs...
		HBaccchemtype(39) = hbacc_SP3; // O IN ICE
		HBaccchemtype(40) = hbacc_NO;  // H IN ICE
		HBaccchemtype(41) = hbacc_NO;  // Si in qurtz
		HBaccchemtype(42) = hbacc_SP3; // O in quartz ? SP3underspecified
		HBaccchemtype(43) = hbacc_SP3; // O in phosphate O=P, Kosta Makrodimitris 10/2005 ? SP3underspecified
		HBaccchemtype(44) = hbacc_NO;  // O in phosphate O-H,O-C Kosta Makrodimitris 11/2005 ? SP3underspecified
		HBaccchemtype(45) = hbacc_NO;  // H in phosphate H-O-P, Kosta Makrodimitris 10/2005
		HBaccchemtype(46) = hbacc_NO;  // P/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		HBaccchemtype(47) = hbacc_SP3; // OP/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		HBaccchemtype(48) = hbacc_SP3; // OH/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		HBaccchemtype(49) = hbacc_NO;  // HO/HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		HBaccchemtype(50) = hbacc_NO;  // CS1 sugar atoms, bkidd
		HBaccchemtype(51) = hbacc_NO;  // CS2 sugar atoms, bkidd
		HBaccchemtype(52) = hbacc_NO;  // CS5 sugar atoms, bkidd
		HBaccchemtype(53) = hbacc_NO;  // CS6 sugar atoms, bkidd
		HBaccchemtype(54) = hbacc_NO;  // 05 sugar atoms, bkidd
		HBaccchemtype(55) = hbacc_NO;    //
		HBaccchemtype(56) = hbacc_NO;    //
		HBaccchemtype(57) = hbacc_NO;    //
		HBaccchemtype(58) = hbacc_NO;    //
		HBaccchemtype(59) = hbacc_NO;    //
		HBaccchemtype(60) = hbacc_NO;    //
		HBaccchemtype(61) = hbacc_NO;    //
		HBaccchemtype(62) = hbacc_NO;    //
		HBaccchemtype(63) = hbacc_NO;    //
		HBaccchemtype(64) = hbacc_NO;    //
		HBaccchemtype(65) = hbacc_NO;    //
		HBaccchemtype(66) = hbacc_NO;    //
		HBaccchemtype(67) = hbacc_NO;    //
		HBaccchemtype(68) = hbacc_NO;    //
		HBaccchemtype(69) = hbacc_NO;    //
		HBaccchemtype(70) = hbacc_NO;    //
		HBaccchemtype(71) = hbacc_NO;    //
	}

	void
	atom_type_cent_initializer( FArray1D_int & atom_type_cent )
	{ //mj atom_type_cent state of different atom types
		if ( atom_type_cent.u() == 0 ) return;
		atom_type_cent( 1) =  3; // CNH2
		atom_type_cent( 2) =  3; // COO
		atom_type_cent( 3) =  3; // CH1
		atom_type_cent( 4) =  3; // CH2
		atom_type_cent( 5) =  3; // CH3
		atom_type_cent( 6) =  3; // aroC
		atom_type_cent( 7) =  1; // Ntrp
		atom_type_cent( 8) =  1; // Nhis
		atom_type_cent( 9) =  1; // NH2O
		atom_type_cent(10) =  1; // NLYS
		atom_type_cent(11) =  1; // Narg
		atom_type_cent(12) =  1; // Npro
		atom_type_cent(13) =  5; // OH
		atom_type_cent(14) =  5; // ONH2
		atom_type_cent(15) =  5; // OOC
		atom_type_cent(16) =  5; // S
		atom_type_cent(17) =  1; // Nbb
		atom_type_cent(18) =  3; // CAbb
		atom_type_cent(19) =  3; // CObb
		atom_type_cent(20) =  5; // OCbb
		atom_type_cent(21) =  3; // Phos
		atom_type_cent(22) = -1; // Hpol
		atom_type_cent(23) = -1; // Hapo
		atom_type_cent(24) = -1; // Haro
		atom_type_cent(25) = -1; // HNbb
		if ( atom_type_cent.u() == 25 ) return;
		atom_type_cent(26) =  5; // H2O
		if ( atom_type_cent.u() == 26 ) return;
		atom_type_cent(27) =  3; // F
		atom_type_cent(28) =  3; // Cl
		atom_type_cent(29) =  3; // Br
		atom_type_cent(30) =  3; // I
		atom_type_cent(31) =  3; // Zn2p
		atom_type_cent(32) =  3; // Fe2p
		atom_type_cent(33) =  3; // Fe3p
		atom_type_cent(34) =  3; // Mg2p
		atom_type_cent(35) =  3; // Ca2p
		atom_type_cent(36) =  3; // Na1p
		atom_type_cent(37) =  3; // K1p
		atom_type_cent(38) =  3; // Au, ?
		atom_type_cent(39) =  5; // O in ice,? Kosta Makrodimitris 11/2005
		atom_type_cent(40) = -1; // H in ice,?
		atom_type_cent(41) =  3; // Si in Quartz ?
		atom_type_cent(42) =  5; // O in Quartz ? Kosta Makrodimitris 11/2005
		atom_type_cent(43) =  5; // O in phosphate O=P, Kosta Makrodimitris 11/2005
		atom_type_cent(44) =  5; // O in phosphate O-H,O-C Kosta Makrodimitris 11/2005
		atom_type_cent(45) = -1; // H in phosphate H-O, Kosta Makrodimitris 11/2005
		atom_type_cent(46) =  1; //  P/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_cent(47) =  5; // OP/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_cent(48) =  5; // OH/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_cent(49) = -1; // HO/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_cent(50) =  3; // CS1 sugar atoms, bkidd
		atom_type_cent(51) =  3; // CS2 sugar atoms, bkidd
		atom_type_cent(52) =  3; // CS5 sugar atoms, bkidd
		atom_type_cent(53) =  3; // CS6 sugar atoms, bkidd
		atom_type_cent(54) =  5; // O5 sugar atoms,  bkidd
		atom_type_cent(55) = -1; //
		atom_type_cent(56) = -1; //
		atom_type_cent(57) = -1; //
		atom_type_cent(58) = -1; //
		atom_type_cent(59) = -1; //
		atom_type_cent(60) = -1; //
		atom_type_cent(61) = -1; //
		atom_type_cent(62) = -1; //
		atom_type_cent(63) = -1; //
		atom_type_cent(64) = -1; //
		atom_type_cent(65) = -1; //
		atom_type_cent(66) = -1; //
		atom_type_cent(67) = -1; //
		atom_type_cent(68) = -1; //
		atom_type_cent(69) = -1; //
		atom_type_cent(70) = -1; //
		atom_type_cent(71) = -1; //
	}

	void
	atom_type_virt_initializer( FArray1D_int & atom_type_virt )
	{ //mj atom_type_virt state of different atom types
		if ( atom_type_virt.u() == 0 ) return;
		atom_type_virt( 1) =  1; // CNH2
		atom_type_virt( 2) =  2; // COO
		atom_type_virt( 3) =  3; // CH1
		atom_type_virt( 4) =  4; // CH2
		atom_type_virt( 5) =  5; // CH3
		atom_type_virt( 6) =  6; // aroC
		atom_type_virt( 7) =  7; // Ntrp
		atom_type_virt( 8) =  8; // Nhis
		atom_type_virt( 9) =  9; // NH2O
		atom_type_virt(10) = 10; // NLYS
		atom_type_virt(11) = 11; // Narg
		atom_type_virt(12) = 12; // Npro
		atom_type_virt(13) = 13; // OH
		atom_type_virt(14) = 14; // ONH2
		atom_type_virt(15) = 15; // OOC
		atom_type_virt(16) = 16; // S
		atom_type_virt(17) = 17; // Nbb
		atom_type_virt(18) = 18; // CAbb
		atom_type_virt(19) = 19; // CObb
		atom_type_virt(20) = 20; // OCbb
		atom_type_virt(21) = 21; // Phos
		atom_type_virt(22) = 22; // Hpol
		atom_type_virt(23) = 23; // Hapo
		atom_type_virt(24) = 24; // Haro
		atom_type_virt(25) = 25; // HNbb
		if ( atom_type_virt.u() == 25 ) return;
		atom_type_virt(26) = 26; // H2O
		if ( atom_type_virt.u() == 26 ) return;
		atom_type_virt(27) = 27; // F
		atom_type_virt(28) = 28; // Cl
		atom_type_virt(29) = 29; // Br
		atom_type_virt(30) = 30; // I
		atom_type_virt(31) = 31; // Zn2p
		atom_type_virt(32) = 32; // Fe2p
		atom_type_virt(33) = 33; // Fe3p
		atom_type_virt(34) = 34; // Mg2p
		atom_type_virt(35) = 35; // Ca2p
		atom_type_virt(36) = 36; // Na1p
		atom_type_virt(37) = 37; // K1p
		atom_type_virt(38) = 38; // Au
		atom_type_virt(39) = 39; // O in ice
		atom_type_virt(40) = 40; // H in ice
		atom_type_virt(41) = 41; // Si in quartz
		atom_type_virt(42) = 42; // O in quartz
		atom_type_virt(43) = 43; // O in phosphate O=P, Kosta Makrodimitris 10/2005
		atom_type_virt(44) = 44; // O in phosphate O-H, O-C Kosta Makrodimitris 11/2005
		atom_type_virt(45) = 45; // H in phosphate H-O, Kosta Makrodimitris 10/2005
		atom_type_virt(46) = 46; // P/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_virt(47) = 47; // OP/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_virt(48) = 48; // OH/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_virt(49) = 49; // HO/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atom_type_virt(50) = 50; // CS1 sugar atoms, bkidd
		atom_type_virt(51) = 51; // CS2 sugar atoms, bkidd
		atom_type_virt(52) = 52; // CS5 sugar atoms, bkidd
		atom_type_virt(53) = 53; // CS6 sugar atoms, bkidd
		atom_type_virt(54) = 54; // O5 sugar atoms, bkidd
		atom_type_virt(55) = 15; //
		atom_type_virt(56) =  2; //
		atom_type_virt(57) = 20; //
		atom_type_virt(58) = 17; //
		atom_type_virt(59) = 19; //
		atom_type_virt(60) = 13; //
		atom_type_virt(61) =  3; //
		atom_type_virt(62) = 16; //
		atom_type_virt(63) =  3; //
		atom_type_virt(64) = 11; //
		atom_type_virt(65) = 11; //
		atom_type_virt(66) = 10; //
		atom_type_virt(67) =  3; //
		atom_type_virt(68) =  8; //
		atom_type_virt(69) =  8; //
		atom_type_virt(70) =  3; //
		atom_type_virt(71) = 22; //
	}

	void
	atomtype_sasapolarity_initializer( FArray1D_int & atomtype_sasapolarity )
	{ // polarity of different atom types for sasa calculations
		if ( atomtype_sasapolarity.u() == 0 ) return;
		atomtype_sasapolarity( 1) = APOLAR; // CNH2
		atomtype_sasapolarity( 2) = APOLAR; // COO
		atomtype_sasapolarity( 3) = APOLAR; // CH1
		atomtype_sasapolarity( 4) = APOLAR; // CH2
		atomtype_sasapolarity( 5) = APOLAR; // CH3
		atomtype_sasapolarity( 6) = APOLAR; // aroC
		atomtype_sasapolarity( 7) = POLAR;  // Ntrp
		atomtype_sasapolarity( 8) = POLAR;  // Nhis
		atomtype_sasapolarity( 9) = POLAR;  // NH2O
		atomtype_sasapolarity(10) = POLAR;  // NLYS
		atomtype_sasapolarity(11) = POLAR;  // Narg
		atomtype_sasapolarity(12) = APOLAR; // Npro
		atomtype_sasapolarity(13) = POLAR;  // OH
		atomtype_sasapolarity(14) = POLAR;  // ONH2
		atomtype_sasapolarity(15) = POLAR;  // OOC
		atomtype_sasapolarity(16) = POLAR;  // S // jss: intentionally != hbond polarity
		atomtype_sasapolarity(17) = POLAR;  // Nbb
		atomtype_sasapolarity(18) = APOLAR; // CAbb
		atomtype_sasapolarity(19) = APOLAR; // CObb
		atomtype_sasapolarity(20) = POLAR;  // OCbb
		atomtype_sasapolarity(21) = APOLAR; // Phos changed from POLAR mj 10/15/2003
		atomtype_sasapolarity(22) = POLAR;  // Hpol
		atomtype_sasapolarity(23) = APOLAR; // Hapo
		atomtype_sasapolarity(24) = APOLAR; // Haro
		atomtype_sasapolarity(25) = APOLAR; // HNbb
		if ( atomtype_sasapolarity.u() == 25 ) return;
		atomtype_sasapolarity(26) = POLAR;  // H2O
		if ( atomtype_sasapolarity.u() == 26 ) return;
		atomtype_sasapolarity(27) = APOLAR; // F
		atomtype_sasapolarity(28) = APOLAR; // Cl
		atomtype_sasapolarity(29) = APOLAR; // Br
		atomtype_sasapolarity(30) = APOLAR; // I
		atomtype_sasapolarity(31) = POLAR;  // Zn2p
		atomtype_sasapolarity(32) = POLAR;  // Fe2p
		atomtype_sasapolarity(33) = POLAR;  // Fe3p
		atomtype_sasapolarity(34) = POLAR;  // Mg2p
		atomtype_sasapolarity(35) = POLAR;  // Ca2p
		atomtype_sasapolarity(36) = POLAR;  // Na1p
		atomtype_sasapolarity(37) = POLAR;  // K1p
		atomtype_sasapolarity(38) = POLAR;  // Au
		atomtype_sasapolarity(39) = POLAR;  // O in ice
		atomtype_sasapolarity(40) = APOLAR;  // H in ice //Hpol Kosta Makrodimitris 11/2005
		atomtype_sasapolarity(41) = POLAR;  // Si in Quartz
		atomtype_sasapolarity(42) = POLAR;  // O in quartz
		atomtype_sasapolarity(43) = POLAR;  // O in phosphate O=P, Kosta Makrodimitris 10/2005
		atomtype_sasapolarity(44) = POLAR;  // O in phosphate O-H,O-C Kosta Makrodimitris 11/2005
		atomtype_sasapolarity(45) = APOLAR;  // H (Hpol) in phosphate H-O, Kosta Makrodimitris 10/2005
		atomtype_sasapolarity(46) = APOLAR;  //  P/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atomtype_sasapolarity(47) = POLAR;  // OP/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atomtype_sasapolarity(48) = POLAR;  // OH/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atomtype_sasapolarity(49) = APOLAR;  // HO/ HA, (Hpol) S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		atomtype_sasapolarity(50) = APOLAR; // CS1 sugar atoms, bkidd
		atomtype_sasapolarity(51) = APOLAR; // CS2 sugar atoms, bkidd
		atomtype_sasapolarity(52) = APOLAR; // CS5 sugar atoms, bkidd
		atomtype_sasapolarity(53) = APOLAR; // CS6 sugar atoms, bkidd
		atomtype_sasapolarity(54) = POLAR;  // O5 sugar atoms, bkidd
		atomtype_sasapolarity(55) = APOLAR; //
		atomtype_sasapolarity(56) = APOLAR; //
		atomtype_sasapolarity(57) = APOLAR; //
		atomtype_sasapolarity(58) = APOLAR; //
		atomtype_sasapolarity(59) = APOLAR; //
		atomtype_sasapolarity(60) = APOLAR; //
		atomtype_sasapolarity(61) = APOLAR; //
		atomtype_sasapolarity(62) = APOLAR; //
		atomtype_sasapolarity(63) = APOLAR; //
		atomtype_sasapolarity(64) = APOLAR; //
		atomtype_sasapolarity(65) = APOLAR; //
		atomtype_sasapolarity(66) = APOLAR; //
		atomtype_sasapolarity(67) = APOLAR; //
		atomtype_sasapolarity(68) = APOLAR; //
		atomtype_sasapolarity(69) = APOLAR; //
		atomtype_sasapolarity(70) = APOLAR; //
		atomtype_sasapolarity(71) = APOLAR; //
	}

	void
	charge_initializer( FArray1D_float & charge )
	{
		//mj a very trivial approxiamtion from charmm27 charges
		//mj to do electrostatics in fullatom mode ligand interactions
		//cmd charge assignment data for heteroatoms (ligands)
		//cmd explicit charge assignments for amino acids in read_aaproperties.cc
		if ( charge.u() == 0 ) return;
		charge( 1) =  0.550; // CNH2
		charge( 2) =  0.620; // COO
		charge( 3) = -0.090; // CH1
		charge( 4) = -0.180; // CH2
		charge( 5) = -0.270; // CH3
		charge( 6) = -0.115; // aroC
		charge( 7) = -0.610; // Ntrp
		charge( 8) = -0.530; // Nhis
		charge( 9) = -0.470; // NH2O
		charge(10) = -0.620; // NLYS
		charge(11) = -0.750; // Narg
		charge(12) = -0.370; // Npro
		charge(13) = -0.660; // OH
		charge(14) = -0.550; // ONH2
		charge(15) = -0.760; // OOC
		charge(16) = -0.160; // S
		charge(17) = -0.470; // Nbb
		charge(18) =  0.070; // CAbb
		charge(19) =  0.510; // CObb
		charge(20) = -0.510; // OCbb
		charge(21) =  1.500; // Phos //DNA CHARMM27, Kosta Makrodimitris 11/2005
		charge(22) =  0.430; // Hpol
		charge(23) =  0.095; // Hapo
		charge(24) =  0.115; // Haro
		charge(25) =  0.310; // HNbb
		if ( charge.u() == 25 ) return;
		charge(26) =  0.000; // H2O
		if ( charge.u() == 26 ) return;
		charge(27) = -0.250; // F
		charge(28) = -0.130; // Cl
		charge(29) = -0.100; // Br
		charge(30) = -0.090; // I
		charge(31) =  2.000; // Zn2p
		charge(32) =  2.000; // Fe2p
		charge(33) =  3.000; // Fe3p
		charge(34) =  2.000; // Mg2p
		charge(35) =  2.000; // Ca2p
		charge(36) =  1.000; // Na1p
		charge(37) =  1.000; // K1p
		charge(38) =  0.000; // Au
		charge(39) = -0.834; // O in ice, TIP3p
		charge(40) =  0.417; // H in ice, TIP3p
		charge(41) =  2.400; // Si in quartz, Phys Rev Lett Volume 64 Number 16 Page 1955-1958
		charge(42) = -1.200; // O in quartz, Phys Rev Lett Volume 64 Number 16 Page 1955-1958
		charge(43) = -0.780; // O in phosphate O=P, CHARMM27, Kosta Makrodimitris 10/2005
		charge(44) = -0.570; // O in phosphate O-C CHARMM27, Kosta Makrodimitris 11/2005
		charge(45) =  0.340; // H in phosphate H-O, CHARMM27, Kosta Makrodimitris 10/2005
		charge(46) =  2.600; //  P/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		charge(47) = -1.400; // OP/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		charge(48) = -1.600; // OH/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		charge(49) =  0.600; // HO/ HA, S.Hauptmann PCCP 2003 & CHARMM27, Kosta Makrodimitris 11/2005
		charge(50) =  0.200; // CS1 sugar atoms, bkidd
		charge(51) =  0.140; // CS2 sugar atoms, bkidd
		charge(52) =  0.250; // CS5 sugar atoms, bkidd
		charge(53) =  0.050; // CS6 sugar atoms, bkidd
		charge(54) = -0.400; // O5 sugar atoms, bkidd
		charge(55) =  0.000; //
		charge(56) =  0.000; //
		charge(57) =  0.000; //
		charge(58) =  0.000; //
		charge(59) =  0.000; //
		charge(60) =  0.000; //
		charge(61) =  0.000; //
		charge(62) =  0.000; //
		charge(63) =  0.000; //
		charge(64) =  0.000; //
		charge(65) =  0.000; //
		charge(66) =  0.000; //
		charge(67) =  0.000; //
		charge(68) =  0.000; //
		charge(69) =  0.000; //
		charge(70) =  0.000; //
		charge(71) =  0.000; //
	}

	FArray1D_string const atom_type_name( MAX_ATOMTYPES(), atom_type_name_initializer );
	FArray1D_int const hybridization( MAX_ATOMTYPES(), hybridization_initializer );
	FArray1D_int const HBdonchemtype( MAX_ATOMTYPES(), HBdonchemtype_initializer );
	FArray1D_int const HBaccchemtype( MAX_ATOMTYPES(), HBaccchemtype_initializer );
	FArray1D_int const atom_type_cent( MAX_ATOMTYPES(), atom_type_cent_initializer );
	FArray1D_int const atom_type_virt( MAX_ATOMTYPES(), atom_type_virt_initializer );
	FArray1D_int const atomtype_sasapolarity( MAX_ATOMTYPES(), atomtype_sasapolarity_initializer );
	FArray1D_float const charge( MAX_ATOMTYPES(), charge_initializer ); // generic partial atom charges
}

namespace param_aa_variant {
//bq number of aav type
	int const number_aav_type = { 6 };
//bq aav types
	int const aav_base       = { 1 };
	int const aav_his_taut   = { 2 };
	int const aav_Nterm      = { 3 };
	int const aav_Cterm      = { 4 };
	int const aav_water      = { 5 };
	int const aav_pH         = { 6 };
}


namespace aa_variant_properties {
	FArray3D_bool variant_type( number_aav_type, MAX_AA(), MAX_AA_VARIANTS(), false );
}


namespace pair_cutoffs {
	FArray2D_float paircutoff( MAX_AA(), MAX_AA() );
}


int const APOLAR = { 0 };
int const POLAR = { 1 };


//chu add a table indicating whether two atoms within the same residue should
//chu be counted for pairwise interaction. atom_base is the array telling the
//   bond connectivity information

namespace intra_cp {
	FArray4D_float intra_cp_table( MAX_ATOM(), MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
}


namespace termini_properties {

	int Nterm_natoms; // number of atoms at the N_term
	int Cterm_natoms; // number of atoms at the C_term

	FArray2D_float Nterm_icoor( 3, MAX_ATOM() ); // template coordinates of N_term
	FArray2D_float Cterm_icoor( 3, MAX_ATOM() ); // template coordinates of C_term

	FArray2D_float Nterm_icoor_pro( 3, MAX_ATOM() ); // template coordinates of proline N_term

	FArray1D_string Nterm_atom_name( MAX_ATOM(), std::string( 4, ' ' ) );
	FArray1D_string Cterm_atom_name( MAX_ATOM(), std::string( 4, ' ' ) );
}


}
